
/* Generic ftp source with flow control. */

#include "../kernel/real.h"
#define MWS MAX_WINDOW_SIZE
#define RECOVERY_STATE 1 	/* the source is retransmitting lost packets */
#define NORMAL_STATE 0 		/* otherwise */

generic()
 /* no window adjustment or timeout deviation estimation */
{
    /* Misc. variables */
    PKT_PTR         pkt;
    int             num, node, line_busy = 0;
    ident           destn, sender, sink;
    long            key;
    timev           now, gen, diff;
    float           err, timeout;

    /* state variables */
    timev           time_sent[MWS];
    float           rtt;
    int             last_sent,last_ack, seq_no, min_window;

    int             ftp_state;
	/* either normal or recovery */
    int             recovery_can_send;
	/* flag used to allow only one pkt to be sent after a timeout */
	/* once tis happens, either the retx. pkt must timeout again,
	 * or the retx. pkt should acked, which will reset the flag */
    int             timer_id = 1;
    int             max_window;
    float	    beta_rtt = 2.0;

    /* dont let any simulation time pass while the node executes */


    node = get_node_id ();
    sink = assigned_sink[node];
    abs_advance (node_start_time[node]);
    max_window = ftp_window;
    printf ("Generic source: %d ", get_node_id ());
    printf ("sending to sink %d\n", sink);

    source_node_type[node] = GENERIC_SOURCE;

    last_sent = last_ack = -1;
    rtt = 6.0 * scale_factor;
    timeout = beta_rtt * rtt;
    seq_no = 0;
    alpha_rtt_ftp = (float) (1 / (float) 10.0);

    recovery_can_send = 0;
    ftp_state = NORMAL_STATE;

    /* pretend that you got  an INT pkt, go to test */

    goto test;
    for (ever)
    {
	/* point where data is received */
recv:
	sender = recvm (&destn, &key, &pkt);
	now = runtime ();
	/* use packet type to decide what to do */
	switch (pkt->type)
	{

	case ACK:
	    {
		float           tao;
		int             i, last;

		if (pkt->seq_no is last_sent)
		    ftp_state = NORMAL_STATE;

		/* last_ack is the highest seq_no that has been acked */
		if (pkt->seq_no > last_ack)
		{
		    /* ack not seen before */
		    last = last_ack;
		    /* it might be an ack for more than one packet */
		    for (i = 1; i <= pkt->seq_no - last; i++)
		    {
			diff = time_minus (now, time_sent[(last_ack + i) % MWS]);
			/* actual round trip time */
			tao = make_float (diff);
			/* estimated round trip time */
			rtt = rtt + alpha_rtt_ftp * (tao - rtt);
		        timeout = beta_rtt * rtt;
			/* plot data */
			make_entry (tao, &rt_time[node]);
		    }
		    /* update state */
		    last_ack = pkt->seq_no;
		    recovery_can_send = 1;
		}
		/* get rid of the ack packet */
		free (pkt);

		/* clean up queue -- i.e. remove all acked packets */

		num = num_in_q (node);
		while (num-- > 0)
		{
		    pkt = deq (node);
		    if (pkt->seq_no > last_ack)
			enq (node, pkt);
		    else
			free (pkt);
		}
		goto test;
	    }
	case INT:
	    /* line is now free */
	    line_busy = 0;
	    free (pkt);
	    goto test;

	case TIMEOUT:
	    /* may have been acked */
	    if (timer_id is pkt->id and pkt->seq_no > last_ack)
	    {
		/* resend */
		ftp_state = RECOVERY_STATE;
		recovery_can_send = 1;
		pkt->type = DATA;
		pkt->seq_no = last_ack + 1;
		diff = time_minus(now, pkt->gen_time);
		timeout = 2*make_float(diff);
		pkt->gen_time = runtime ();
		pkt->resent = 1;
		enq (node, pkt);
	    } else
		/* dump pkt */
		free (pkt);
	    goto test;
	default:
	    free (pkt);
	    pr_error ("Node %d recvd. a pkt of unknown type", node);
	}
test:
	if ((ftp_state is NORMAL_STATE and seq_no <= last_ack + max_window))
	{
	    num = num_in_q (node);
	    if (num is 0)
	    {
		make_pkt(pkt);
		pkt->gen_time = runtime ();
		pkt->seq_no = (seq_no)++;
		pkt->resent = 0;
		enq (node, pkt);
	    }
	}
	num = num_in_q (node);
	while (--num >= 0)
	{
	    pkt = deq (node);
	    if (((ftp_state is NORMAL_STATE and
		 pkt->seq_no <= last_ack + max_window)
		or (ftp_state is RECOVERY_STATE and recovery_can_send))
		and !line_busy and pkt isnt NULL)
	    {
		line_busy = 1;
		time_sent[pkt->seq_no % MWS] = runtime ();
		pkt->id = ++timer_id;
		if(pkt->resent) 
			num_retransmissions[node]++;
		if(pkt->seq_no > last_sent)
		    last_sent = pkt->seq_no;
		safe_send (pkt, timeout);
		recovery_can_send = 0;
		break;
	    } else if (pkt != NULL)
		enq (node, pkt);
	}
	goto recv;
    }
}

