/*This code is based on Arizona's Vegas TCP/IP. Written by 
O. Ait-Hellal by changing Jacobson-Karels FTP source. 
Originally written by S. Keshav. Revised by S. McCanne@LBL */

#include <math.h>
#include <stdio.h>
#include "real.h"

extern int      PLOT_ON;
extern int  num_in_op_q[MAX_NODES +1][MAX_CONVERSATIONS];
 
#define   beta_thresh 4
    
    /* max extrat buffers in the network (Vegas 2-4) */
#define  alpha_thresh 2
    
    /*      min extrat buffers in the network       */
#define  gamma_thresh 1
    
    /*           threshold at slow-start             */ 

#define TCP_MAX_RT_SHIFT 13
int             DEBUG, RTT_DEBUG, CONGESTION_DEBUG;

int             vegas_backoff[TCP_MAX_RT_SHIFT] =
{1, 2, 4, 8, 16, 32, 64, 64, 64, 64, 64, 64, 64};

int             old_sent, oflag, num_retx;
float           sendTime;

static void     vegas_send ();
static void     vegas_timeout ();
static void     vegas_ack ();


/* TCB: Tcp Control Bloc Structure: all variables used by tcp */
struct frame
{
  PKT_PTR         pkt;

  /* in BSD, packets are queued for retransmissions (prev, next). 
     Here we create a packet every time we need to retransmit it */
  int             nn;

  /* identificator of the node (soure) */
  int             back_off;

  /* exponential multiplier for timeout retransmissions */
  int             transmits[MAX_WINDOW_SIZE];

  /* largest number an acked segment was sent */
  int             line_busy;

  /* (simulation) respect of the interpacket delay */
  int             num_dup_acks;

  /* number of consecutive duplicate acks seen so far */
  int             rexmtthresh;

  /* number of consecutive dup acks for retransmit a packet */
  char            retxed[MAX_WINDOW_SIZE];

  /* if it is set, don't update the round trip time for this packet */
  char            dropped[MAX_WINDOW_SIZE];

  /* estimate timeout for every packet sent (not coarser)*/
  int             fr_thresh;

  /* Problem of successive fast retransmits, don't retransmit 
     more than one packet per window (not used in vegas) */
  int             last_sent;

  /* last seq_no sent */
  int             max_sent;

  /* Hightest seqno sent to recognize retransmissions */  
  timev           time_sent[MAX_WINDOW_SIZE];

  /* time that a packet was sent */
  float           round_trip_time;

  /* actually, the estimate */
  int             last_ack;

  /* last ack recvd at that node */
  int             cur_window;

  /* current window size */
  int             ssthresh ;

  /* threshold in slow start (in vegas it is only used in slow start) */
  float           count;

  /* for updating cwnd */
  float           mean_deviation;

  int             timer[MAX_WINDOW_SIZE];
  int             timer_id;

  /* allows to identify packets (or total number of packets sent) */
  int             max_window;

  /*   Variables, only used by Vegas    */   
  float           base_RTT;
 
  /*    the smaller round-trip-time                */

  /* Vegas timer stuff */
  float           v_rtt;
  float           v_sa;
  float           v_sd;
  float           v_timeout;

  int             num_ack_after_retx;

  /* sequence number of ack after retx is it the first or second */
  float           v_time_cwin_chg;	

  /* Time when congestion window was last decreased. Used to prevent
   *decreasing cwin more than once for losses which occurred at the                                        same cwin level */
  int	          v_newcwnd;
     	
  /* Stores new uninflated cwnd, used to reset cwnd later.*/

  /* Exp increase every other during slow-start. */
  int	          v_exp_inc_do;
  int	          v_exp_inc_flag;
  int	          v_exp_inc_isless;

  /* Congestion detection (or more correctly avoidance ) variables.
   * The mechanism checks once per RTT. Current RTT began with sequence
   * v_cong_detect_begseq */
  int	          v_cong_detect_do;     	
  
  /*whether to do it */	
  int	          v_cong_detect_begseq;		
  timev	          v_cong_detect_begtime;		

  /* When RTT began */
  int	          v_cong_detect_predict_do;
	
  /* Whether to predict the available bw during slow-start */
  timev	          v_cong_detect_last_sendtime;

  float	          v_cong_detect_sumRTT;

  /* Used to get average (avera = sumRTT/cntRTT) */
  int	          v_cong_detect_cntRTT;	

  /* number of rtt mesured during a RTT interval */

  /* The congestion window should stay within band. Going above
   * it means that not enough buffers are being used at the
   * bottleneck, so cwnd should increase. Going below the band means 
   * that too many buffers are being used, so cwnd should decrease. */
  int	          v_cong_detect_top_isless;	

  /* => cwnd < top of band */
  int	          v_cong_detect_bot_isless;	

  /* => cwnd < bot of band */
  float	          v_incr;	

  /* How much to increase cwnd when an ACK is received */
  int             Transmits;
   
};

vegas ()
{
    /* Dummy variables for nest that we don't use. */
    ident           sender, destn;
    long            key;

timev now;

    struct frame    f;
    so_ack=fopen("so.ack","wt");
    so_rate = fopen("so.rate","wt");
    win_rtt = fopen("win.rtt","wt");

    bzero ((char *) &f, sizeof f);

    f.nn = get_node_id ();
    abs_advance (node_start_time[f.nn]);
    f.max_window = ftp_window;
    f.timer_id = 1;

    printf ("Vegas ftp source: %d ", f.nn);
    printf ("sending to sink %d\n", assigned_sink[f.nn]);

    source_node_type[f.nn] = VEGAS_SOURCE;

    f.round_trip_time = f.v_time_cwin_chg = 0.0;
    f.mean_deviation = 1.5;
    f.cur_window = 1;
    f.ssthresh = ftp_window/2;
    f.last_sent = f.last_ack = f.max_sent = -1;
    f.count = 0.0;
    /* when it starts there is no retransmission */
    f.rexmtthresh = 3;
    f.num_dup_acks  = num_retx = f.num_ack_after_retx = 0;
 
    f.v_cong_detect_predict_do = 0; 
    f.v_exp_inc_do = 1;
    f.v_exp_inc_flag = 0;
    f.v_exp_inc_isless = 0;

    f.v_cong_detect_do = 1;
    f.v_cong_detect_begseq = 0;
    (f.v_cong_detect_begtime).tv_sec  = (f.v_cong_detect_begtime).tv_usec = 0;
    f.base_RTT = 1000.0;
    f.v_cong_detect_sumRTT = 0.0;
    f.v_cong_detect_cntRTT = 0;
    f.v_cong_detect_top_isless = 0;
    f.v_cong_detect_bot_isless = 0;
    f.v_incr = 0.0;
    f.v_timeout = 1000;
    f.v_sa = 300 << 3;/* multiplie par 8 */
    f.v_rtt = f.v_sd = 0.0;
    losses1 = 0;

    /* send the first packet */
    vegas_send (&f);

    while (1)
    {
	sender = recvm (&destn, &key, &f.pkt);
	switch (f.pkt->type)
	{

	case ACK:
	    vegas_ack (&f);
	    vegas_send (&f);
	    break;

	case INT:
	    hold ();
	    f.line_busy = 0;
	    free (f.pkt);
	    release (1);
	    vegas_send (&f);
	    break;

	case TIMEOUT:
	    vegas_timeout (&f);
	    break;

	case DROPPED:

	    /* This packet has been dropped, so when it times out, it
	     * should be retransmitted. This is indicated by setting the
	     * 'dropped' bit. */
	    f.dropped[f.pkt->seq_no % MAX_WINDOW_SIZE] = 1;
	    hold ();
	    free (f.pkt);
	    release (1);
	    break;

	default:
	    hold ();
	    free (f.pkt);
	    release (1);
	    pr_error ("Vegas_source recvd. a vague pkt ");
	    break;
	}
    }
}

/* We let timeout inchanged, we compute it as does VJ */
static float
timeout (fp)
    struct frame   *fp;
{
    float           timeout;

    timeout = fp->round_trip_time;
    timeout += beta_rtt * fp->mean_deviation;
    timeout += fp->round_trip_time * RANDOM;
    timeout += 0.5;
    timeout = coarser (timeout);
    timeout *= vegas_backoff[fp->back_off];

    return timeout;
}

/* It is usually called for sending data equiva to vtcp_output.c BSD */
static void vegas_send (fp)
    struct frame   *fp;
{
    PKT_PTR         pkt;
    int             nn = fp->nn;
    int             nqueued;
    int             win;
    /* sanity */
    fp->pkt = 0;

    win = min (fp->cur_window, fp->max_window);
    
    if (PLOT_ON)
      make_plot("win", win);

    
    nqueued = num_in_q (fp->nn);

    while (--nqueued >= 0)
    {
	/* Send the timeout or fast rexmt packet; but only if an ack has
	 * not been received in the interim. */
	pkt = deq (nn);
	if (pkt->seq_no > fp->last_ack)
	{
	    /* ok to send , even if later */
	    if (pkt->seq_no <= fp->last_ack + win)
	    {
	      sendTime = make_float(fp->time_sent[pkt->seq_no % MAX_WINDOW_SIZE]);
	      /* ok to send now */
	      fp->retxed[pkt->seq_no % MAX_WINDOW_SIZE] = 1;
	      pkt->gen_time = runtime ();
	      fp->dropped[pkt->seq_no % MAX_WINDOW_SIZE] = 0;
	      ++num_retransmissions[nn];
	      /* ack after last retransmission 0 */
	      fp->num_ack_after_retx = min(2,fp->last_sent-fp->last_ack-1);
	      
	      fp->line_busy = 1;
	      fp->timer[pkt->seq_no % MAX_WINDOW_SIZE] = pkt->id =
		fp->timer_id++;
	      old_sent = fp->last_sent;
	      vegas_safe_send (pkt, timeout (fp),
				  fp);
		if (fp->last_sent < old_sent)
		  fp->last_sent = old_sent;
		if (sendTime > fp->v_time_cwin_chg)
		  fp->v_time_cwin_chg = make_float(runtime ());
		fp->time_sent[pkt->seq_no % MAX_WINDOW_SIZE] = runtime ();
		return;
	    } else
		/* save for later */
		enq (nn, pkt);
	} else
	{
	    hold ();
	    free (pkt);
	    release (1);
	}
	/* drop pkt on the floor */
    }
    if (fp->line_busy)
      return;

    if (fp->last_sent < fp->last_ack + win )
    {

	hold ();
	pkt = (PKT_PTR) calloc (1,(unsigned) sizeof (PKT));
	release (1);

	pkt->size = ftp_size;
	pkt->gen_time = runtime ();
	pkt->type = Vegas;

	pkt->seq_no = max (fp->last_sent, fp->last_ack) + 1;
	
	pkt->dest = assigned_sink[nn];
	if (pkt->dest < ABSOLUTE_MAX_NODES)
	    pkt->dest += ABSOLUTE_MAX_NODES * realnum;
	pkt->alpha = alpha_f;
	pkt->source = realnum * ABSOLUTE_MAX_NODES + nn;

	fp->dropped[pkt->seq_no % MAX_WINDOW_SIZE] = 0;

	fp->line_busy = 1;
	fp->timer[pkt->seq_no % MAX_WINDOW_SIZE] = pkt->id = fp->timer_id++;

	vegas_safe_send (pkt, timeout (fp), fp);
	fp->time_sent[pkt->seq_no % MAX_WINDOW_SIZE] = runtime ();
	fp->v_cong_detect_last_sendtime = runtime ();
    }
}

/* Timeout occurs, equivalent to vtcp_timer.c BSD */
static void
vegas_timeout (fp)
    struct frame   *fp;
{
    PKT_PTR         pkt = fp->pkt;
    int             seqno = pkt->seq_no;
    make_plot("timeout", seqno);
    if (seqno > fp->last_ack && seqno <= fp->last_sent
	&& fp->timer[seqno % MAX_WINDOW_SIZE] == pkt->id)
    {
      
      if (fp->back_off < TCP_MAX_RT_SHIFT - 1)
	++fp->back_off;
      if (fp->back_off > TCP_MAX_RT_SHIFT / 4)
	{
	  fp->mean_deviation += fp->round_trip_time;
	  fp->round_trip_time = 0;
	}
      
      fp->retxed[seqno % MAX_WINDOW_SIZE] = 1;
      /* retxed used as a dirty bit to allow us to ignore corrupted tao
       * values */
      seqno = fp->last_ack + 1;
      fp->fr_thresh = seqno;
      pkt->type = Vegas;
      pkt->seq_no = fp->last_sent = seqno;
      fp->ssthresh = fp->cur_window/2;
      if (fp->ssthresh < 2)
	fp->ssthresh = 2;
      fp->cur_window = 2;
      fp->num_dup_acks = 0;
      fp->count = 0.0;
  
      if (seqno <= fp->last_ack + fp->cur_window && !fp->line_busy)
	{
	  pkt->gen_time = runtime ();
	  fp->dropped[seqno % MAX_WINDOW_SIZE] = 0;
	  ++num_retransmissions[fp->nn];
	  fp->line_busy = 1;
	  fp->timer[seqno % MAX_WINDOW_SIZE] = pkt->id = fp->timer_id++;
	  vegas_safe_send (pkt, timeout (fp), fp);
	  fp->time_sent[seqno % MAX_WINDOW_SIZE] = runtime ();
	  fp->v_time_cwin_chg = make_float(runtime ());
	} else
	  enq (fp->nn, pkt);
    } else
      {

	hold ();
	free (pkt);
	release (1);
      }
}

/* when we receive an ack equivalent to vtcp_input.c BSD */
static void
vegas_ack (fp)
    struct frame   *fp;
{
    PKT_PTR         pkt;
    float           delta_var;
    float           tao;
    float           err;
    timev           now, diff, old;
    int             i, last;

    now = runtime ();

    pkt = fp->pkt;
    last = fp->last_ack;
  
    /* VAN-J */

    if (pkt->seq_no > last)
      { /* ack not seen before */
	/* number of no duplicate acks after retransmission */

	if (fp->num_dup_acks > fp->rexmtthresh && 
	    fp->cur_window > fp->v_newcwnd){
	  fp->cur_window = fp->v_newcwnd;
	    /* In vegas, ssthresh is only used during slow-start*/
	  fp->ssthresh = 2;
	}  
	fp->num_dup_acks = 0;
	
	if (CONGESTION_DEBUG || DEBUG)
	  printf ("(%d,%d)Source %d :current window size is % d and ssthresh is % d \ n ", now.tv_sec, now.tv_usec, fp->nn, fp->cur_window, fp->ssthresh);
		  
	for (i = 1; i <= pkt->seq_no - last; ++i)
	  {
	    /* KARN */
	    if (!fp->retxed[(last + i) % MAX_WINDOW_SIZE])
	      {
		/* if pkt has been retxed - ignore the tao */
		fp->back_off = 0;
		/* yet another kludge - if an ack acknowledges more than
		 * one packet then ignore all but last tao */
		if (pkt->seq_no is last + 1)
		  {
		    old = fp->time_sent[(last + i) % MAX_WINDOW_SIZE];
		    diff = time_minus (now, old);
		    tao = make_float (diff);
		    
		    if (fp->round_trip_time is 0.0)
		      fp->round_trip_time = tao;

		    /*first packet sent, update v_timeout */
		    if (fp->v_timeout == 1000) {
		      fp->v_rtt = tao;
		      fp->v_sa = fp->v_rtt*8;
		      fp->v_sd = fp->v_rtt;
		      fp->v_timeout = ((fp->v_sa/4) + fp->v_sd)/2;
		    } 
		    
		    if (PLOT_ON)
		      make_flt_plot ("tao", tao);
		    
		    make_entry (tao, &rt_time[fp->nn]);
		    /* VAN-J */
		    err = tao - fp->round_trip_time;
		    if (err < 0)
		      err = -err;
#define ALPHA_RTT 0.1
		    fp->round_trip_time += ALPHA_RTT *
		      (tao - fp->round_trip_time);
		    /* Van says 0.25. */
		    fp->mean_deviation += 0.25 *
		      (err - fp->mean_deviation);
		    if (DEBUG || RTT_DEBUG)
		      {
			printf ("Source %d : (%d,%d)Seq # %d :tao was %f\n",get_node_id (), now.tv_sec, now.tv_usec,pkt->seq_no, tao);
			printf ("round trip time re-estimated as %f and deviation was %f\n\n", fp->round_trip_time, fp->mean_deviation);
		      }
		  }
	      }
	    /* reset the bit anyhow */
	    fp->retxed[(last + i) % MAX_WINDOW_SIZE] = 0;
	  }
	fp->last_ack += pkt->seq_no - last;
	if (fp->last_ack > fp->last_sent)
	  fp->last_sent = fp->last_ack;
	
	if (PLOT_ON)
	  {
	    make_flt_plot ("rtt", fp->round_trip_time);
	    make_flt_plot ("dev", fp->mean_deviation);
	  }
	/* when new data is acked, vegas add congestion detection/avoidance
	 * so we may not only increase the congestion window, we may
	 * even decrease it before losses occur.
	 *
	 * once per RTT we need to do the congestion avoidance stuff, and
	 * the modified slow-start (only increasing every other RTT).
	 */
	  
	if (pkt->seq_no >= fp->v_cong_detect_begseq) {

	  float rtt, sendEpoch, actual_rate, pred_rate;
	  int rttlen, win;
    	  
	  if(fp->v_cong_detect_cntRTT > 0)
	    rtt = fp->v_cong_detect_sumRTT / fp->v_cong_detect_cntRTT;
	  else 
	    {
	      diff = time_minus(now, fp->time_sent[fp->v_cong_detect_begseq 
% MAX_WINDOW_SIZE]);
	      rtt = make_float(diff);

	    } 
	     
	  win = fp->v_cong_detect_cntRTT;
	  fp->v_cong_detect_sumRTT = 0.0;
	  fp->v_cong_detect_cntRTT = 0;
	  rttlen = fp->last_sent - fp->v_cong_detect_begseq + 1;

	  /* if there was only one packet in transit, then update
	   * base_RTT
	   */
	  if (rttlen <= 1 && rtt > 0)
	    fp->base_RTT = rtt;
	    
	  if (rtt > 0.0)
	    { 

	      /*these rates are in  pakets/sec, a time is given in secondes */
	      actual_rate = ((float)rttlen)/ rtt;
 	      pred_rate = ((float)(fp->last_sent + 1 - fp->last_ack))/fp->base_RTT;
	      /* If we are currently doing slow-start */
	      if (fp->cur_window < fp->ssthresh){
		/* chek if we are sending faster than available bandwith
		 */
		if ((pred_rate - actual_rate)*fp->base_RTT > gamma_thresh)
		  fp->v_exp_inc_isless = 1;
		else
		  fp->v_exp_inc_isless = 0;
		/* sendEpoch is the interval of time during which we sent
		 * data. during slow-start, we usually don't send
		 * during the whole RTT, only during part of beginning.
		 */
		diff = time_minus(fp->v_cong_detect_last_sendtime, 
				  fp->time_sent[fp->v_cong_detect_begseq % 
MAX_WINDOW_SIZE] );
		sendEpoch = make_float(diff);
		win = fp->cur_window - 1;
		/* If we trying to predict the available bandwith
		 * during slow-start
		 */
		if (fp->v_cong_detect_predict_do && sendEpoch > 0)
		  {
		    if (fp->v_exp_inc_do) {
		      if (fp->v_exp_inc_flag) {
			if (fp->cur_window >= 8) {
			  fp->ssthresh = (win*rtt)/(2*sendEpoch);
			  fp->v_cong_detect_predict_do = 0;
			}
		      }
		      else {
			if (fp->cur_window >= 4){
			 fp->ssthresh = (win*rtt)/(sendEpoch);
			 fp->v_cong_detect_predict_do = 0; 
			}
		      }
		    }
		    else if (fp->cur_window >= 8){
		      fp->ssthresh = (win*rtt)/(2*sendEpoch);
		      fp->v_cong_detect_predict_do = 0;
		    }
		    if (fp->ssthresh <= fp->cur_window)
		      fp->ssthresh = 2;
		  }
		fp->v_exp_inc_flag = !fp->v_exp_inc_flag;
	      }
	      /* chek if we are sending too slowly (using less than 
	       * alpha_thresh buffers)
	       */
	      if ((pred_rate - actual_rate)*fp->base_RTT > alpha_thresh)
		fp->v_cong_detect_top_isless = 1;
	      else 
		fp->v_cong_detect_top_isless = 0;

	      /* Chek if we are sending too fast (using more than 
	       * beta_thresh-thresh worth of buffers)
	       */
	      if ((pred_rate - actual_rate)*fp->base_RTT > beta_thresh)
		fp->v_cong_detect_bot_isless = 1;
	      else
		fp->v_cong_detect_bot_isless = 0;
	    }
	  fp->v_cong_detect_begseq = fp->last_sent + 1 ;
	  fp->v_cong_detect_begtime = runtime ();
	  
	  /* In vegas, the coongestion avoidance mechanism decides by how
	   * much data to inrease or dcrease the congestion window. During
	   * slow-start, the increase only happen during every other RTT,
	   * and then the increase is one segment, as long as we have not
	   * overran the available bandwith (v_exp_inc_isless==0).
	   * If we are not doing slow-start now, then if we need to send 
	   * faster (top_is_less == 0) we increase it by (1/cwnd), if
	   * we need to send slower, then we decrease cwnd by one
	   * immediately and we don't change the cwnd during the next RTT
	   */
	  if (fp->cur_window < fp->ssthresh){
	    /* slow-start */
	    if (fp->v_exp_inc_do){
	      /* congestion avoidance during slow-start */
	      if (!fp->v_exp_inc_flag)
		/* not increasing during this RTT */
		fp->v_incr = 0.0;
	      else if (fp->v_exp_inc_isless) {
		/* Going faster than avail bw, so slow down */
		fp->ssthresh = 2;
		fp->count  = -(float)(fp->cur_window % 8)/(float)8.0;
		fp->v_incr = 0.0;
		fp->cur_window -= (fp->cur_window/8.0);
		if (fp->cur_window < 2)
		  fp->cur_window = 2;
		
	      }
	      else
		/* increase by one with each ACK */
		fp->v_incr = 1.0;
		 
	    }
	    else 
	      /* not doing congestion avoidance during slow-start */
	      fp->v_incr = 1.0;

	  }/* end of doing slow-start */
	  else {
	    if (fp->v_cong_detect_do) {
	      /* doing congestion/detection avoidance */
	      if (fp->v_cong_detect_bot_isless) {
		/* slow down */
		fp->cur_window -= 1;
		if (fp->cur_window < 2)
		  fp->cur_window = 2;
		fp->v_incr = 0;
	      }
	      else if (fp->v_cong_detect_top_isless)
		/* the current rate is fine */
		fp->v_incr = 0;
		  else 
		    /* we can go faster */
		    fp->v_incr = 1.0/(float)fp->cur_window;
	    }
	    else
	      /* Not doing congestion detection/avoidance */
	      fp->v_incr = 1.0/(float)fp->cur_window;
	  }
	}/* end of code done once per RTT */
	if (fp->v_incr == 1.0 && fp->cur_window >= fp->ssthresh)
	  fp->v_incr = 0.0;
	/* increase congestion win */
	fp->count += fp->v_incr;
	if (fp->count >=1.0 && (fp->cur_window - (fp->last_sent - fp->last_ack + 1)) <= 2)	  {
	  fp->cur_window = min (fp->cur_window + 1, fp->max_window);
	  fp->count -= 1.0;
	  }
	else
	  if (fp->count <= -1.0&& (fp->cur_window - (fp->last_sent - fp->last_ack + 1)) <= 2)
	  {
	  fp->cur_window = min (max(fp->cur_window - 1, 2), fp->max_window);
	  fp->count += 1.0;
	  }

      sendTime = make_float(fp->time_sent[(pkt->seq_no)%MAX_WINDOW_SIZE]);
      
    /* Do vegas RTT stuff. Vegas cheks for timeout when acks are received
     * (usually duplicate acks).    
     */
             
      any_retransmission (fp, last);

      /* it sets Transmits to the largest number an acked segment
       * has been transmited, but here if there was no retransmissions yet
       * we must have pkt->seq_no = last+1
       */
now = runtime ();

      if (sendTime != 0 && fp->Transmits == 1) {
	float rtt, n;
	
	rtt = make_float (runtime()) - sendTime;
	fp->v_cong_detect_sumRTT += rtt;
	fp->v_cong_detect_cntRTT++;
	if (rtt > 0.0) {
	  fp->v_rtt = rtt;
	  /* spike_timeInc I don't use it
	   * vtcp_input.c ligne 1305
	   * this is the time we must wait before sending an other 
	   * packet (In REAL the line is busy till we receive a packet 
	   * of type INT 
	   */
	  if (fp->v_rtt < fp->base_RTT)
	    fp->base_RTT = fp->v_rtt;
	  
	  n = fp->v_rtt - (fp->v_sa/8);
	  fp->v_sa += n;
	  if (n < 0) n = -n;
	  n -= (fp->v_sd/4);
	  fp->v_sd += n;
	  
	  fp->v_timeout = (((fp->v_sa/4) + fp->v_sd)/2);
	  /* since we use more occurate time, we need 
	   * to make it a little bigger
	   */
	  fp->v_timeout += fp->v_timeout/16;
	}/* end of if rtt > 0 */
      }/* end of vegas stuff */
      
      /* Vegas cheks for timed out segments if we receive
       * a first or second no duplicate ack after retransmission
       */
      
      if (fp->num_ack_after_retx > 0){
	if (expire (fp, pkt->seq_no)){
	 
	  PKT_PTR         np;
	  
	  hold ();
	  np = (PKT_PTR) calloc (1,(unsigned) sizeof (PKT));
	  release (1);
	  
	  np->size = ftp_size;
	  np->gen_time = runtime ();
	  np->type = Vegas;
	  np->seq_no = pkt->seq_no + 1;
	  np->dest = assigned_sink[fp->nn];
	  if (np->dest < ABSOLUTE_MAX_NODES)
	    np->dest += ABSOLUTE_MAX_NODES * realnum;
	  np->alpha = alpha_f;
	  np->source = realnum * ABSOLUTE_MAX_NODES + fp->nn;
	  fp->retxed[np->seq_no % MAX_WINDOW_SIZE] = 1;
	  fp->num_dup_acks = fp->rexmtthresh;

	  if (fp->back_off < TCP_MAX_RT_SHIFT - 1)
	    ++fp->back_off;
	
	  if (fp->back_off > TCP_MAX_RT_SHIFT / 4)
	    {
	      fp->mean_deviation += fp->round_trip_time;
	      fp->round_trip_time = 0;
	    }

	  
	  if (fp->line_busy)
	    enq (fp->nn, np);
	  else
	    {
	      fp->line_busy = 1;
	      fp->timer[np->seq_no % MAX_WINDOW_SIZE] = pkt->id = fp->timer_id++; 
	      old_sent = fp->last_sent;
	      vegas_safe_send (np, timeout (fp), fp);
	      
	      if ( fp->last_sent < old_sent)
		fp->last_sent = old_sent ;
	      fp->time_sent[np->seq_no % MAX_WINDOW_SIZE] = runtime ();
	    }
 	if ( fp->last_sent < old_sent)
	  fp->last_sent = old_sent ;
	}
      }
      --fp->num_ack_after_retx;
      if (fp->num_ack_after_retx < 0)
	fp->num_ack_after_retx = 0;
      }else
	{
	  if (pkt->seq_no is last)    {
	    int             win = min (fp->cur_window, fp->max_window);
	    
	    ++fp->num_dup_acks;
	    /* Vegas retransmits when we receive a first dup ack
	     * Here we retransmit when we receive three dup acks
	     */
	    if ((expire(fp, pkt->seq_no)) || fp->num_dup_acks == fp->rexmtthresh )/*&& last + 1 > fp->fr_thresh))*/
	      {
		
		PKT_PTR         np;
		int             old_sent = fp->last_sent;
		int             old_cwnd = fp->cur_window; 

		fp->num_ack_after_retx = min(2, fp->last_sent-fp->last_ack-1);
		
		hold ();
		np = (PKT_PTR) calloc (1,(unsigned) sizeof (PKT));
		release (1);
		fp->fr_thresh = last + 1 + win;
		np->size = ftp_size;
		np->gen_time = runtime ();
		np->type = Vegas;
		np->seq_no = last + 1;
		np->dest = assigned_sink[fp->nn];
		if (np->dest < ABSOLUTE_MAX_NODES)
		  np->dest += ABSOLUTE_MAX_NODES * realnum;
		np->alpha = alpha_f;
		np->source = realnum * ABSOLUTE_MAX_NODES + fp->nn;
		 
		if (fp->back_off < TCP_MAX_RT_SHIFT - 1)
		  ++fp->back_off;
		
		if (fp->back_off > TCP_MAX_RT_SHIFT / 4)
		  {
		    fp->mean_deviation += fp->round_trip_time;
		    fp->round_trip_time = 0;
		  }

		fp->retxed[np->seq_no % MAX_WINDOW_SIZE] = 1;
		
		if (fp->transmits[np->seq_no %MAX_WINDOW_SIZE]  > 1)
		  fp->v_timeout *=2;
		else
		  fp->v_timeout += fp->v_timeout/8;
		
		/* If cwnd hasn't changed since the packet was sent,
		 * then we need to decrease it 
		 */
		
	    sendTime = make_float (fp->time_sent[np->seq_no % MAX_WINDOW_SIZE]);
	    if (fp->v_time_cwin_chg < sendTime)
	      {
		if (win <= 3)
		  win = 2;
		else if (fp->Transmits > 1) /* it is retxmd more than once*/  
		  {
		  fp->count += (float)(win % 2)/(float)2.0;
		  win /= 2; /*exponential decrease*/
		  }
		else{
		  fp->count -= (float)(win % 4)/(float)4.0;
		  win -= (win / 4);
		}
		fp->v_newcwnd = win;
		fp->cur_window = fp->v_newcwnd + fp->num_dup_acks;
		
		if (fp->line_busy)
		  enq (fp->nn, np);
		else
		  {
		    fp->line_busy = 1;
		    fp->timer[np->seq_no % MAX_WINDOW_SIZE] =
		      np->id = fp->timer_id++;
		    vegas_safe_send (np, timeout (fp), fp);
		    fp->time_sent[np->seq_no % MAX_WINDOW_SIZE] = runtime ();
		    fp->v_time_cwin_chg = make_float(runtime ());
		  }
	      }else /*don't need to decrease cwnd */
	      if (fp->line_busy)
		enq (fp->nn, np);
	      	else{
		fp->line_busy = 1;
		fp->timer[np->seq_no % MAX_WINDOW_SIZE] =
		  np->id = fp->timer_id++;
		vegas_safe_send (np, timeout (fp), fp);
		
		fp->time_sent[np->seq_no % MAX_WINDOW_SIZE] = runtime ();
	      }
	    if (fp->Transmits == 1)
	      fp->num_dup_acks = fp->rexmtthresh;
	    if ( fp->last_sent < old_sent)
		  fp->last_sent = old_sent ;
	   
	      }
	    else if (fp->num_dup_acks > fp->rexmtthresh && fp->cur_window > fp->ssthresh)
	      {
		if (fp->cur_window < fp->max_window)
		  fp->cur_window++;
	      }
	  }
	}
    hold ();
    free (pkt);
    release (1);
    
}
vegas_safe_send (pkt, timeout, fp)
    PKT_PTR         pkt;
    float           timeout;
    struct      frame   *fp;
    {

    /* sends a packet safely i.e. with an associated timeout */

    long            max_timeout;
    ident           dest;
    timev           now;
    float           timenum;
    ident           node_number;
    int             win;

    node_number = get_node_id ();
    now = runtime ();
   
    win = min (fp->cur_window, fp->max_window);

    dest = pkt->dest;
    if ((dest / ABSOLUTE_MAX_NODES) != realnum)	/* not local */
	dest = cc_router;
    else
	dest = dest % ABSOLUTE_MAX_NODES;
    

    if (pkt->seq_no > fp->max_sent)
      fp->max_sent = pkt->seq_no;
    else
      num_retx++;
    
    /* Vegas_send sets transmits[pkt] to 0 each time a packet is 
       sent we increment its transmits (how many times it is sent)*/ 
      ++fp->transmits[pkt->seq_no % MAX_WINDOW_SIZE];
      
    fp->last_sent = pkt->seq_no;

    max_timeout = 2145;
    /* largest possible long number limits us this magic number is
     * guaranteed to not overflow ... */
    if ((long) timeout > max_timeout)
	timeout = max_timeout;

    pkt->timeout = (long) (timeout * MILLION);

    if (route[node_number][dest] == 0)
	pr_error ("Routing error in Vegas_source");
    if (sendm (route[node_number][dest], 0, (char *) pkt) isnt 1)
	pr_error ("Vegas_safe_send: message undeliverable ", pkt);
    if (PLOT_ON)
      {
        make_flt_plot ("rto", timeout);
	make_plot ("seq", pkt->seq_no);

      }
    
    }
int expire (fp, seq)
 struct   frame   *fp;
  int     seq;
{
int len = 0;
float time;
timev now ;
now = runtime ();

 time = make_float (now) - make_float(fp->time_sent[(seq + 1) % MAX_WINDOW_SIZE]);
 if (time >= fp->v_timeout && seq + 1 <= fp->last_sent){
   len++;
   fp->Transmits = fp->transmits[(seq + 1) % MAX_WINDOW_SIZE];
 }
return len;
}

any_retransmission (fp, sequence)
struct    frame  *fp;
int sequence;
{
  int i;
  fp->Transmits = 0;
  for (i=1; i <= (fp->last_ack - sequence); i++)
    {
    fp->Transmits = max(fp->Transmits,
			fp->transmits[(sequence+ i)%MAX_WINDOW_SIZE]);
    fp->transmits[(sequence+ i)%MAX_WINDOW_SIZE] = 0;
    }
}
			

