/* Implementation exercise 1: Simple Node
   
   An Engineering Approach to Computer Networking

   S. Keshav

*/

/*
 * To do the exercise, fill in the blanks (the comments marked with -?- ).
 * You can rewrite the whole program if you wish, as long as the printf format 
 * doesn't change. Definitions for things like 'and', 'or', and 'not' are in
 * the file sim/src/defs.h. For more information, see
 * http://www.aw.com/cp/keshav/engcom.html
 */

#include "../kernel/real.h"

ecn_simple()
{
    PKT_PTR         pkt, tick_pkt = (PKT_PTR)0;
    int             node, num_pkts_sent =0 ,ack = 0, tick=1, line_busy = 0;
    ident           destn, sender, sink;
    long            key;
    timev           now;
    int             seq_no = 0;

    node = get_node_id();       	/* find out local id */ 
    source_node_type[node] = TEMPLATE; 
    sink = assigned_sink[node]; 	/* find out sink (from .l file ) */
    abs_advance(node_start_time[node]);	/* advance time to start time */

    printf("Simple source: %d ", get_node_id());
    printf("--> %d, start (%d, %d)\n", 
           sink, node_start_time[node].tv_sec, node_start_time[node].tv_usec);
    goto test;

    for (ever)
    {
recv:
        sender = recvm(&destn, &key, &pkt);
        now = runtime();
        switch (pkt->type)
        {
        case ACK:
            free(pkt);
            /* -?-
             put in the variable names in printf

             printf("%f Sender (node %d) <-- ACK (%d)\n");

             */
            goto test;

        case DATA:
            ack = 1;
            free(pkt);

            /* -?-
             put in the variable names in printf
             printf("%f Receiver (node %d) <-- DATA (%d)\n" );

             */
            goto test;

        case INT:
            /*  -?-
              change the status of the line using the line_busy variable 
             */
            free(pkt);
            goto test;

        case TICK:
            tick = 1;
            free(pkt);
            goto test;

        default:
            free(pkt);
            pr_error("Node %d: source received a pkt of unknown type", node);
        }
    }
test:
        if (not line_busy) 
            if(node is 1 and tick and num_pkts_sent < num_pkts[node])
            {
                pkt = (PKT_PTR) malloc(sizeof(PKT));
                pkt->type = DATA;
                /* -?-
                  set the packet's sequence number, source, and destination 
		 */
	        now = runtime();
                pkt->size = 10;
                sendm(2,0,pkt);
                line_busy = 1;
                tick = 0;
                printf("%f Sender (node %d) DATA (%d) -->\n", make_float(now), node, pkt->seq_no);
                num_pkts_sent ++;

                tick_pkt = (PKT_PTR) malloc(sizeof(PKT));
                tick_pkt->type = TICK;

		/* Notice how the timer is set to generate an interrupt after a 
		 * one second = 1 million microseconds. In REAL, timer expiration
		 * is indicated by the receipt of a packet, whose type should be
		 * appropriately set (here it is set to type TICK. 
		 */

                set_timer(1.0, tick_pkt);   /* for next packet */
            }
            else if (node is 2 and ack)
            {
                /*  -?-
                fill out the fields of the ack packet
                */
                ack = 0;
            }
    goto recv;
}

