/* Implementation exercise 3: Switching and scheduling.
   
   An Engineering Approach to Computer Networking

   S. Keshav

*/

/*
/*
 * This one of the senders for Assignment 3.
 */

#include "../kernel/real.h"

ecn_sender1()
{
    PKT_PTR         pkt;
    int             node, num_pkts_sent = 0; 
    ident           destn, sender, sink;
    long            key;
    timev           now;
    int             seq_no = 0;

    node = get_node_id();       /* find out local id */ 
    source_node_type[node] = TEMPLATE; 
    sink = assigned_sink[node]; /* find out sink (from .l file ) */
    abs_advance(node_start_time[node]);/* advance time to start time */

    printf("Dummy source: %d ", get_node_id());
    printf("--> %d, start (%d, %d)\n", 
           sink, node_start_time[node].tv_sec, node_start_time[node].tv_usec);
    /* send the first packet at the start of time */
    now = runtime();

    make_pkt(pkt);
    pkt->seq_no = seq_no++;
    pkt->dest = 7;
    pkt->gen_time = now;
    send_pkt(pkt);
    num_pkts_sent = 1;

    for (ever) {
        sender = recvm(&destn, &key, &pkt);
        now = runtime();

        switch (pkt->type)
        {
        case ACK:	/* just free acks for now */
            free(pkt);
	    break;

	case INT:	/* when the line goes free, send the next pkt */

	    if(num_pkts_sent < num_pkts[node]) {
	        pkt->type = DATA;
    	        pkt->seq_no = seq_no++;
                pkt->dest = sink;
                pkt->gen_time = now;
                send_pkt(pkt);
		num_pkts_sent ++;
 	    }
	    break;

        default:
            free(pkt);
            pr_error("Source received a pkt of unknown type");
        }
    }
}

