/* Implementation exercise 3: Switching and routing

 An Engineering Approach to Computer Networking

 S. Keshav

 */

#include "../router/router.h"

extern int      START_R_DEBUG;	/* start and end of router debugging */
extern int      END_R_DEBUG;	/* set in ../kernel/switches.c */
extern PKT_PTR  t_dequeue();


ecn_router()
{
    int             count = 0, i, j, dest, so;
    int             conv_id; /* conversation identifier  == VCI */
    int             qnum;    /* queue number */
    PKT_PTR         pkt, util_pkt;
    timev           now, diff;
    ident           node, destn, sendr;
    long            key;

    node = get_node_id();
    abs_advance(node_start_time[node]);
    source_node_type[node] = ROUTER;
    printf("Gateway : %d\n", node);

    /* to keep the routing state smaller, we associate a 'queue number'
     * or 'qnum' with each attached line, stored in array q_number  
     */
    for (i = 0; i < MAX_NODES + 1; i++)
	if (route[node][i] is i)	
	    q_number[node][i] = count++;	/* assign q number */

    for (ever) {
	sendr = recvm(&destn, &key, &pkt);
	now = runtime();

	so = pkt->source;

	/* dest is the next node along the path - not the eventual destn */
	dest = route[node][pkt->dest];

	/* conv_id is a handle that is unique for each source/destination
	 * pair. Per-conversation state is indexed by conv_id, which is 
	 * like a VCI.  If this is a new conversation, conv_id will be 
	 * assigned a new number, else it is an old value
	 */
	conv_id = hash(node, so, pkt->dest);

	qnum = q_number[node][dest];	/* qnum = output interface number */

	q_num_of_conv[node][conv_id] = qnum;
					/* reverse mapping */
	pkt->arr_time = now;

	if (make_float(now) > START_R_DEBUG)
	    R_DEBUG = 1;
	if (make_float(now) > END_R_DEBUG)
	    R_DEBUG = 0;

	if (R_DEBUG) {

	    /* packets that are used for timer events are 'virtual'
	     * and have a type larger than NUM_VIRTUAL_TYPES 
	     */

	    if (pkt->type > NUM_VIRTUAL_TYPES) {

		printf("%f Router %d: Received %d ---(%d %s)---> %d\n",
			make_float(now), node, so, pkt->seq_no, 
				type_to_str(pkt->type), dest); 
		dump_q(so, conv_id);
	    }
	}

	/* Deal with the incoming packet depending on its type */

	switch (pkt->type){

	case DATA:
	case ACK:

	    if (busy[node][qnum]) 	/* line to dest is busy; buffer */
		t_enqueue(pkt, conv_id, qnum, dest);
	    else	     
		sendit(pkt, conv_id, qnum, dest);
	    break;

	case INT:
	    /* line is now free: select packet to send, if any */

	    free(pkt);

	    pkt = t_dequeue(qnum);
			/* pkt now refers to the selected packet, not the
			   INT packet! */

	    if (pkt != NULL) {

		/* reset useful values */
		so = pkt->source;
		dest = route[node][pkt->dest];
		conv_id = hash(node, so, pkt->dest);
		qnum = q_number[node][dest];

	        if (R_DEBUG and pkt)
		    printf("%f Router %d: Selected %d ---(%d %s)---> %d\n",
			make_float(now), node, so, pkt->seq_no, 
			type_to_str(pkt->type), dest);

		sendit(pkt, conv_id, qnum, dest);

	    } else /* idle: nothing in the queue to be sent */
		busy[node][qnum] = 0;

	    break;

	default:
	    printf("Spurious packet received at the router \n");
	    printf("%d: (%d, %d):  pkt: source %d, type %d seq %d\n",
		   node, now.tv_sec, now.tv_usec, pkt->source, pkt->type,
		   pkt->seq_no);
	    free(pkt);
	    break;
	}
    }
}

sendit(pkt, conv_id, qnum, dest)
    PKT_PTR         pkt;
    int             conv_id, qnum, dest;
{
    int             node, so;
    timev           now, diff;

    node = get_node_id();
    now = runtime();
    so = pkt->source;

    busy[node][qnum] = 1;

    /* collect stats */

    if (pkt->type is DATA) {
	diff = time_minus(now, pkt->arr_time);
	make_entry(make_float(diff), &qing_delay[node][so]);
    }

    if (!sendm(dest, 0, pkt))
	pr_error("sendm failed in router");

    if ((R_DEBUG) and pkt->type > NUM_VIRTUAL_TYPES)
        printf("%f Router %d: Forwarded %d ---(%d %s)---> %d\n",
			make_float(now), node, so, pkt->seq_no, 
			type_to_str(pkt->type), dest); 

}
/****************************************************************

Enqueueing and dequeueing routines

****************************************************************/

#define NULPTR (PKT_PTR) 0

PKT_PTR         head_queue [MAX_NODES + 1][MAX_FAN_OUT];
PKT_PTR         tail_queue [MAX_NODES + 1][MAX_FAN_OUT];


t_enqueue(pkt, conv_id, qnum, dest)

PKT_PTR pkt;
int conv_id, qnum, dest;
{
    int node = get_node_id();

    if (head_queue[node][qnum] is NULPTR)
	head_queue[node][qnum] = pkt;
    else
	tail_queue[node][qnum]->next = pkt;

    tail_queue[node][qnum] = pkt;
    pkt->next = NULPTR;
}

PKT_PTR
t_dequeue(qnum)
int qnum; 
{
    PKT_PTR         tptr;
    int		    node = get_node_id();

    if (head_queue[node][qnum] is  NULPTR)	/* empty queue */
	return NULL;

    if (head_queue[node][qnum] is tail_queue[node][qnum]){
	/* One element in queue  */

	tptr = head_queue[node][qnum];
	head_queue[node][qnum] = tail_queue[node][qnum] = NULPTR;
	return tptr;
    }

    /* at least two packets */

    tptr = head_queue[node][qnum];
    head_queue[node][qnum] = tptr->next;
    tptr->next = NULPTR;	/* Annul pointer */
    return tptr;
}
