
/* Implementation exercise 3: Switching and scheduling.
   
   An Engineering Approach to Computer Networking

   S. Keshav

*/

/*
/*
 * This the receiver for Assignment 3.
 */

#include "../kernel/real.h"

ecn_receiver()
{
    PKT_PTR         pkt;
    int             node, num_pkts_sent = 0; 
    ident           destn, sender, sink;
    long            key;
    timev           now;
    int             seq_no = 0;

    node = get_node_id();       /* find out local id */ 
    source_node_type[node] = TEMPLATE; 
    sink = assigned_sink[node]; /* find out sink (from .l file ) */
    abs_advance(node_start_time[node]);/* advance time to start time */

    printf("Dummy receiver : %d ", get_node_id());

    for (ever) {
        sender = recvm(&destn, &key, &pkt);
        now = runtime();

        switch (pkt->type)
        {

        case DATA:	/* turn it around and send it as an ack */
	    if(node is 7)
	        printf("%f: Receiver %d received a DATA packet from %d\n",
			make_float(now), node, pkt->source);
	    pkt->dest = pkt-> source;
	    pkt->source = node;
	    pkt->type = ACK;
	    pkt->size = ack_size;
	    send_pkt(pkt);
	    break;

	case INT:	/* just free it */
	    free(pkt);
	    break;

        default:
            free(pkt);
            pr_error("Node %d: source received a pkt of unknown type", node);
        }
    }
}
