extern int      DEC_DEBUG;

#include "../kernel/real.h"

#define INIT_RTT 6.0
#define INIT_WINDOW 4.0
#define ALPHA 0.1

dec()
{
    PKT_PTR         pkt;		/* the packet being processed */
    PKT_PTR	    deq_pkt;		/* pkt dequeued */
    int		    node; 		/* current node */
    int		    num_packets = 0;	/* number of packets seen in current
					 * cycle */
    int             last_ack = -1; 	/* last seq no acked */
    int             last_sent = -1; 	/* last seq no sent */
    int		    window = INIT_WINDOW; 	/* current window size */	
    float	    float_window= INIT_WINDOW; 	/* floating pt. window size */
    int		    timer_id = 0; 	/* used to simulate single timer */
    int		    seq_no = 0;		/* sequence number */
    int		    min_window; 	/* minimum window */
    int		    line_busy = 0;	/* output line is busy */
    int             pkts_sent = 0;	/* number of packets sent so far */
    int		    num;		/* number of packets in retx. queue */
    ident           destn, sender, sink;
    long            key;
    timev           now, gen, diff;
    timev           time_sent[MAX_WINDOW_SIZE]; /* time pkt. was sent */
    float           timeout;		/* timeout value to use */
    float           rtt;		/* RTT estimate */
    float           tao;		/* actual RTT */
    int	   	    num_bits = 0; 	/* number of bits set this cycle */
    float	    window_prev= INIT_WINDOW; 	/* previous window size */
    float     	    window_threshold = 0.5;	
					/* threshold at which to reduce win */
    float	    beta_rtt = 2.0;

    node = get_node_id();
    sink = assigned_sink[node];
    abs_advance(node_start_time[node]);

    printf("Dec FTP source: %d ", get_node_id());
    printf("sending %d packets to sink %d\n", num_pkts[node], sink);

    source_node_type[node] = DEC_SOURCE;
    rtt = INIT_RTT * scale_factor;	/* start off the estimator at 6 seconds*/
    timeout = beta_rtt * rtt;
    alpha_rtt_ftp = ALPHA;

    goto test;
    for (ever)
    {
recv:
	sender = recvm(&destn, &key, &pkt);
	now = runtime();
	switch (pkt->type)
	{
	case ACK:
	    {
		int             i, last;

		/* clean our retx. queue */

	        num = num_in_q(node);
	        while (num-- != 0)
	        {
		    deq_pkt = deq(node);
		    if (deq_pkt->seq_no > pkt->seq_no)
			enq(node, deq_pkt);
		    else
		        free(deq_pkt);
	        }

		if (pkt->seq_no > last_ack)
		{
		    last = last_ack;
		    for (i = 1; i <= pkt->seq_no - last; i++)
		    {
                        diff = time_minus(now, time_sent[(pkt->seq_no % MAX_WINDOW_SIZE)]);
			tao = make_float(diff);
			rtt = rtt + alpha_rtt_ftp * (tao - rtt);

			timeout = beta_rtt * rtt;
			if (DEC_DEBUG)
			    printf("%f: node %d: tao %f, rtt %f\n",
				   make_float(now), node,tao, rtt);
			make_entry(tao, &rt_time[node]);
		    }
		    last_ack = pkt->seq_no;
		    num_packets++;
		    if (pkt->decbit)
		    {
			num_bits++;
			if (DEC_DEBUG)
			    printf("%f: node %d: recvd a packet with a bit set\n",
				   make_float(now), node);
		    }
		    if (num_packets is window)
			num_bits = 0;
		    if (num_packets is 2*window)
		    {
			/* time to adjust the window size */
			make_plot("win", window);
			if (num_bits < window_threshold * window)
			{
			    float_window++;
			    if(float_window > window + 1)
				float_window = window + 1;
			    if (float_window > ftp_window)
				float_window = ftp_window;
			    window = (int) (float_window + 0.5);
			} else
			{
			    if(float_window * 0.875 < float_window - 1)
			    	float_window = 0.875 * float_window;
			    else 
				float_window --;
			    if (float_window < 1.0)
				float_window = 1.0;
			    window = (int) (float_window + 0.5);
			}
		    	make_plot("win", window);
			if (DEC_DEBUG)
			    printf("%f: node %d : window old %2.2f new %2.2f #pkts %d #bits %d\n",
				   make_float(now), node, window_prev,
				   float_window, num_packets, num_bits);
			window_prev = window;
			num_packets = num_bits = 0;
		    }
		    make_flt_plot("thru", seq_no / make_float(now));
		}
		free(pkt);
		goto test;
	    }
	case INT:
	    line_busy = 0;
	    free(pkt);
	    goto test;
	case TIMEOUT:
	    if (pkt->id is timer_id and pkt->seq_no > last_ack)
	    {
		if(DEC_DEBUG)
		    printf("%f: node %d timeout of seq# %d\n",  
			make_float(now), node, pkt->seq_no);
		pkt->type = DATA;
		pkt->seq_no = last_ack + 1;
		pkt->resent = 1;
		window = 1;
		float_window = window_prev = 1.0;
		num_packets = num_bits = 0;
		diff = time_minus(now, pkt->gen_time);
		timeout = 2 * make_float (diff);
		enq(node, pkt);
		goto test;
	    } else
		free(pkt);
	    break;
	default:
	    free(pkt);
	    pr_error("ftp_source recvd. an unknown pkt ");
	}
    }

test:
	    if (window < ftp_window)
		min_window = window;
	    else
		min_window = ftp_window;

	    if (last_sent < last_ack + min_window
		&& !line_busy
		&& pkts_sent < num_pkts[node])
	    {
	  	pkt = deq(node);
		if(pkt is NULL) 
		    make_pkt(pkt);
		pkt->gen_time = runtime();
		pkt->seq_no = (seq_no)++;
		if (pkt->seq_no > last_sent)
			last_sent = pkt->seq_no;
		time_sent[(pkt->seq_no) % MAX_WINDOW_SIZE] = runtime();
		now = runtime();
		line_busy = 1;
		pkt->id = ++timer_id;
		pkts_sent++;
		if(pkt->resent)
		    num_retransmissions[node] ++;
		safe_send(pkt, timeout);
	    }
goto recv;
}
