/*
 * ARGS USED: peak rate, on_time, off_time
 * NOT USED : average_rate, interval
 *
 * controlled_rate sends data at the peak rate for on_time then is
 * idle for off_time. Unlike background.c, controlled_rate
 * performs call setup at the beginning of the simulation. It does not
 * allow sending phase shifts like background.c
 * 
 * ave_bandwidth and interval are read-only and not used to compute on
 * and off times. 
 */


#include "../kernel/real.h"

controlled_rate()
{
    PKT_PTR         pkt, tick_pkt = (PKT_PTR)0;
    int             num, node, seq_no = 0, total_pkts_sent = 0;
    int             start_up = 1, line_busy = 0, tick = 0;
    ident           destn, sender, sink;
    long            key;
    timev           now, diff;
    int             pkts_sent = 0, pkt_count = 0;
    float   	    flt_pkt_count, delay;
    int     	    click = 0, click_limit;


    node = get_node_id();
    source_node_type[node] = CONTROLLED_RATE_SOURCE;
    sink = assigned_sink[node];
    abs_advance(node_start_time[node]);

    printf("Controlled rate source: %d ", get_node_id());
    printf ("--> %d, start (%d, %d), on %d, off %d, peak %f\n",
        sink, node_start_time[node].tv_sec,
        node_start_time[node].tv_usec,
        on_time[node], off_time[node], peak_bandwidth[node]);

    if (peak_bandwidth[node] > line_speeds[node][route[node][sink]])
	pr_error("node %d - peak speed (%f) more than line speed (%f)\n",
		 node, peak_bandwidth[node],
		 line_speeds[node][route[node][sink]]);

    flt_pkt_count = (peak_bandwidth[node] * on_time[node] * 1.0e-6)/((float)ftp_size*8.0);
    pkt_count = (int) flt_pkt_count;
    click_limit = 1.0/(flt_pkt_count - (float) pkt_count);

    /* call setup */

    make_pkt(pkt);
    pkt->seq_no = seq_no ++;
    pkt->gen_time = runtime();
    pkt->type = SETUP;
    pkt->ave_bandwidth = ave_bandwidth[node];
    pkt->peak_bandwidth = peak_bandwidth[node];
    pkt->interval = interval[node];
    pkt->jitter = jitter[node];
    pkt->gs = 0;	     /* setup packet is not GS */

    send_pkt(pkt);

    for (ever)
    {
recv:
	sender = recvm(&destn, &key, &pkt);
	now = runtime();

	switch (pkt->type)
	{
	case SETUP_ACK:
	    if (pkt->ave_bandwidth is 0.0)	/* refused ! */
	    {
		printf("node %d refused, not enough bandwith \n", node);
		goto recv;
	    } else if (pkt->peak_bandwidth is 0.0)
	    {
		printf("node %d refused, not enough buffer \n", node);
		goto recv;
	    }
	    tick = 1;
	    goto test;
	case ACK:
	    free(pkt);
	    goto recv;
	case INT:
	    line_busy = 0;
	    free(pkt);
	    goto test;
	case TIMER:
	    tick = 1;
	    tick_pkt = pkt;
	    goto test;
	default:
	    free(pkt);
	    pr_error("controlled_rate source received a pkt of unknown type");
	}
    }

test:

    if (tick and (not line_busy) and total_pkts_sent < num_pkts[node])
    {
	if (pkts_sent < pkt_count)
	{
	    tick = 0;
	    line_busy = 1;

	    make_pkt(pkt);
    	    pkt->seq_no = seq_no ++;
	    pkt->gen_time = runtime();
	    pkt->gs = 1;
	    send_pkt(pkt);

            delay = on_time[node]/(float)pkt_count;
	    pkts_sent++;
	    total_pkts_sent++;
	} else
	{
	    delay = off_time[node];
	    pkts_sent = 0;
            if(++click is click_limit)
            {
                click = 0;
                pkt_count = ((int) flt_pkt_count) + 1;
            }
            else
                pkt_count = ((int) flt_pkt_count);
	}
	
	/* schedule next tick */

        if(tick_pkt is (PKT_PTR) 0)      /* start up */
        {
            make_pkt(tick_pkt);
            tick_pkt -> type = TIMER;
        }

	set_timer(delay, tick_pkt);

    }
    goto recv;
}
