extern int CODER_DEBUG;
/*
 * NOT USED : average_rate, peak_rate, on_time, off_time, interval
 * 
 * coder simulates a MPEG video coder. it reads from a file that contains
 * records of the form <# of bits per macroblock> and sends them to
 * a tx layer node. The tx layer informs the target rate for the frame
 * after next. The coder trims bits from the macroblocks for that
 * frame to match the sending rate and target rate
 * 
 * The interface to the tx layer node is to send pkts of type DATA (which will
 * be placed in the tx queue.) and receive pkts of type RATE, which tell
 * the target tx. rate
 * 
 * An example of a file that contains macroblocks is in
 * ../etc/mpeg_source.example
 */

#define MACROBLOCKS 330

#include "../kernel/real.h"


coder()
{
    PKT_PTR         pkt;
    int             num, node, seq_no = 0, pkts_sent = 0;
    int             start_up = 1, tick = 1, size;
    ident           destn, sender, sink;
    long            key, delay;
    timev           now;
    FILE           *f;
    float           next_target_rate = 0.0, next_next_target_rate = 0.0;
    char	    first_frame_out = 0;
    int		    current_frame = 1;	/* current frame being processed */


    node = get_node_id();
    source_node_type[node] = CODER_SOURCE;
    sink = assigned_sink[node];
    printf("node %d reading from file %s\n",node, input_file[node]);
    f = fopen(input_file[node], "r");
    if (!f)
	pr_error("Coder node unable to open input file specified \n");
    abs_advance(node_start_time[node]);

    printf("Coder source: %d \n", node);
    fflush(stdout);

    /* send first frame */
    current_frame = 1;
    read_and_send(f, 0.0, current_frame);

    for (ever)
    {
recv:
	sender = recvm(&destn, &key, &pkt);
	now = runtime();
	switch (pkt->type)
	{
	case RATE:

	    /* target rate is specified as pkts/sec */

	    next_target_rate = next_next_target_rate;
	    next_next_target_rate = pkt->proto_flag;
	    free(pkt);
	    current_frame ++;
	    read_and_send(f, next_target_rate, current_frame);

	   break;

	case INT:
	    free(pkt);
	    break;
	default:
	    free(pkt);
	    pr_error("Node %d: source received a pkt of unknown type", node);
	}
    }

}

/* target rate is the 'send_rate' in pp.c, pkts/sec */
/* if target rate is set to 0, then there is no reduction (for startup) */

read_and_send(f, target_rate, current_frame)
    FILE           *f;
    float           target_rate;
    int 	    current_frame;
{
    PKT_PTR         pkt;
    ident           destn, sender;
    long            key;
    int             i, j, node, junk1, junk2;
    int             num_bits, bit_count, num_pkts;
    int             cur_mb_index;
    int             macroblock[MACROBLOCKS + 1];
    float           reduction;


    node = get_node_id();

    /* read in macroblock */

    if(CODER_DEBUG)
    	printf("target rate %f\n", target_rate);


    for (i = 1; i <= MACROBLOCKS; i++) 
    {
	if (fscanf(f, "%d \n", &(macroblock[i])) is EOF)
	    slumber(0,0);
    }
#define ORIGINAL_DATA
#ifdef ORIGINAL_DATA

    /* trim the macroblocks corresponding to reduction factor */

    num_bits = 0;
    for (i = 1; i <= MACROBLOCKS; i++)
	 num_bits += macroblock[i];

    if (target_rate > 1e-6)
    {
        if(CODER_DEBUG)
	{
	    printf ("\ndesired %6.3f Mbps", num_bits * 30.0 * 1.0e-6);
	    printf(" target %6.3f Mbps ", 
		ftp_size * 8.0 * target_rate* 1.0e-6 * scale_factor);
	}

	reduction = (target_rate * ftp_size * 8.0 * scale_factor) 
							/ (30.0 * num_bits);

	if (reduction > 1.0)
	    reduction = 1.0;

	/* trim macroblocks */
	for (i = 1; i <= MACROBLOCKS; i++)
	    macroblock[i] *= reduction;
    }
    else 
	reduction = 1.0;

    if(CODER_DEBUG)
    	printf ("reduction %f\n", reduction);

    printf("@%d %d %d  %f\n", node, current_frame, (int)(num_bits * reduction), reduction);

#endif

    /* form packets and send them */

    cur_mb_index = 1;		/* start macroblock index for current frame */
    num_pkts = 0;		/* # pkts in this frame */

    while (cur_mb_index <= MACROBLOCKS)
    {
	make_pkt(pkt);		/* data pkt send to tx layer */
	pkt->low_mb = cur_mb_index;
				/* index of lowest macroblock in pkt */
	bit_count = 0;

	/* grab bits till reach ftp_size bytes, or no more macroblocks */

	for (j = 0; (bit_count <= 8 * ftp_size ) and 
					(cur_mb_index + j <= MACROBLOCKS); j++) 
	{
	    if(macroblock[cur_mb_index + j] > 8 * ftp_size )
		pr_error("macroblock size larger than ftp_size bytes!");
	    bit_count += macroblock[cur_mb_index + j];
	}

	cur_mb_index += j;

	/* tell the transport layer */

	pkt->frameno = current_frame;
	pkt->high_mb = cur_mb_index - 1;
	pkt->type = DATA;
	pkt->size = ftp_size;
        pkt->dest = assigned_sink[node];
	send_pkt(pkt);
	num_pkts++;
    }
   
    /* tell tx layer rate to send at (interpkt spacing in microseconds) */

    make_pkt(pkt);
    pkt->type = RATE;
    pkt->proto_flag = 33333.3333 * scale_factor / num_pkts;
    send_pkt(pkt);
    if(CODER_DEBUG)
	printf("coder sent off rate pkt, num_pkts is %d rate %f\n", num_pkts, pkt->proto_flag);

}
