/*
 * ARGS USED: peak rate, on_time, off_time
 * NOT USED : average rate, interval
 *
 * background sends data at the peak rate for on_time seconds, then
 * sends no data for off_time seconds. 
 */


#include "../kernel/real.h"


/*
 * Control parameters 
 */

#define PHASE 0.0
	/* starting phase relationship : 0.0 = send all packets now
				         1.0 = start delay now */
#define VARIATION 0.0
	/* delay will vary randomly from (1-var)*delay  to (1+var)*delay */

void
background ()
{
    ident   destn, sender, sink;
    PKT_PTR pkt;
    PKT_PTR tick_pkt = (PKT_PTR) 0;
    int     line_busy = 0, tick = 1, last_sent = -1, seq_no = 0;
    int     total_pkts_sent = 0, pkts_sent = 0, pkt_count, node;
    long    key; 
    float   delay;
    timev   now, diff;
    float   flt_pkt_count;
    int     click = 0, click_limit;

    node = get_node_id ();
    sink = assigned_sink[node];
    source_node_type[node] = BACKGROUND_SOURCE;
    abs_advance (node_start_time[node]);

    printf ("Background source %d ", get_node_id ());
    printf ("--> %d, start (%d, %d), on %d, off %d, peak %f\n",
        sink, node_start_time[node].tv_sec,
        node_start_time[node].tv_usec,
        on_time[node], off_time[node], peak_bandwidth[node]);
   
    if(peak_bandwidth[node] > line_speeds[node][route[node][sink]])
	pr_error("peak speed (%f) more than line speed (%f)\n",
	node, peak_bandwidth[node], 
	line_speeds[node][route[node][sink]]);

    flt_pkt_count = (peak_bandwidth[node] * on_time[node])/((float)ftp_size*8.0);

    pkt_count = (int) flt_pkt_count;
    if(flt_pkt_count isnt pkt_count)
    	click_limit = 1.0/(flt_pkt_count - (float) pkt_count);
    else
	click_limit = 200000000;

    pkts_sent = PHASE * pkt_count;
		/* phase */
    goto test;
    for (ever)
    {

recv: 
	sender = recvm (&destn, &key, &pkt);
	now = runtime ();
	switch (pkt -> type)
	{
	    case ACK: 
		free (pkt);
		goto recv;
	    case INT: 
		line_busy = 0;
		free (pkt);
		goto test;
	    case TIMER: 
		tick = 1;
		tick_pkt = pkt;
		goto test;
	    default: 
		free (pkt);
		pr_error ("background src. recvd. an unknown pkt ");
	}
    }
test: 
    if ((!line_busy) and tick and total_pkts_sent < num_pkts[node])
    {
	if (pkts_sent < pkt_count) 
	{
	    tick = 0;
	    line_busy = 1;

	    make_pkt(pkt);
	    pkt->seq_no = seq_no ++;
	    pkt -> gen_time = runtime ();
	    send_pkt(pkt);
	
    	    delay = (on_time[node]/(float)pkt_count);
	    delay = delay * ((1 - VARIATION) + 2* VARIATION * RANDOM);
			/* add randomness with mean = delay */
	    pkts_sent++;
	    total_pkts_sent++;
	}
    	else
 	{
	    delay = off_time[node];
	    pkts_sent = 0;
	    if(++click is click_limit)
	    {
		click = 0;
		pkt_count = ((int) flt_pkt_count) + 1;	
	    }
	    else
		pkt_count = ((int) flt_pkt_count);
	}

	/* schedule next tick */

	if(tick_pkt is (PKT_PTR)0)	/* start up */
	{
	    make_pkt(tick_pkt);
	    tick_pkt->type = TIMER;
	}	

	set_timer(delay, tick_pkt);
    }
    goto recv;
}
