# simulate xunet.l
# Remember that your REALDIR environment variable should be set
# to something reasonable

# the header section is optional

header					
{
network: xunet;
version: 0;
}

# nest_params section is optional. Default passtime is 1 second
# default maxnodes is MAXNODES in config.h and default monitor is
# custom_monitor in kernel/monitor.c

nest_params {
	passtime = 1,0;
	maxnodes = 30;
	monitor = custom_monitor;
}

# real_params section is also optional. Default definitions are in
# lang/lang.yacc

real_params {
	inter_pkt_delay = 5.0;
#                                       seconds (optional - not used)
	random_seed = 812;
	buffer_size = 440000;
#					bytes 	(different from REAL3.0)
	ftp_pkt_size = 53;
#                                       bytes
	telnet_pkt_size = 53;
#					bytes
	ack_size = 53;
#                                       bytes
	ftp_window = 300;
#                                       packets
	telnet_window = 300;
#                                       packets
	decongestion_mechanism = 1;
#					1 = drop from tail
#					2 = drop from head
#					3 = drop from random position
	 scale_factor = 1000;
#
	real_number  = 0;
#					used for distributed REAL
	router_node = 0;
#					used for distributed REAL
	end_simulation = 300.0;
#					simulation end time in seconds
	print_interval = 20;
#					print and flush statistics every 
#					print_interval seconds
}



nodes{ 
# 					first define the default node type
#					all fields are optional
	default{
		function = generic;
		dest = 5;
#					destination node to send to 
		start_time = 0,1000;
#					start node at seconds, microseconds
		plot = true ;
#					set to true if you want to plot data
		num_pkts = 160000;
#					number of packets to send 
		on_time = 180000;
#					for on-off style sources:
#					on_time is the time from the start
#					of the sending of the first
# 					packet in the on period to the start 
#					of sending of the last pkt.

		off_time = 3871000;
#					off_time is time between start
#					of last pkt. in prev burst
#					to start of first pkt in next burst
		peak = 47186.0;
#					for controlled sources: this is the
#					declared peak rate in bits/sec
		average = 2000.0;
#					declared average rate in bits/sec
		interval = 42000000;
#					interval over which average is computed
#					(in microseconds)
		jitter = 3000;
#					desired max delay jitter from the 
#					network (in microseconds)
		sch_policy = 7;	
#					for router nodes 
#					1 = fcfs
#					2 = fair queueing
#					3 = decbit
#					4 = fqbit
#					5 = hrr
#					7 = xunet
		}

#					for each source, just need to specify
#					what is different compared to the default
	node 1 { function=mpeg; plot = true; class=3; average=5500; input_file=/fs/hydra7/keshav/video/fer4; start_time=9,0;}
	node 2 { function=controlled_rate; plot = true; class=2; average=64; on_time=9900; off_time=6000000;start_time=9,0;}
	node 3 { function=random_rate; plot=false; average=10;interval=1000000000; class=4; start_time=9,0;}
	node 4 { function=pp;  average=2000; class=1; start_time=9,0; }
	node 5 { function = sink; plot=false;}
	node 6 { function=random_rate; plot = true; class=3;  average=8300; start_time=9,2000;}
	node 7 { function=random_rate; plot = true; class=2;  average=7400; start_time=9,2000;}
 	node 8 { function=poisson; plot = true;  class=1; average=6000;start_time=9,2000;}
      
	node 9 { function = sink; plot=false;}
	node 10 { function = router; plot = true;start_time=3,0;}
#
 	node 11 { function=mpeg; plot = true; class=3; average=5500; input_file=/fs/hydra7/keshav/video/bir4; start_time=6,0; }
 	node 12 { function=controlled_rate; plot = true; class=2; average=64; on_time=9900; off_time=6000000;start_time=6,0;}
	node 13 { function=random_rate;  average=10;interval=1000000000; class=4; start_time=6,0; plot=false; }
	node 14 { function=random_rate;  average=2000; class=1; plot=false; start_time=6,0; }

 	node 16 { function=random_rate; plot = false; class=3;  average=14000; start_time= 6,2000; dest=9;}
 	node 15 { function=random_rate; plot = false; class=2;  average=7000; start_time= 6,2000; dest=5;}
 	node 17 { function=random_rate; plot = false; class=2;  average=7400; start_time= 6,2000; dest=9;}
  	node 18 { function=poisson; plot = false;  average=6000; start_time=6,2000; class=1; dest= 9;}
      
 	node 19 { function = sink;plot=false;}
	node 20 { function = router; plot = false; start_time=2,0;}
#
        node 21 { function=mpeg; plot = true; class=3; average=5500; input_file=/fs/hydra7/keshav/video/bal4; start_time=3,0; }
        node 22 { function=controlled_rate; plot = true; class=2; average=64; on_time=9900; off_time=6000000;start_time=3,0;}
        node 23 { function=random_rate;  average=10; interval=1000000000; plot=true; class=4; start_time=3,0; }
        node 24 { function=random_rate;  average=2000; plot=true; class=1; start_time=3,0; }

        node 26 { function=random_rate; plot = false; class=3;  average=19500; start_time= 5,2000; dest=19;}
        node 27 { function=random_rate; plot = false; class=2;  average=13900; start_time= 5,2000; dest=19;}
        node 28 { function=poisson; plot = false;  average=6000; start_time=5,2000;dest=19;}

        node 29 { function = sink;plot=false;}
        node 30 { function = router; plot = true; start_time=1,0;}
#
        node 31 { function=mpeg; plot = true; class=3; average=5500; input_file=/fs/hydra7/keshav/video/aut4; start_time=0,1 ; }
        node 32 { function=controlled_rate; plot = true; class=2; average=64; on_time=9900; off_time=6000000;start_time=0,1;}
        node 33 { function=random_rate;  average=10; interval=1000000000;class=4;plot=true; start_time=0,1; }
        node 34 { function=pp;  average=2000; class=1;plot=true; start_time=0,1; }

        node 36 { function=random_rate; plot = false; class=3;  average=24500; start_time= 4,2000; dest=29;}
        node 37 { function=random_rate; plot = false; class=2;  average=14500; start_time= 4,2000; dest=29;}
        node 38 { function=poisson; plot = false;  average=6000; start_time=4,2000;dest=29;}

        node 40 { function = router; plot = false; start_time=0,0;}



}


edges{
	default {
		bandwidth = 47186;
#					in bits/sec
		latency = 166666;
#					in microseconds
		}
	{ 1 -> 10;}
	{ 2 -> 10;}
	{ 3 -> 10;}
	{ 4 -> 10;}
	{ 6 -> 10;}
	{ 7 -> 10;}
	{ 8 -> 10;}
	{ 10 -> 9;}
	{ 10 -> 5;}
	{ 20 -> 10; bandwidth= 47186; latency=1000000;}
	{ 11 -> 20;}
	{ 12 -> 20;}
	{ 13 -> 20;}
	{ 14 -> 20;}
	{ 15 -> 20;}
	{ 16 -> 20;}
	{ 17 -> 20;}
	{ 18 -> 20;}
	{ 20 -> 19;}
	{ 30 -> 20; bandwidth= 47186; latency=1000000;}
	{ 21 -> 30;}                                   
        { 22 -> 30;}                                   
        { 23 -> 30;}
        { 24 -> 30;}
        { 26 -> 30;}
        { 27 -> 30;}
        { 28 -> 30;}
        { 30 -> 29;}
	{ 40 -> 30; bandwidth= 47186; latency=1000000;}
        { 31 -> 40;}
        { 32 -> 40;}
        { 33 -> 40;}
        { 34 -> 40;}
        { 36 -> 40;}
        { 37 -> 40;}
        { 38 -> 40;}
}
