# simulate xunet.l
# Remember that your REALDIR environment variable should be set
# to something reasonable

# the header section is optional

header					
{
network: xunet;
version: 0;
}

# nest_params section is optional. Default passtime is 1 second
# default maxnodes is MAXNODES in config.h and default monitor is
# custom_monitor in kernel/monitor.c

nest_params {
	passtime = 1,0;
	maxnodes = 30;
	monitor = custom_monitor;
}

# real_params section is also optional. Default definitions are in
# lang/lang.yacc

real_params {
	inter_pkt_delay = 5.0;
#                                       seconds (optional - not used)
	random_seed = 913;
	buffer_size = 440000;
#					bytes 	(different from REAL3.0)
	ftp_pkt_size = 53;
#                                       bytes
	telnet_pkt_size = 53;
#					bytes
	ack_size = 53;
#                                       bytes
	ftp_window = 600;
#                                       packets
	telnet_window = 400;
#                                       packets
	decongestion_mechanism = 1;
#					1 = drop from tail
#					2 = drop from head
#					3 = drop from random position
	 scale_factor = 1000;
#
	real_number  = 0;
#					used for distributed REAL
	router_node = 0;
#					used for distributed REAL
	end_simulation = 1000.0;
#					simulation end time in seconds
	print_interval = 10;
#					print and flush statistics every 
#					print_interval seconds
}



nodes{ 
# 					first define the default node type
#					all fields are optional
	default{
		function = generic;
		dest = 5;
#					destination node to send to 
		start_time = 0,1000;
#					start node at seconds, microseconds
		plot = true ;
#					set to true if you want to plot data
		num_pkts = 160000;
#					number of packets to send 
		on_time = 180000;
#					for on-off style sources:
#					on_time is the time from the start
#					of the sending of the first
# 					packet in the on period to the start 
#					of sending of the last pkt.

		off_time = 3871000;
#					off_time is time between start
#					of last pkt. in prev burst
#					to start of first pkt in next burst
		peak = 47186.0;
#					for controlled sources: this is the
#					declared peak rate in bits/sec
		average = 2000.0;
#					declared average rate in bits/sec
		interval = 42000000;
#					interval over which average is computed
#					(in microseconds)
		jitter = 3000;
#					desired max delay jitter from the 
#					network (in microseconds)
		sch_policy = 7;	
#					for router nodes 
#					1 = fcfs
#					2 = fair queueing
#					3 = decbit
#					4 = fqbit
#					5 = hrr
#					7 = xunet
		}

#					for each source, just need to specify
#					what is different compared to the default
	node 1 { function=mpeg; plot = true; class=3; average=8500; input_file=/fs/hydra7/keshav/video/bir4; start_time=9,0;}
	node 2 { function=controlled_rate; plot = true; class=2; average=64; on_time=9900; off_time=6000000;start_time=9,0;}
	node 3 { function=random_rate;  average=10; class=4; start_time=9,0;}
	node 4 { function=random_rate;  average=2000; class=1; start_time=9,0; }
	node 5 { function = sink; plot=false;}
	node 6 { function=random_rate; plot = true; class=3;  average=19300; start_time=9,2000;}
	node 7 { function=random_rate; plot = true; class=2;  average=13400; start_time=9,2000;}
 	node 8 { function=poisson; plot = true;  class=1; average=6000;start_time=9,2000;}
      
	node 10 { function = router; plot = true;start_time=9,0;}


}


edges{
	default {
		bandwidth = 47186;
#					in bits/sec
		latency = 166666;
#					in microseconds
		}
	{ 1 -> 10;}
	{ 2 -> 10;}
	{ 3 -> 10;}
	{ 4 -> 10;}
	{ 6 -> 10;}
	{ 7 -> 10;}
	{ 8 -> 10;}
	{ 10 -> 5;}
}
