# This is a sample input file for the simulator
# it can also be found as lang/example.l
# To see if your simulator is OK, run it on this example as 
# simulate example.l
# Remember that your REALDIR environment variable should be set
# to something reasonable

# the header section is optional

header					
{
network: example;
version: 0;
}

# nest_params section is optional. Default passtime is 1 second
# default maxnodes is MAXNODES in config.h and default monitor is
# custom_monitor in kernel/monitor.c

nest_params {
	passtime = 1,0;
	maxnodes = 30;
	monitor = custom_monitor;
}

# real_params section is also optional. Default definitions are in
# lang/lang.yacc

real_params {
	inter_pkt_delay = 5.0;
#                                       seconds (optional - not used)
	random_seed = 23;
	buffer_size = 440000;
#					bytes 	(different from REAL3.0)
	ftp_pkt_size = 500;
#                                       bytes
	telnet_pkt_size = 40;
#					bytes
	ack_size = 40;
#                                       bytes
	ftp_window = 600;
#                                       packets
	telnet_window = 400;
#                                       packets
	decongestion_mechanism = 1;
#					1 = drop from tail
#					2 = drop from head
#					3 = drop from random position
	real_number  = 0;
#					used for distributed REAL
	router_node = 0;
#					used for distributed REAL
	end_simulation = 300;
#					simulation end time in seconds
	print_interval = 50;
#					print and flush statistics every 
#					print_interval seconds
}

# this section is only for backwards compatibility with REAL 3.0
# it is optional in REAL 4.0

node_functions {
#					This section is for documentation only:
#				  	and you can skip it if you want.
#					if you do use it, the name must match
#					the function name in the source file.
	jk_reno;
	generic;
	background;
	router;
	sink;
}

nodes{ 
# 					first define the default node type
#					all fields are optional
	default{
		function = generic;
		dest = 15;
#					destination node to send to 
		start_time = 0,10000;
#					start node at seconds, microseconds
		plot = false ;
#					set to true if you want to plot data
		num_pkts = 1000;
#					number of packets to send 
		on_time = 0;
#					for on-off style sources:
#					on_time is the time from the start
#					of the sending of the first
# 					packet in the on period to the start 
#					of sending of the last pkt.

		off_time = 40000;
#					off_time is time between start
#					of last pkt. in prev burst
#					to start of first pkt in next burst
		peak = 20000.0;
#					for controlled sources: this is the
#					declared peak rate in bits/sec
		average = 20000.0;
#					declared average rate in bits/sec
		interval = 1000000;
#					interval over which average is computed
#					(in microseconds)
		jitter = 20000000;
#					desired max delay jitter from the 
#					network (in microseconds)
		hrr_levels = { 10:0 ; } ;
#					for a hrr router, the b and nb values
#					at each level. Ignored for a source.
		sch_policy = 2;	
#					for router nodes 
#					1 = fcfs
#					2 = fair queueing
#					3 = decbit
#					4 = fqbit
#					5 = hrr
		}

#					for each source, just need to specify
#					what is different compared to the default
	node 1 { plot = true; num_pkts = 4000; dest = 4;}
	node 2 { function = router; plot = true;}
	node 3 { function = router;}
	node 4 { function = sink ;}
	node 5 { plot = true; start_time = 100,0;}
	node 6 { plot = true; start_time = 144,0;}
	node 7 { start_time = 188,0;}
	node 8 { start_time = 232,0;}
	node 9 { start_time = 276,0;}
	node 10 { start_time = 320,0;}
	node 11 { start_time = 364,0;}
	node 12 { start_time = 408,0;}
	node 13 { start_time = 452,0;}
	node 14 { plot = true; start_time = 496,0;}
	node 15 {function = sink;}
}

edges{
	default {
		bandwidth = 200000;
#					in bits/sec
		latency = 1000000;
#					in microseconds
		}
	{ 1 -> 2;}
 	{ 5 -> 2;}
 	{ 6 -> 2;}
 	{ 7 -> 2;}
 	{ 8 -> 2;}
 	{ 9 -> 2;}
 	{ 10 -> 2;}
 	{ 11 -> 2;}
 	{ 12 -> 2;}
 	{ 13 -> 2;}
 	{ 14 -> 2;}
	{ 3 -> 15;}
 	{ 3 -> 4;}
	{ 2 -> 3; bandwidth = 40000; latency = 20000000;}
}
