
header
{
network:fq_tests;
version:0;
}

nest_params {
	passtime = 1,0;
	maxnodes = 17;
	monitor = custom_monitor;
}
real_params {
	scale_factor = 1.0;
	ack_size = 40;
	random_seed = 42;
	buffer_size = 400000;
	telnet_pkt_size = 40;
	ftp_pkt_size = 100;
	ftp_window = 5;
	telnet_window = 5;
	decongestion_mechanism = 1;
	sch_policy = 5;
	router_node = 0;
	real_number  = 0;
	pulse_size = 0.0;
	end_simulation = 3;
	print_interval = 1;
}


nodes{ 
	default{
		function = controlled_rate;
		dest = 5;
		start_time = 0,10000;
		plot = false;
    # plot was originally "false"
		num_pkts = 1;
    # number of pkts in burst
		on_time = 0;
    #				microseconds
    # on_time is the time from the start of the sending of the first 
    # packet in the on period to the start of sending of the last pkt.
		off_time = 40000;
    #				microseconds
    # off_time is time between start of last pkt. in prev burst to
    # start of first pkt in next burst
		peak = 20000.0;
    #				bits per sec
		average = 20000.0;
    #				bits per sec
		interval = 40000;
    #				microseconds
		jitter = 2000000;
    #				microseconds
		hrr_levels = { 10:0 ; } ;
		}

	node 1 { function = controlled_rate; }
	node 2 { function = router; 
	  	 hrr_levels = { 40 : 0 ; } ;
		}
	node 3 { function = router; 
	  	 hrr_levels = { 100 : 0 ; } ;
		}
	node 4 { function = router; 
	         hrr_levels = { 40 : 0 ; } ;
		}
	node 5 { function = sink ; }
	node 6 { function = random_rate;
		 dest = 7;
		 interval = 1000000;
		 num_pkts = 100;
		 peak = 800000.0; 
		 average = 80000.0;
		 on_time = 100000;
		}
	node 7 { function = sink; }
	node 8 { function = random_rate;
		 dest = 9;
		 interval = 1000000;
		 num_pkts = 10;
		 peak = 80000.0; 
		 average = 8000.0;
		 on_time = 100000;
		}
	node 9 { function = sink; }
}
edges{
	default {
		bandwidth = 800000;
    #				bits per second
		latency = 0;
    #				in microseconds
		}
	{ 1 -> 2; }
	{ 2 -> 3; }
	{ 3 -> 4;  bandwidth = 80000;}
	{ 4 -> 5; }
	{ 6 -> 2;}
	{ 3 -> 7;}
	{ 8 -> 3;}
	{ 4 -> 9;}
}
