
nest_params {
	passtime = 100,0;
	maxnodes = 30;
	monitor = custom_monitor;
}

real_params {
	scale_factor = 1.0;
	ack_size = 40;
	random_seed = 12;
	buffer_size = 12500;
	telnet_pkt_size = 40;
	ftp_pkt_size = 500;
	ftp_window = 600;
	telnet_window = 5;
	decongestion_mechanism = 1;
	sch_policy = 2;
	end_simulation = 3000;
	print_interval = 100;
}

nodes{ 
	default{
		function = pp;
		dest = 15;
		start_time = 0,10000;
		plot = false ;
		num_pkts = 1000;
		}

	node 1 { plot = true; num_pkts = 4000; dest = 4;}
	node 2 { function = router;}
	node 3 { function = router;}
	node 4 { function = sink ;}
	node 5 { start_time = 1,0;}
	node 6 { start_time = 2,0;}
	node 7 { start_time = 3,0;}
	node 8 { start_time = 4,0;}
	node 9 { start_time = 5,0;}
	node 10 { start_time = 6,0;}
	node 11 { start_time = 8,0;}
	node 12 { start_time = 8,0;}
	node 13 { start_time = 9,0;}
	node 14 { start_time = 10,0;}
	node 15 { function = sink;}
	node 16 { function = background; peak = 40000.0; on_time = 100000; num_pkts = 4000; off_time = 9900000;}
}

edges{
	default {
		bandwidth = 2000000;
#			  bits/sec
		latency = 1000; 
#			  microseconds
		}
	{ 1 -> 2;}
	{ 5 -> 2;}
	{ 6 -> 2;}
	{ 7 -> 2;}
	{ 8 -> 2;}
	{ 9 -> 2;}
 	{ 10 -> 2;}
	{ 11 -> 2;}
	{ 12 -> 2;}
	{ 13 -> 2;}
	{ 14 -> 2;}
	{ 16 -> 2;}
	{ 3 -> 15;}
 	{ 3 -> 4;}
	{ 2 -> 3; bandwidth = 40000; latency = 498000;}
}
