# 10 poisson sources with 3600 bits/sec = 36000 bits/sec = 0.9 of Bottleneck
header
{
network:comparision;
version:1;
}

nest_params {
	passtime = 100,0;
	maxnodes = 30;
	monitor = custom_monitor;
}

real_params {
	scale_factor = 1000.0;
	ack_size = 40;
	random_seed = 0;
	buffer_size = 220000;
	ftp_pkt_size = 500;
	ftp_window = 600;
	decongestion_mechanism = 1;
	sch_policy = 2;
	end_simulation = 5000;
	print_interval = 200;
}

nodes{ 
	default{
		function = poisson;
		dest = 15;
		start_time = 0,10000;
		plot = false ;
		num_pkts = 40000;
		average = 3600.0;
		}

	node 1 { function = pp; plot = true; num_pkts = 4000; dest = 4;}
	node 2 { function = router;}
	node 3 { function = router;}
	node 4 { function = sink ;}
	node 5 { }
	node 6 { }
	node 7 { }
	node 8 { }
	node 9 { }
	node 10 { }
	node 11 { }
	node 12 { }
	node 13 { }
	node 14 { }
	node 15 { function = sink;}
	node 16 { function = background; peak = 200000.0; on_time = 20000; num_pkts = 4000; off_time = 19980000;}
}

edges{
	default {
		bandwidth = 200000;
		latency = 1000000;
		}
	{ 1 -> 2;}
	{ 5 -> 2;}
	{ 6 -> 2;}
	{ 7 -> 2;}
	{ 8 -> 2;}
	{ 9 -> 2;}
 	{ 10 -> 2;}
	{ 11 -> 2;}
	{ 12 -> 2;}
	{ 13 -> 2;}
	{ 14 -> 2;}
	{ 16 -> 2;}
	{ 3 -> 15;}
 	{ 3 -> 4;}
	{ 2 -> 3; bandwidth = 40000; latency = 20000000;}
}
