/* implementation of proposed xunet scheduling policy */
/* H. Saran IIT Delhi & At&T 9 July 93 */

#include "../kernel/real.h"
#define PRI    4
#define FRR    3
#define WRR    2
#define PBE     1
#define BE     0
#define XU_NUM_LEVELS (PRI + 2)
#define FRR2 (PRI + 1)

extern PKT_PTR  get_from_op_q ();

/* phase */
int             phase[MAX_NODES + 1][MAX_FAN_OUT];
/* chunk as defined in xunet paper */
int             chunk[MAX_NODES + 1][MAX_CONVERSATIONS];

/* bw per slot, slots and jitter at each level */
float           xu_level_bw[MAX_NODES + 1][MAX_FAN_OUT][XU_NUM_LEVELS];
float           xu_level_cells[MAX_NODES + 1][MAX_FAN_OUT][XU_NUM_LEVELS];
float           xu_level_delay[MAX_NODES + 1][MAX_FAN_OUT][XU_NUM_LEVELS];

/* allocated values */
int             alloc_chunk[MAX_NODES + 1][MAX_CONVERSATIONS];
float           xu_alloc_cells[MAX_NODES + 1][MAX_FAN_OUT][XU_NUM_LEVELS];

/* these tables are used by the router */
int             conv_class[MAX_NODES + 1][MAX_CONVERSATIONS];
int             xu_conv_level[MAX_NODES + 1][MAX_CONVERSATIONS];

 /* level and class are really the same thing. However class is set by 
  * the admission control and level is used for service. 
  * level is made PRI to handle transmission of chunks as it is done in 
  * xunet hardware (i.e. bump level up to PRI while chunk is 
  * non-zero and conv is active)  
  */


PKT_PTR
xu_sched (qnum, dest)
    int             qnum, dest;
{
    int             conv_id;	/* current vc under consideration */
    PKT_PTR         pkt;	/* pkt chosen to be sent */
    int             node;
    int             level;

    node = get_node_id ();
    level = PRI;  /* find out highest priority active level */
    while (level >= 0  and 
	(conv_id = xu_head_service_list (phase[node][qnum], level, qnum)) 
									is -1) 
	level --;


    if (conv_id is - 1)		/* no conv_id on the service list */
        return 0;
    else
	pkt = get_from_op_q (conv_id); /* 1 pkt will be served from this conv */

    /* do what h/w does after the service */
    if (chunk[node][conv_id])
	chunk[node][conv_id]--;

    if (num_buffers_in_q[node][conv_id] isnt 0)  /* conv has more data */
    {  
       	if (chunk[node][conv_id] is 0) /* check for chunk going to zero */
	{ 	
  	    chunk[node][conv_id] = alloc_chunk[node][conv_id];
            xu_conv_level[node][conv_id] = conv_class[node][conv_id];

	    /* bump down PRI conversations if they have too much data */
	    if (conv_class[node][conv_id] is PRI) 
		xu_conv_level[node][conv_id] = PBE;
  	}
	else     /* chunk not zero yet -- serve in priority list*/
            xu_conv_level[node][conv_id] = PRI;
        xu_put_in_tail(1 - phase[node][qnum], xu_conv_level[node][conv_id],conv_id, qnum);
    }
    return pkt;
}
 
typedef struct conv_type VC, *VC_PTR;

VC_PTR          xu_rr_head[MAX_NODES + 1][MAX_FAN_OUT][XU_NUM_LEVELS];
VC_PTR          xu_rr_tail[MAX_NODES + 1][MAX_FAN_OUT][XU_NUM_LEVELS];

#define NULPTR (VC_PTR) 0

xu_init_queues (qnum)
int qnum;
{
    int             node, i;

    node = get_node_id ();
    for (i = 0; i <  XU_NUM_LEVELS; i++)
	xu_rr_head[node][qnum][i] = xu_rr_tail[node][qnum][i] = NULPTR;
}

xu_put_in_head (parity, level, conv_id, qnum)
 /* adds a vc to the head of the appropriate queue */
    char            parity;
    int             conv_id, level, qnum;
{
    VC_PTR          vc;
    int             node;

    node = get_node_id ();
    if (parity and level is FRR)
	level =  FRR2;
    if (xu_check_queue (conv_id, node, qnum, level))
	return;
    vc = (VC_PTR) malloc ((unsigned) sizeof (VC));
    vc->conv_id = conv_id;
    vc->next = xu_rr_head[node][qnum][level];
    xu_rr_head[node][qnum][level] = vc;
    if (xu_rr_tail[node][qnum][level] is NULPTR)
	xu_rr_tail[node][qnum][level] = vc;
}

xu_put_in_tail (parity, level, conv_id, qnum)
 /* adds a vc to the tail of the appropriate queue */
    char            parity;
    int             conv_id, level, qnum;
{
    VC_PTR          vc;
    int             node;

    node = get_node_id ();
    if (parity and level is FRR)
	level =  FRR2;

    if (xu_check_queue (conv_id, node, qnum, level))
	return;
    vc = (VC_PTR) malloc ((unsigned) sizeof (VC));
    vc->conv_id = conv_id;
    vc->next = NULPTR;
    if (xu_rr_tail[node][qnum][level] isnt NULPTR)
	xu_rr_tail[node][qnum][level]->next = vc;
    xu_rr_tail[node][qnum][level] = vc;
    if (xu_rr_head[node][qnum][level] is NULPTR)
	xu_rr_head[node][qnum][level] = vc;
}

int
xu_head_service_list (parity, level, qnum)
    char            parity;
    int             level, qnum;
{
    int             node, conv_id;
    VC_PTR          save;

    node = get_node_id ();
    if (parity and level is FRR)
	level =  FRR2;

    if (xu_rr_head[node][qnum][level] is NULPTR)
    {
	if (xu_rr_tail[node][qnum][level] isnt NULPTR)
	    pr_error ("Xunet service list screwed up !");
	else
	    return -1;
    }
    conv_id = xu_rr_head[node][qnum][level]->conv_id;
    save = xu_rr_head[node][qnum][level];
    xu_rr_head[node][qnum][level] = xu_rr_head[node][qnum][level]->next;
    free (save);
    if (xu_rr_head[node][qnum][level] is NULPTR)
	xu_rr_tail[node][qnum][level] = NULPTR;
    return conv_id;
}

xu_check_queue (id, node, qnum, level)
    int             id, node, qnum, level;
{
    VC_PTR          vc;

    for (vc = xu_rr_head[node][qnum][level]; vc != NULPTR; vc = vc->next)
	if (vc->conv_id is id)
	    return 1;
    return 0;
}


/* routines that are called from router.c for doing housekeeping */
extern float    line_speeds[MAX_NODES + 1][MAX_NODES + 1];

xu_init_bw_levels (qnum, dest)
    int             qnum, dest;
{
    int             i, node;
    int             numslots;
    float           fsize, bw;
    node = get_node_id ();
    xu_init_queues(qnum);
    bw = line_speeds[node][dest];
    numslots = (bw*XU_PHASE_SIZE*scale_factor)/8.0/53.0;
    xu_level_cells[node][qnum][PRI] = 100; 
    xu_level_bw[node][qnum][PRI] = 10000/scale_factor; 
    xu_level_cells[node][qnum][FRR] = 60; 
    xu_level_bw[node][qnum][FRR] = ftp_size*8.0/(XU_PHASE_SIZE*scale_factor); 
    xu_level_cells[node][qnum][WRR] = 200; 
    xu_level_bw[node][qnum][WRR] = (bw - xu_level_cells[node][qnum][PRI]*xu_level_bw[node][qnum][PRI] - xu_level_cells[node][qnum][FRR]*xu_level_bw[node][qnum][FRR])/xu_level_cells[node][qnum][WRR];
    xu_level_bw[node][qnum][PBE] = 0; 
    xu_level_bw[node][qnum][BE] = 0; 
    for(i = 0;i<MAX_CONVERSATIONS+1;i++) 
	alloc_chunk[node][i] = 1; 
    for(i = 0;i<XU_NUM_LEVELS;i++)  
	xu_alloc_cells[node][qnum][i] = 0;
  /* assuming 45mbps channel, will serve BE levels using the stat mux gain */ 
  /*	level_delay[node][qnum][i]  =  1000000.0 * 16 * fsize * ftp_size / bw;
     in usecs */
}

xu_compute_class(pkt, conv_id, qnum)
     PKT_PTR	pkt;
     int conv_id, qnum;
{
    int 	class; 
    float 	bw;
    ident 	node; 
    int 	slots;

    node = get_node_id();
    class = pkt->class;
    printf("Received setup request level %d for %f bps ave and %f bps peak rate \n",
		class,pkt->ave_bandwidth,pkt->peak_bandwidth);
    if ( (class is PRI ) and  (pkt->ave_bandwidth > xu_level_bw[node][qnum][class]))
    {
	pkt->peak_bandwidth = 0; 
	return 0;
    };
    /* no more than 1 slot can be allocated at PRI level */

    alloc_chunk[node][conv_id] = 1;
    conv_class[node][conv_id] = class;
    if ( class > PBE)
    { 
	slots =  pkt->ave_bandwidth/xu_level_bw[node][qnum][class]; 
	if (slots * xu_level_bw[node][qnum][class] < pkt->ave_bandwidth) 
	    slots++;
        if (slots > xu_level_cells[node][qnum][class]- xu_alloc_cells[node][qnum][class])
        {
	    conv_class[node][conv_id] = PBE;
       	    alloc_chunk[node][conv_id] = 1;
	} else  /* accept */ alloc_chunk[node][conv_id] = slots; 

       /*    pkt->peak_bandwidth = alloc_chunk[node][conv_id]*xu_level_bw[node][qnum][class]; */

	pkt->ave_bandwidth = alloc_chunk[node][conv_id]*xu_level_bw[node][qnum][class];
 	printf("Ave bandwidth allocated %f chunksize %d\n",
		pkt->ave_bandwidth,alloc_chunk[node][conv_id]);
    };
    xu_alloc_cells[node][qnum][class] += alloc_chunk[node][conv_id];
    return 1; 	
}

xu_new_arrival(conv_id, qnum )
    int 	conv_id, qnum;
{
    ident 	node;

    node = get_node_id();

    xu_conv_level[node][conv_id]  =  conv_class[node][conv_id];

    xu_put_in_tail( 1-phase[node][qnum], conv_class[node][conv_id], conv_id, qnum);

    chunk[node][conv_id] = alloc_chunk[node][conv_id];
}

xu_teardown( conv_id, qnum)
    int 	conv_id,qnum;
{
    ident 	node; 
    int 	class;

    node = get_node_id();
    class = conv_class[node][conv_id];
    xu_alloc_cells[node][qnum][class] -= alloc_chunk[node][conv_id];
    printf("Conversation teardown \n");

   /* should really do this after teardown pkt is sent! taken out for now

    conv_class[node][conv_id] = BE;
    alloc_chunk[node][conv_id] = 1; */
} 

