/*
 * this contains the scheduling policies - implemented as cases on the
 * function 'select_from_op_q'
 */

#include "../kernel/real.h"

extern  PKT_PTR hrr(), get_fcfs_pkt (), fq(), xu_sched();

PKT_PTR
select_from_op_q (qnum, dest)
int qnum, dest;
{
    int node;
    PKT_PTR pkt;

    node = get_node_id();

    switch (policy[node]) {

	case FCFS: 
	case DECBIT: 
	    return get_fcfs_pkt (qnum);
	    /* implemented in file queues.c */
	case FQ: 
	case FQBIT: 
	    return fq (qnum);
	    /* implemented in file queues.c */
	case HRR: 
	    return hrr (qnum, dest);
	    /* implemented in hrr.c */
       case XUNET: 
           return xu_sched (qnum, dest);
           /* implemented in xunet.c */

    }
}

