extern int      R_DEBUG;
extern int      LITTLE_DEBUG;
extern int      DEC_DEBUG;

#include "../kernel/real.h"

#define BUFFER_THRESHOLD 	1.0
	/* threshold at which to declare output buffers are full */

#define BANDWIDTH_THRESHOLD 	1.0
	/* threshold at which to declare output line is full */

/* reservation state */

#define MN MAX_NODES + 1
#define MC MAX_CONVERSATIONS
#define MF MAX_FAN_OUT

float           fq_weight[MN][MC];
	/* weight assigned to a reserved FQ conversation */

float           bandwidth_allocated[MN][MF];
	/* how much bandwidth has already been allocated at this link */

float           buffers_allocated[MN][MF];
	/* how many buffers have already been allocated at this link */

float           bandwidth_share[MN][MC];
	/* share of output link that a conversation has */

int             buffer_share[MN][MC];
	/* share of buffers that a conversation has */

char		q_number[MN][MN];
	/* q_number is the queue number of the next dest */

/* dec stuff */
 
timev           prev_cycle_begin_time[MN][MF];
	/* time at which last 0->1 queue length trasition occurred */

timev           cycle_begin_time[MN][MF];
	/* time at which latest transition occurred */

timev           q_change_time[MN][MF];
	/* last time at whch the queue length was updated */

float           area[MN][MF];
	/* current cumulative sum of queue length */

float           prev_area[MN][MF];
	/* old cumulative sum of queue lengths */

float           average_q_len[MN][MF];
	/* average queue length */

int             q_length[MN][MF];
	/* current queue size */

float           prev_c_knee[MN][MF];
	/* # of pkts sent in last regeneration period on this line */

float           c_knee[MN][MF];
	/* # of pkts sent in current regeneration period on this line */

int             pkts_sent[MN][MC];
	/* # of packets received from this conversation in current reg. period */

int           prev_pkts_sent[MN][MC];
	/* # of packets received from this conversation in last reg. period */

char            source_bit[MN][MC];
	/* the source of this conversation sent data in the current reg.  period */

char            source_bit_old[MN][MC];
	/* the source of this conversation sent data in the last reg.  period */


int		num_bits[MN][MN];
	/* bits sent on an o/p queue in the last util_time seconds */

/* externally referenced data structures and functions */

extern PKT_PTR  select_from_op_q ();
extern int      q_num_of_conv[MN][MC];
extern int      num_buffers_in_q[MN][MC];
extern int      num_bytes_in_q[MN][MC];
extern int      num_active[MN][MF];
extern int      num_buffers_allocated[MN][MF];
extern int      alloc_aj[MN][MC];
extern int      num_cells_allocated[MN][MF][NUM_LEVELS];
extern int      conv_level[MN][MC];
extern int      net_conv[MN][MF];
extern char     count_conv[MN][MF];
extern PKT_PTR  fc_fs (), hrr (), get_fcfs_pkt (), get_min_bid ();
extern int      dump_q ();
extern TABLE    so_tossed[MN];	
extern TABLE    qing_delay[MN][MN];
extern TABLE    nxmit[MN][MN];
extern float    line_speeds[MN][MN];
extern char     parity[MN][MF][NUM_LEVELS];
extern double   save_finish[MN][MC];
extern double   finish_num[MN][MC];
extern CONV_PTR head_conv_list[MN][MF];
extern CONV_PTR head_perm_conv_list[MN][MF];
extern CONV_PTR head_alive_list[MN][MF]; 
extern int      phase[MAX_NODES + 1][MAX_FAN_OUT];
extern int 	conv_class[MN][MC];
extern double	round_number[MN][MF];
