#undef MPEG 
		/* define to get drop information for MPEG simulations */
extern int      SCH_DEBUG;

/* layer 1 and 2 - data structures and basic functionality */
/* layer 3 and 4 - advanced queue management and scheduling */
/* S. Keshav UCB - 12/1/88 , 12/2/88 */

#include "../kernel/real.h"

#define NULPTR (PKT_PTR) NULL
#define NULCONV (CONV_PTR) NULL

extern TABLE    so_tossed[MAX_NODES + 1];
extern double   finish_num[MAX_NODES + 1][MAX_CONVERSATIONS];
extern double   save_finish[MAX_NODES + 1][MAX_CONVERSATIONS];
extern int      net_conv[MAX_NODES + 1][MAX_FAN_OUT];
extern double  round_number[MAX_NODES + 1][MAX_FAN_OUT];



		/**** DATA STRUCTURES ***/

PKT_PTR         head_conv_queue[MAX_NODES + 1][MAX_CONVERSATIONS];
/* pointer to the first packet queued for a conversation */

PKT_PTR         tail_conv_queue[MAX_NODES + 1][MAX_CONVERSATIONS];
/* pointer to the  last packet queued for a conversation */

int             q_num_of_conv[MAX_NODES + 1][MAX_CONVERSATIONS];
/* queue number of a conversation */

CONV_PTR        head_conv_list[MAX_NODES + 1][MAX_FAN_OUT];
/* list of conversations queued at each queue */

CONV_PTR        head_perm_conv_list[MAX_NODES + 1][MAX_FAN_OUT];
/* same as above, but is used by permanent conversations, which are setup using
 * reservations */

CONV_PTR        head_alive_list[MAX_NODES + 1][MAX_FAN_OUT];
/* conversations alive at each output line */

int             num_buffers_in_q[MAX_NODES + 1][MAX_CONVERSATIONS];
/* number of packets in the output queue for each conversation */

int             num_bytes_in_q[MAX_NODES + 1][MAX_CONVERSATIONS];
/* number of bytes in the output queue for each conversation */

int             buffers_in_use[MAX_NODES + 1][MAX_FAN_OUT];
/* number of bufers in use at a queue */

int             bytes_in_use[MAX_NODES + 1][MAX_FAN_OUT];
/* number of bytes in use at a queue */

int             node;

extern double   finish_num[MAX_NODES + 1][MAX_CONVERSATIONS];

/***** PROTOTYPES **********/
extern int init_q();
extern int op_q_full();	     


/********* END *************/


init_q()
{
    int             i, j;

    for (i = 0; i < MAX_NODES + 1; i++)
    {
	for (j = 0; j < MAX_CONVERSATIONS; j++)
	{
	    head_conv_queue[i][j] = tail_conv_queue[i][j] = NULPTR;
	    q_num_of_conv[i][j] = num_bytes_in_q[i][j] = num_buffers_in_q[i][j] = 0;
	}
	for (j = 0; j < MAX_FAN_OUT; j++)
	{
	    head_conv_list[i][j] = (CONV_PTR) 0;
	    buffers_in_use[i][j] = 0;
	    bytes_in_use[i][j] = 0;
	}
    }
}

op_q_full(qnum, size)	     
    int             qnum, size;

{
    node = get_node_id();
    if ((bytes_in_use[node][qnum] + size) > op_qsize)
	return 1;
    else
	return 0;
}

op_q_mt(conv_id)
    int             conv_id;

{
    node = get_node_id();
    if (head_conv_queue[node][conv_id] is NULPTR)
	return 1;
    else
	return 0;
}

/*
 * inserts the packet in the per conversation queue 
 */

put_in_op_q(conv_id, pkt)
    int             conv_id;
    PKT_PTR         pkt;

{
    int             qnum;

    node = get_node_id();
    qnum = q_num_of_conv[node][conv_id];

    if (op_q_full(qnum, pkt->size))
	return ERROR;

    if (head_conv_queue[node][conv_id] is NULPTR)	/* MT Q */
	head_conv_queue[node][conv_id] = pkt;
    else
	tail_conv_queue[node][conv_id]->next = pkt;

    tail_conv_queue[node][conv_id] = pkt;
    pkt->next = NULPTR;
    num_buffers_in_q[node][conv_id]++;
    num_bytes_in_q[node][conv_id] += pkt->size;
    buffers_in_use[node][qnum]++;
    bytes_in_use[node][qnum] += pkt->size;
    if (pkt->trace)
        plot_qsize(conv_id, UP, pkt->source, route[node][pkt->dest]);
    return OK;
}

/* 
 * returns a pointer to head of the per-conversation queue,
 * and also removes the head from the queue 
 */

PKT_PTR
get_from_op_q(conv_id)
    int             conv_id;

{
    int             qnum;
    PKT_PTR         tptr;

    node = get_node_id();
    qnum = q_num_of_conv[node][conv_id];

    if (num_buffers_in_q[node][conv_id] is 0)	/* MT Q */
	return (PKT_PTR) NULL;
    if (head_conv_queue[node][conv_id] is tail_conv_queue[node][conv_id])
    {
	/* 1 elem */
	tptr = head_conv_queue[node][conv_id];
	head_conv_queue[node][conv_id] = tail_conv_queue[node][conv_id] = NULPTR;
	num_buffers_in_q[node][conv_id] = 0;
	num_bytes_in_q[node][conv_id] = 0;
	buffers_in_use[node][qnum]--;
	bytes_in_use[node][qnum]-=tptr->size;
        if (tptr->trace)
             plot_qsize(conv_id, DOWN, tptr->source, route[node][tptr->dest]);
	return tptr;
    } else
    {
	tptr = head_conv_queue[node][conv_id];
	head_conv_queue[node][conv_id] = tptr->next;
	tptr->next = NULPTR;
	num_buffers_in_q[node][conv_id]--;
	num_bytes_in_q[node][conv_id] -= tptr->size;
	buffers_in_use[node][qnum]--;
	bytes_in_use[node][qnum] -= tptr->size;
        if (tptr->trace)
             plot_qsize(conv_id, DOWN, tptr->source, route[node][tptr->dest]);
	return tptr;
    }
}

/*
 * given a pointer to a packet, removes that packet from the 
 * per-conversation queue
 */

dequeue(conv_id, p)
    int             conv_id;
    PKT_PTR         p;

{
    PKT_PTR         tptr1, tptr2;
    int             qnum;

    node = get_node_id();
    qnum = q_num_of_conv[node][conv_id];
    if (op_q_mt(conv_id))
	return ERROR;
    tptr1 = tptr2 = head_conv_queue[node][conv_id];

    while (tptr1 != NULPTR)
    {
	if (tptr1 != p)
	{		     /* Not this packet, advance */
	    tptr2 = tptr1;   /* move the trailer to the current one */
	    tptr1 = tptr1->next;	/* Advance header */
	    continue;
	}
	/* Packet to be dequeued */
	if (tptr1 == tptr2)
	{		     /* element is first in the Q */
	    head_conv_queue[node][conv_id] = tptr1->next;
	    if (tptr1->next is NULPTR)
		tail_conv_queue[node][conv_id] = NULPTR;
	    num_buffers_in_q[node][conv_id]--;
	    num_bytes_in_q[node][conv_id] -= p->size;
	    buffers_in_use[node][qnum]--;
	    bytes_in_use[node][qnum] -= p->size;
            if (p->trace)
        	plot_qsize(conv_id, DOWN, p->source, route[node][p->dest]);
	    return OK;
	}
	if (tail_conv_queue[node][conv_id] is tptr1)
	    tail_conv_queue[node][conv_id] = tptr2;
	tptr2->next = tptr1->next;	/* Dequeue */
	num_buffers_in_q[node][conv_id]--;
	num_bytes_in_q[node][conv_id] -= p->size;
	buffers_in_use[node][qnum]--;
	bytes_in_use[node][qnum] -= p->size;
        if (p->trace)
            plot_qsize(conv_id, DOWN, p->source, route[node][p->dest]);
	return OK;
    }
    return ERROR;	     /* Packet not found */
}

get_num_buffers_in_use(qnum)
    int		    qnum;
{
    return buffers_in_use[get_node_id()][qnum];
}
   
get_num_buffers_in_q(conv_id)
    int             conv_id;
{
    return num_buffers_in_q[get_node_id()][conv_id];
}

get_num_bytes_in_q(conv_id)
    int             conv_id;
{
    return num_bytes_in_q[get_node_id()][conv_id];
}


PKT_PTR
fc_fs(conv_id)
    int             conv_id;
{
    return head_conv_queue[get_node_id()][conv_id];
}


dump_q(source, conv_id)
    int             source, conv_id;
{
    PKT_PTR         q_ptr;
    int             posn;

    node = get_node_id();
    if (num_buffers_in_q[node][conv_id] is 0)
	return;
    printf("Router %d: Queue for source %d (conversation %d)\n", node, source, conv_id);

    q_ptr = head_conv_queue[node][conv_id];
    posn = 1;

    while (q_ptr != NULPTR)
    {
	printf(" %d : seq_no =  %d: arr_time  = %ld,%ld bid = %f\n", posn,
	       q_ptr->seq_no, q_ptr->arr_time.tv_sec, q_ptr->arr_time.tv_usec, q_ptr->bid);
	q_ptr = q_ptr->next;
	posn++;
    }
}

decongest_first(qnum)
    int             qnum;
{
    /*
     * find the conversation with the most bytes and drop a packet 
     * from it
     */

    int             i, so, de;
    int             most = 0, most_conv = 0;
    PKT_PTR         tptr;
    CONV_PTR        conv;

    node = get_node_id();

    /* scan thru all the conversations on that queue */
    for (conv = head_conv_list[node][qnum]; conv != NULCONV; conv = conv->next)
	if (num_buffers_in_q[node][conv->conv_id] > 0)
	    if (num_bytes_in_q[node][conv->conv_id] > most)
	    {
		most_conv = conv->conv_id;
		most = num_bytes_in_q[node][conv->conv_id];
	    }
    tptr = fc_fs(most_conv);
    if (dequeue(most_conv, tptr) is - 1)
	pr_error("error in dequeueing:2");

    if(tptr->trace) 
	plot_qsize(most_conv, DOWN, tptr->source, route[node][tptr->dest]);

    free(tptr);
    invert(node, most_conv, &so, &de);
    make_entry(1.0, &so_tossed[so]);
}


decongest_last(qnum, conv_id, pkt)
    int             qnum, conv_id;
    PKT_PTR         pkt;
{
    /*
     * find the conversation with the most bytes and drop a packet 
     * from it
     */

    int             so, de;
    int             most = 0, most_conv = 0;
    PKT_PTR         tptr;
    CONV_PTR        conv;
    timev	    now;

    node = get_node_id();

    /* scan thru all the conversations on that queue */
    for (conv = head_conv_list[node][qnum]; conv != NULCONV; conv = conv->next)
	if (num_buffers_in_q[node][conv->conv_id] > 0)
	    if (num_bytes_in_q[node][conv->conv_id] > most)
	    {
		most_conv = conv->conv_id;
		most = num_bytes_in_q[node][conv->conv_id];
	    }
    tptr = tail_conv_queue[node][most_conv];
    if (dequeue(most_conv, tptr) is - 1)
	pr_error("error in dequeueing:3 ");
    /* remove effect of punishment  (only works for decongest last ) */

    if (SCH_DEBUG)
	printf("restored finish number of conv %d from %f to %f\n",
	       most_conv, finish_num[node][most_conv],
	       save_finish[node][most_conv]);

    finish_num[node][most_conv] = save_finish[node][most_conv];

    /* set the new bid to what the dropped packet had */
    if (most_conv is conv_id)	/* drop pkt. from own queue */
	pkt->bid = tptr->bid;

    if(tptr->trace) 
	plot_qsize(most_conv, DOWN, tptr->source, route[node][tptr->dest]);

   /* this code is for testing feedback controlled MPEG */

#ifdef MPEG
    printf("%d:S%d drop C%d frame %d mb_low %d mb_high %d\n",
	now.tv_sec, node, so, tptr->frameno, 
	tptr->low_mb, tptr->high_mb);
#endif
#ifdef notdef
    if(tptr->source is 25 and tptr->dest is 20 and tptr->type is DATA) 
	make_plot("drop", tptr->seq_no);
#endif
    free(tptr);
    invert(node, most_conv, &so, &de);
    make_entry(1.0, &so_tossed[so]);

}

extern long     random();

decongest_random(qnum)
    int             qnum;
{
    /* drop a random packet */
    int             so, de, most = 0;
    char            marker = 1;
    PKT_PTR         tptr;
    CONV_PTR        conv;
    int             drop, num = 0;


    node = get_node_id();
    drop = (int) ((RANDOM) * (float) op_qsize + 1.0);
    /* a random integer in the range 1..op_qsize */

    conv = head_conv_list[node][qnum];
    /* scan thru all the conversations on that queue */
    while (marker)
    {
	num += num_buffers_in_q[node][conv->conv_id];	/* count up */
	if (num >= drop)
	{		     /* this conv has the pkt to be dropped */
	    num -= num_buffers_in_q[node][conv->conv_id];
	    tptr = head_conv_queue[node][conv->conv_id];	/* base of q */
	    while (drop-- > num + 1)
		tptr = tptr->next;	/* move up to the pkt */

	    if (dequeue(conv->conv_id, tptr) is - 1)
		pr_error("error in dequeueing:4");

	    invert(node, conv->conv_id, &so, &de);
	    make_entry(1.0, &so_tossed[so]);

    	    if(tptr->trace) 
		plot_qsize(conv->conv_id, DOWN, tptr->source,route[node][tptr->dest]);

	    free(tptr);
	    marker = 0;
	} else
	    conv = conv->next;
    }
}


decongest_all(qnum)
    int             qnum;
{
    /*
     * find the conversation with the most bytes and drop all packets from it
     */

    int             so, de;
    int             most = 0, most_conv = 0, count = 0, count_bytes = 0;
    PKT_PTR         tptr1, tptr2;
    CONV_PTR        conv;
    timev	    now;
    char	    trace, fname[256];
    int		    i, num, source, dest;

    node = get_node_id();

    /* scan thru all the conversations on that queue , find longest */

    for (conv = head_conv_list[node][qnum]; conv != NULCONV; conv = conv->next)
	if (num_buffers_in_q[node][conv->conv_id] > 0)
	    if (num_bytes_in_q[node][conv->conv_id] > most)
	    {
		most_conv = conv->conv_id;
		most = num_bytes_in_q[node][conv->conv_id];
	    }
    if(most is 0)
	pr_error("trying to delete all packets when output queue is empty!");

    /* delete all packets */

    tptr1 = tptr2 = head_conv_queue[node][most_conv];

    if(tptr1 is NULPTR) /* 0 pkts */
	pr_error("head ptr of conv with most bytes is null!");

    trace = tptr1->trace;
    source = tptr1->source;
    dest = tptr1->dest;

    tptr1 = tptr1 -> next;

    if(tptr1 is NULPTR) /* 1 pkt */
    {
	count = 1;
        count_bytes = tptr2->size;
	free (tptr2);
    }
    else 
    {    while(tptr1 isnt NULPTR)
        {
	    count ++;
            count_bytes += tptr2->size;
	    free(tptr2);
            tptr2 = tptr1;
	    tptr1 = tptr1 -> next;
        }
	count ++;
        count_bytes += tptr2->size;
	free(tptr2);
    }

    if(trace) {
        /* plot number of buffers used by this conversation */
    	num = get_num_buffers_in_q(most_conv);
    	sprintf(fname, "qlen.%d.", source);
    	make_plot(fname, num);
    	make_plot(fname, num - count);

   	/* total number of buffers used at that output queue */
    	num = get_num_buffers_in_use(qnum);
    	sprintf(fname, "allqlen.%d.", dest);
    	make_plot(fname, num - count);
    }

    /* adjust stats and pointers */

    head_conv_queue[node][most_conv] = tail_conv_queue[node][most_conv] = NULPTR;
    num_buffers_in_q[node][most_conv] = 0;
    num_bytes_in_q[node][most_conv] = 0;
    buffers_in_use[node][qnum] -= count;
    bytes_in_use[node][qnum] -= count_bytes;

    for(i= 0; i< count; i++)
        make_entry(1.0, &so_tossed[source]);

}

/* **************** conversation management ********** */

add_conv(conv_id, head)	     /* adds a conversation to the appropriate
			      	      * queue */
    int             conv_id;
    CONV_PTR        *head;
{
    CONV_PTR        conv;

    conv = (CONV_PTR) malloc((unsigned) sizeof(CONV));
    conv->conv_id = conv_id;
    conv->next = *head;
    *head = conv;
}

delete_conv(conv_id, head)
    int             conv_id;
    CONV_PTR 	    *head;
{
    CONV_PTR        tptr1, tptr2;

    if (*head is (CONV_PTR) 0)
	return ERROR;
    tptr1 = tptr2 = *head;

    while (tptr1 != (CONV_PTR) 0)
    {
	if (tptr1->conv_id != conv_id)
	{		     /* Not this conv, advance */
	    tptr2 = tptr1;   /* move the trailer to the current one */
	    tptr1 = tptr1->next;	/* Advance header */
	    continue;
	}
	/* Conversation to be deleted */
	if (tptr1 is tptr2)
	{		     /* the element is first in the queue */
	    *head = tptr1->next;
	    free(tptr1);
	    return OK;
	}
	tptr2->next = tptr1->next;	/* Dequeue */
	free(tptr1);

	return OK;
    }
    return ERROR;	     /* conversation not found */
}

check_conv(conv_id, head)
    int             conv_id;
    CONV_PTR	    head;
/* checks if the conv id exists in the list of convs at that queue */
{
    CONV_PTR        conv;

    conv = head;
    while (conv)
    {
	if (conv->conv_id is conv_id)
	    return 1;
	conv = conv->next;
    }
    return 0;
}


/************* scheduling policy management (layer 3) **********/

PKT_PTR
get_fcfs_pkt(qnum)
    int             qnum;

/* finds the packet that arrrived first to a queue */
{

    PKT_PTR         first_pkt;
    timev           arr_time, first;
    CONV_PTR        conv;
    int             node, first_conv;

    node = get_node_id();
    first.tv_sec = MAX_LONG;

    for(conv = head_conv_list[node][qnum]; conv isnt NULCONV; conv = conv->next)
    {
	if (head_conv_queue[node][conv->conv_id])
	{
	    arr_time = (head_conv_queue[node][conv->conv_id])->arr_time;
	    if (time_before(arr_time, first))
	    {
		first = arr_time;
		first_conv = conv->conv_id;
	    }
	}
    }
    if (first.tv_sec is MAX_LONG)
	return NULPTR;
    first_pkt = head_conv_queue[node][first_conv];
    if (dequeue(first_conv, first_pkt) is - 1)
	pr_error("error in dequeueing:1 ");
    return first_pkt;
}

PKT_PTR
fq (qnum)
    int             qnum;

/*
 * finds the packet that with min bid in a queue (amongst all packets
 * enqueued, whether or not the conversation is alive
 */
{

    PKT_PTR         first_pkt;
    CONV_PTR        conv;
    double          bid, min_bid;
    int             i, node, first_conv;
    timev           now;

    node = get_node_id();
    now = runtime();

    if (SCH_DEBUG)
	printf("starting bidding for qnum %d\n", qnum);
    min_bid = bid = INFINITY;
    for (conv = head_conv_list[node][qnum]; conv isnt NULCONV; conv = conv->next)
	if (head_conv_queue[node][conv->conv_id] isnt NULL)
	{
	    bid = (head_conv_queue[node][conv->conv_id])->bid;
	    if (SCH_DEBUG)
		printf("source %d  bid : %f\n", (head_conv_queue[node][conv->conv_id])->source, bid);
	    if (bid < min_bid)
	    {
		min_bid = bid;
		first_conv = conv->conv_id;
	    }
	}
    if (min_bid is INFINITY)
	return NULPTR;
    first_pkt = head_conv_queue[node][first_conv];
    if (dequeue(first_conv, first_pkt) is - 1)
	pr_error("error in dequeue");
    if (SCH_DEBUG)
	printf("pkt selected : source %d, seq %d\n",
	       first_pkt->source, first_pkt->seq_no);
    return first_pkt;
}

double
find_min_finish(qnum, min_conv)
/*
 * find min finish number amongst all the alive conversations (whether or
 * not they have data in the queue !)
 */
    int             qnum, *min_conv;
{
    double          min_finish;
    CONV_PTR        conv;
    int             node;

    node = get_node_id();

    min_finish = INFINITY;
    *min_conv = -1;

    for(conv = head_alive_list[node][qnum]; conv isnt NULCONV; conv = conv->next)
    {
	if (finish_num[node][conv->conv_id] < min_finish)
	{
	    min_finish = finish_num[node][conv->conv_id];
	    *min_conv = conv->conv_id;
	}
    }
    return min_finish;
}

reset_all_finish(qnum, reset)
    int             qnum;
    float           reset;

/* resets all finish numbers to mod RESET_VALUE */
{

    int             i, node;
    PKT_PTR         pkt_ptr;

    node = get_node_id();
    if (SCH_DEBUG)
	printf("resetting fin#s for qnum %d\n", qnum);
    for (i = 0; i < MAX_CONVERSATIONS; i++)
	if (q_num_of_conv[node][i] is qnum)
	{
	    finish_num[node][i] -= reset;
	    save_finish[node][i] -= reset;
	    if (num_buffers_in_q[node][i] > 0)
	    {
		for (pkt_ptr = head_conv_queue[node][i]; pkt_ptr != NULPTR; pkt_ptr = pkt_ptr->next)
		    pkt_ptr->bid -= reset;
	    }
	}
}

/************** queue of alive conversations per node per qnum *****************/

plot_qsize(conv_id, direction, source, dest)
    int             conv_id;
    int             direction;
    int             source, dest;
{
    int             num;
    char            fname[20];
    int             node, qnum;

    node = get_node_id();

    /* plot number of buffers used by this conversation */
    num = get_num_buffers_in_q(conv_id);
    sprintf(fname, "qlen.%d.", source);
    make_plot(fname, num - direction);
    make_plot(fname, num);

   /* total number of buffers used at that output queue */
    qnum = q_num_of_conv[node][conv_id];
    num = get_num_buffers_in_use(qnum);
    sprintf(fname, "allqlen.%d.", dest);
    make_plot(fname, num - direction);
    make_plot(fname, num);
}

