/* implementation of hierarchical round robin scheduling policy */
/* S. Keshav UCB/AT&T 8/1 and 8/2 1990 */
extern int             HRR_DEBUG;

#include "../kernel/real.h"

extern PKT_PTR  get_be_cell ();
extern PKT_PTR  get_from_op_q ();

 /* level 0 is the BE level */

 /* b, nb, g as defined in hrr paper */
int             b[MAX_NODES + 1][MAX_FAN_OUT][NUM_LEVELS];
int             nb[MAX_NODES + 1][MAX_FAN_OUT][NUM_LEVELS];
int             g[MAX_NODES + 1][MAX_FAN_OUT][NUM_LEVELS];
int             cur_active[MAX_NODES + 1][MAX_FAN_OUT];
static int      active;

 /* allocated values */
int             alloc_aj[MAX_NODES + 1][MAX_CONVERSATIONS];
int             alloc_b[MAX_NODES + 1][MAX_FAN_OUT][NUM_LEVELS];
int             alloc_nb[MAX_NODES + 1][MAX_FAN_OUT][NUM_LEVELS];
char            parity[MAX_NODES + 1][MAX_FAN_OUT][NUM_LEVELS];

 /* bw and jitter at each level */
float           level_bw[MAX_NODES + 1][MAX_FAN_OUT][NUM_LEVELS];
float           level_delay[MAX_NODES + 1][MAX_FAN_OUT][NUM_LEVELS];

/* these tables are used by the router */

int             conv_level[MAX_NODES + 1][MAX_CONVERSATIONS];

 /* level of a conv_id : BE conversations will map to level 0 */
int             num_cells_allocated[MAX_NODES + 1][MAX_FAN_OUT][NUM_LEVELS];

 /* number of cells allocated at each level */
PKT_PTR
hrr (qnum, dest)
    int             qnum, dest;
{
    int             conv_id;	/* current vc under consideration */
    PKT_PTR         pkt;	/* pkt chosen to be sent */
    int             node;

    node = get_node_id ();
    active = cur_active[node][qnum];	/* init active */

    /* initialize - check to see if the frame is over */

    if (nb[node][qnum][active] is 0 and b[node][qnum][active] is 0)
	reload (active, qnum);

    conv_id = head_service_list (parity[node][qnum][active], active, qnum);

    if (conv_id is - 1)		/* no conv_id on the service list */
	pkt = get_be_cell (qnum, dest);
    else
    {
	if (g[node][qnum][active] is 0)
	    g[node][qnum][active] =
		min (alloc_aj[node][conv_id], num_buffers_in_q[node][conv_id]);
	pkt = get_from_op_q (conv_id);
    }

    decrement_counters (active, qnum);

    /* assume that the conv_id is inserted at the correct level whenever a
     * packet arrives at the switch */

    if (conv_id isnt - 1)
    {
	if (num_buffers_in_q[node][conv_id] isnt 0)
	{
	    if (g[node][qnum][active] is 0)
		put_in_tail (1 - parity[node][qnum][active], active, conv_id, qnum);
	    else
		put_in_head (parity[node][qnum][active], active, conv_id, qnum);

	}
    }
/* note: if allocation of a conversation is 5, say, and it has
     only 3 cells, then two slots will be used by other conversations,
     and the two holes will be filled by BE only at the _end_ of the frame.
*/
    cur_active[node][qnum] = active = get_next_active (qnum);
    return pkt;
}

get_next_active (qnum)
    int             qnum;
{
    int             node, i;
    char            done;

    node = get_node_id ();
    done = 0;
    for (i = 1; (i < NUM_LEVELS); i++)
	if ((nb[node][qnum][i] isnt 0)
	    or (nb[node][qnum][i] is 0 and b[node][qnum][i] is 0))
	    return i;
}

reload (i, qnum)
    int             i, qnum;
{
    int             node;

    node = get_node_id ();
    b[node][qnum][i] = alloc_b[node][qnum][i];
    nb[node][qnum][i] = alloc_nb[node][qnum][i];
    g[node][qnum][i] = 0;
    parity[node][qnum][i] = 1 - parity[node][qnum][i];
}

decrement_counters (active, qnum)
    int             active, qnum;
{
    int             node, i;

    node = get_node_id ();
    for (i = 1; i < active; i++)
	b[node][qnum][i]--;

    nb[node][qnum][active]--;
    if (g[node][qnum][active])
	g[node][qnum][active]--;
}


typedef struct conv_type VC, *VC_PTR;

VC_PTR          rr_head[MAX_NODES + 1][MAX_FAN_OUT][2 * NUM_LEVELS];
VC_PTR          rr_tail[MAX_NODES + 1][MAX_FAN_OUT][2 * NUM_LEVELS];

#define NULPTR (VC_PTR) 0

init_hrr ()
{
    int             node, qnum, i;


    for (node = 0; node < MAX_NODES + 1; node++)
	for (qnum = 0; qnum < MAX_FAN_OUT; qnum++)
	{
	    for (i = 0; i < 2 * NUM_LEVELS; i++)
		rr_head[node][qnum][i] = rr_tail[node][qnum][i] = NULPTR;
	    for (i = 0; i < NUM_LEVELS; i++)
	    {
		alloc_nb[node][qnum][i] = nb_table[node][i];
		alloc_b[node][qnum][i] = b_table[node][i];
		nb[node][qnum][i] = b[node][qnum][i] = 0;
		parity[node][qnum][i] = 0;
	    }
	    cur_active[node][qnum] = 1;
	}
}

put_in_head (parity, level, conv_id, qnum)
 /* adds a vc to the head of the appropriate queue */
    char            parity;
    int             conv_id, level, qnum;
{
    VC_PTR          vc;
    int             node;

    node = get_node_id ();
    if (parity)
	if (level)
	    level += NUM_LEVELS;
    if (check_queue (conv_id, node, qnum, level))
	return;
    vc = (VC_PTR) malloc ((unsigned) sizeof (VC));
    vc->conv_id = conv_id;
    vc->next = rr_head[node][qnum][level];
    rr_head[node][qnum][level] = vc;
    if (rr_tail[node][qnum][level] is NULPTR)
	rr_tail[node][qnum][level] = vc;
}

put_in_tail (parity, level, conv_id, qnum)
 /* adds a vc to the tail of the appropriate queue */
    char            parity;
    int             conv_id, level, qnum;
{
    VC_PTR          vc;
    int             node;

    node = get_node_id ();
    if (parity)
	if (level)
	    level += NUM_LEVELS;

    if (check_queue (conv_id, node, qnum, level))
	return;
    vc = (VC_PTR) malloc ((unsigned) sizeof (VC));
    vc->conv_id = conv_id;
    vc->next = NULPTR;
    if (rr_tail[node][qnum][level] isnt NULPTR)
	rr_tail[node][qnum][level]->next = vc;
    rr_tail[node][qnum][level] = vc;
    if (rr_head[node][qnum][level] is NULPTR)
	rr_head[node][qnum][level] = vc;
}

int
head_service_list (parity, level, qnum)
    char            parity;
    int             level, qnum;
{
    int             node, conv_id;
    VC_PTR          save;

    node = get_node_id ();
    if (parity)
	if (level)
	    level += NUM_LEVELS;

    if (rr_head[node][qnum][level] is NULPTR)
    {
	if (rr_tail[node][qnum][level] isnt NULPTR)
	    pr_error ("Hrr service list screwed up !");
	else
	    return -1;
    }
    conv_id = rr_head[node][qnum][level]->conv_id;
    save = rr_head[node][qnum][level];
    rr_head[node][qnum][level] = rr_head[node][qnum][level]->next;
    free (save);
    if (rr_head[node][qnum][level] is NULPTR)
	rr_tail[node][qnum][level] = NULPTR;
    return conv_id;
}

check_queue (id, node, qnum, level)
    int             id, node, qnum, level;
{
    VC_PTR          vc;

    for (vc = rr_head[node][qnum][level]; vc != NULPTR; vc = vc->next)
	if (vc->conv_id is id)
	    return 1;
    return 0;
}

/* returns next best effort  cell in the RR queue, if nothing,
   returns 0 */

PKT_PTR
get_be_cell (qnum, dest)
    int             qnum, dest;
{
    int             node, conv_id;
    PKT_PTR         pkt;

    node = get_node_id ();
    conv_id = head_service_list (parity[node][qnum][0], 0, qnum);

    if (conv_id is - 1)		/* no BE cell to send, so send a null cell */
	return 0;
    else
    {
	pkt = get_from_op_q (conv_id);
	if (num_buffers_in_q[node][conv_id] isnt 0)
	    put_in_tail (0, 0, conv_id, qnum);
	return pkt;
    }
}

/* routines that are called from router.c for doing housekeeping */
extern float    line_speeds[MAX_NODES + 1][MAX_NODES + 1];

compute_bw_levels (qnum, dest)
    int             qnum, dest;
{
    int             i, node;
    float           fsize, bw;

    node = get_node_id ();
    bw = line_speeds[node][dest];

    for (i = 1; alloc_nb[node][qnum][i] isnt 0; i++)
    {
	if (i is 1)
	    fsize = alloc_b[node][qnum][1] + alloc_nb[node][qnum][1];
	else
	    fsize *= (alloc_nb[node][qnum][i] + alloc_b[node][qnum][i])
		/ alloc_b[node][qnum][i - 1];
	level_bw[node][qnum][i] = bw / fsize;
	level_delay[node][qnum][i] = 1000000.0 * 16 * fsize * ftp_size / bw;
	/* in usecs */
    }
}

compute_level (pkt, conv_id, qnum)
    PKT_PTR         pkt;
    int             conv_id, qnum;
{
    int             i, node, n_cells;
    float           rem;

    node = get_node_id ();
    for (i = NUM_LEVELS;
	 ((level_delay[node][qnum][i] > pkt->jitter) or
	  ((alloc_nb[node][qnum][i] - num_cells_allocated[node][qnum][i])
	   * level_bw[node][qnum][i] < pkt->ave_bandwidth)) and (i > 0);
	 i--);
    if (i is 0)
	return 0;
    conv_level[node][conv_id] = i;
    n_cells = pkt->ave_bandwidth / level_bw[node][qnum][i];
    rem = (float) pkt->ave_bandwidth / (float) level_bw[node][qnum][i] - n_cells;
    if (rem > 0)
	n_cells++;

    if (HRR_DEBUG)
	printf("Node %d: Conversation from %d to %d allocated %d slots at level %d \n",
	node, pkt->source, pkt->dest, n_cells, i);

    num_cells_allocated[node][qnum][i] += alloc_aj[node][conv_id] = n_cells;
    return 1;
}
