extern int     SCH_DEBUG ;

/*
 * this contains the fair queueing policy 
 */

#include "../kernel/real.h"

#define END_OF_TIME 10000000
#define RESET_VALUE 150000000.0

/********** DATA STRUCTURES **************/

double  finish_num[MAX_NODES + 1][MAX_CONVERSATIONS];
	/* largest finish number of any pkt. in the queue for that conv */

double  save_finish[MAX_NODES + 1][MAX_CONVERSATIONS];
	/* save the value in case of a drop */

double  round_number[MAX_NODES + 1][MAX_FAN_OUT];
	/* round number */

extern CONV_PTR head_alive_list [MAX_NODES + 1][MAX_FAN_OUT];
	/* a conv is in this list it's finish number is more than the
	   current round number. An alive conversation may have no data in 
	   the queue. A non-alive conversation may have data in the queue.
	   So, the actual conversations that have data available are kept
	   in a linked list indexed from head_conv_list (see queues.c) 
	*/

int     num_active[MAX_NODES + 1][MAX_FAN_OUT];
	/* number of active conversations */

int     net_conv [MAX_NODES + 1][MAX_FAN_OUT];
	/* number of conversations that have data in the queue for this qnum */

char	count_conv [MAX_NODES + 1][MAX_FAN_OUT];
	/* flag to trace # of conversations in this qnum */


float   last_chkpt[MAX_NODES + 1][MAX_FAN_OUT];
	/* time at which the round number is correctly known */

/***********  End *************************/

double  max_of (), min_of (), find_min_finish ();
extern float    fq_weight[MAX_NODES + 1][MAX_CONVERSATIONS];


/* 
 * called on every packet arrival. It removes old conversations on
 * the line and updates the number of active conversations 
 */

new_arrival (conv_id, qnum, pkt, dest)
int conv_id;
int qnum;
PKT_PTR pkt;
int dest;
{
    timev now;
    ident node;

    node = get_node_id ();
    now = runtime ();

    if (SCH_DEBUG and pkt -> type isnt ACK)
	printf("%f: before update, num_ac %d, round_number %f, finish number %f\n", 
		make_float(now), num_active[node][qnum], round_number[node][qnum],
  		finish_num[node][conv_id]);

    remove_old_conv (qnum, dest);
    		/* set the bid number and the finish number */
    		/* first save the old finish number to restore state later */
    save_finish[node][conv_id] = finish_num[node][conv_id];

#ifdef RESERVATIONS

    if (fq_weight[node][conv_id] isnt 0) 
    {
    	pkt->bid  = (double) ((8.0 * pkt->size) / fq_weight[node][conv_id])
    + max_of (round_number[node][qnum] - FQ_DELTA, finish_num[node][conv_id]);

    	finish_num[node][conv_id] = (double)(8.0 * pkt->size)/ fq_weight[node][conv_id]
	    + max_of (round_number[node][qnum], finish_num[node][conv_id]);
    }
    else
	pr_error ("FQ server asked to serve conversation with zero fq_weight");
#else

    pkt->bid = (double) (8.0 * pkt->size) 
    + max_of(round_number[node][qnum] - FQ_DELTA, finish_num[node][conv_id]);

    finish_num[node][conv_id] = (double) (8 * pkt->size)
	    + max_of (round_number[node][qnum], finish_num[node][conv_id]);

#endif


    /* if this packet arrived at a dead conversation, the number of active 
       conversations has gone up by one */

    /* non trivial observation : if the conversation is alive, then 
       conv_id is automatically valid. Else, if it is a reused conv_id, 
       the alive bit must have been cleared by the earlier conversation. 
       Thus, in any case, alive needs to be of size max_conv only 
    */

    if (!check_conv(conv_id, head_alive_list[node][qnum])) 
    {
	if(SCH_DEBUG)
		printf("%f: node %d qnum %d, conv from src %d became alive\n",
			make_float(now), node, qnum, pkt->source);

/*
	make_plot("nac", num_active[node][qnum]);
*/
	num_active[node][qnum]++;
/*
	make_plot("nac", num_active[node][qnum]);
*/
	add_conv(conv_id, &head_alive_list[node][qnum]);
    }
    if (SCH_DEBUG and pkt->type isnt ACK)
	printf("%f: after update, num_ac %d, round_number %f, bid %f, finish number %f\n", 
		make_float(now), num_active[node][qnum], round_number[node][qnum],
  		pkt->bid, finish_num[node][conv_id]);
}


/*
 * we need to recompute the round number iteratively till no 
 * more conversations drop out. The time at which we are sure of
 * the round number is called the checkpoint time. We successively
 * update our guess of the round number starting from the checkpoint time
 * and when we converge, mark current time as the last checkpoint time.
 */

remove_old_conv (qnum, dest)
ident qnum;
ident dest;
{
    /* discard those connections that have a finish number that has 
       dropped below the current round number */

    timev now, diff;
    ident node;
    double  r_number, tf, sp, num, finish_min;
    int     i, min_conv; 

    now = runtime ();
    node = get_node_id ();


    num = num_active[node][qnum];

    if (num <= 0) 
	return;

    /* nothing to discard */

    sp = line_speeds[node][dest];
#ifdef OLD_FQ_CODE
    r_number = (double) (round_number[node][qnum] +
	    ((sp * (float) now.tv_sec)
		+ ((sp * (float) now.tv_usec) / 1000000.0)
		- (sp * last_chkpt[node][qnum])) / (float) num);
#else
    r_number = round_number[node][qnum];
#endif

    finish_min = find_min_finish (qnum, &min_conv);
    if (min_conv is -1)
	pr_error("attempted to find min finish number in empty conv queue ");

    /* 
     * conversation min_conv was the conversation with the least finish 
     * number on the line from node to qnum 
     */

    while (finish_min < r_number and num > 0) {

	/* mark the conversation with the least finish number as inactive, and 
	   reevaluate the checkpoint at the point where that conversation 
	   would have finished */

	if (SCH_DEBUG){
	    printf ("%f: conv %d declared not alive \n", make_float(now), min_conv);
	    printf ("extrapolated round # = %f, finish # = %f\n",
				r_number, finish_min);
	}
	finish_num[node][min_conv] = 0;

	if (delete_conv(min_conv, &head_alive_list[node][qnum]) is -1)
		pr_error("new_arrival: removing alive conv that does not exist in alive list!");;

#ifdef OLD_FQ_CODE
	/* find the point where the conversation would have finished */
	tf = (last_chkpt[node][qnum] * sp
	     + (finish_min * num) - (round_number[node][qnum] * num)) /sp ; 

	/* reset checkpoint values */
	last_chkpt[node][qnum] = tf;
	round_number[node][qnum] = finish_min;
#endif
	num_active[node][qnum]--;
	num--;

#ifdef OLD_FQ_CODE
	/* recompute the extrapolated r_number */
	if (num != 0)
	    r_number = (double) (round_number[node][qnum] +
		    ((sp * (float) now.tv_sec)
			+ ((sp * (float) now.tv_usec) / MILLION)
			- (sp * last_chkpt[node][qnum])) / (float) num);
#endif
	finish_min = find_min_finish (qnum, &min_conv);
    }
    /* make another checkpoint */

#ifdef OLD_FQ_CODE
    last_chkpt[node][qnum] = make_float (now);
    round_number[node][qnum] = r_number;
#endif
    if (r_number > RESET_VALUE) {	
	round_number[node][qnum] -= RESET_VALUE;
	reset_all_finish (qnum, RESET_VALUE);
    }
}


double
        max_of (x, y)
double  x, y;

{
    return((x > y)?x:y);
}

double
        min_of (x, y)
double	x,
        y;

{
    return((x < y)?x:y);
}
