
# line 2 "lang.yacc"

grnode* 	node_table [MAX_NODES]; 
int 		i,nodeid; 
char 		*s;
int 		hrr_i = 1;
int 		d_hrr_i = 1;

extern int yylineno;
extern char* get_node_name();
extptr          prevfn, nextfn;
extern 		tx_chan();
chanptr         prevchan, nextchan;
graph  		*Sim_Graph;
grnode         *newnode;
gredge         *newedge;
struct {
	long nodefn ;
	int sink;
	int plot;
	int num_pkts;
	float on_time;
	float off_time;
	float peak;
	float average;
	long interval;
	long jitter;
	long start_time_sec ;
	long start_time_usec ;
	int  policy;
} d_node;

int 	d_nb_table [NUM_LEVELS];
int 	d_b_table [NUM_LEVELS];

struct {
	float bandwidth;
	int latency;
	float loss_prob;
	float corruption_prob;
	float loss_burst_size;
	char chan [100] ;
}d_edge;

/* note that NUMBER has a yylval of atoi(yytext), but F_NUMBER 
   has a yylval of yytext, since yylval is of type integer */

float extract_float  (number) /* for sites that dont have atof() */
char * number ;
{
int 		i;
char 		*n ;
float 		result  = 0.0 ;
int 		places_after = 0;

n = number ;
while (*n != '.')
        result = result * 10 + *(n++) - '0' ;
      
n++;
while (*n !='\0') {
        places_after ++;
        result = result * 10 + *(n++) - '0' ;
        }
while (places_after -- != 0)
        result = result /10.0;
return result ;

}

err (s)
char * s;
{
printf ("\nError at line %d: ", yylineno);
printf ("An example of correct usage is\n 	%s\n\n",s);
exit(0);
}

errline()
{
printf ("\nError at line %d: ", yylineno);
}


# define NETWORK 257
# define STRING 258
# define VERSION 259
# define PASSTIME 260
# define NEST_PARAMS 261
# define NUMBER 262
# define TRUE_OR_FALSE 263
# define MAXNODES 264
# define MONITOR 265
# define NAME 266
# define HEADER 267
# define FUNCTION 268
# define NODE 269
# define START 270
# define HALT 271
# define REPEAT 272
# define DEST 273
# define FROM 274
# define TO 275
# define BANDWIDTH 276
# define PLOT 277
# define BROADCAST 278
# define POINT2POINT 279
# define LATENCY 280
# define CHANNEL_STACK 281
# define NODE_FUNCTIONS 282
# define MONITOR_FUNCTIONS 283
# define CHANNEL_FUNCTIONS 284
# define NODES 285
# define EDGES 286
# define INTER_PKT_DELAY 287
# define ACK_SIZE 288
# define BUFFER_SIZE 289
# define RANDOM_SEED 290
# define TELNET_PKT_SIZE 291
# define FTP_PKT_SIZE 292
# define FTP_WINDOW 293
# define TELNET_WINDOW 294
# define DECONGESTION_MECHANISM 295
# define SCH_POLICY 296
# define ROUTER_NODE 297
# define REAL_NUMBER 298
# define F_NUMBER 299
# define REAL_PARAMS 300
# define DEFAULT 301
# define DIAMETER 302
# define NUM_PKTS 303
# define ON_TIME 304
# define OFF_TIME 305
# define AVERAGE 306
# define PEAK 307
# define INTERVAL 308
# define JITTER 309
# define HRR_LEVELS 310
# define PRINT_INTERVAL 311
# define END_SIMULATION 312
# define SCALE_FACTOR 313
# define START_TIME 314
# define INPUT_FILE 315
# define UTIL_TIME 316
# define CLASS 317
# define LOSS_PROB 318
# define CORRUPTION_PROB 319
# define LOSS_BURST_SIZE 320
# define LOCATION 321

#include <malloc.h>
#include <memory.h>
#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 852 "lang.yacc"
 /* programs */

char           *
get_node_name()
{
	static int      count = 1;
	char           *name, c;
	int             i;

	name = (char *) malloc((unsigned) 9);
	/* 9 bytes should be enough to get a node number */
	sprintf(name, "%s%d\0", "node", count++);
	return name;
}

 yyerror()
{ printf("Syntax error in parsing input file!\n");
}


#include "../lang/lex.yy.c"
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 217,
	123, 210,
	-2, 0,
-1, 224,
	59, 95,
	-2, 90,
-1, 263,
	125, 239,
	-2, 0,
-1, 264,
	125, 214,
	-2, 0,
-1, 308,
	125, 239,
	-2, 0,
-1, 323,
	125, 214,
	-2, 0,
-1, 418,
	59, 169,
	-2, 0,
	};
# define YYNPROD 263
# define YYLAST 621
yytabelem yyact[]={

   546,   401,   437,   143,   322,   307,   217,   208,   529,     9,
   194,   137,   419,    14,   371,   229,   220,   420,   526,     4,
   522,   422,   548,   552,   515,   519,   466,   463,   547,   262,
   342,   439,   557,   556,   551,    38,   316,   438,   543,    39,
   431,   538,   315,    40,    41,   528,    67,   423,   424,   425,
   427,   426,   428,   429,   430,   525,   317,   523,   421,   432,
   318,   433,   520,   467,   464,   434,    42,    43,    45,    44,
    46,    47,    48,    49,    50,    56,    51,    52,   267,   247,
   542,    58,   329,   540,   248,   460,   455,   452,   250,   449,
    53,    54,    55,   446,   441,    57,   356,   536,   319,   320,
   321,   533,   330,   353,   349,   503,   331,    56,   531,   517,
   346,   205,   203,   187,   251,   252,   253,   255,   254,   256,
   257,   258,   461,   456,   453,   249,   450,   184,   513,   511,
   447,   442,   502,   355,    38,   458,   444,   440,    39,   360,
   352,   350,    40,    41,   332,   333,   334,   347,   204,   202,
   186,   179,   210,   358,   548,   176,   151,   344,   340,   220,
   547,   338,   231,   215,   183,    42,    43,    45,    44,    46,
    47,    48,    49,    50,    56,    51,    52,    38,   181,   173,
    58,    39,   171,   499,   169,    40,    41,   167,   178,    53,
    54,    55,   175,   150,    57,   165,   163,   161,   159,   157,
   155,   153,   146,   144,     6,   141,   509,   140,    42,    43,
    45,    44,    46,    47,    48,    49,    50,    56,    51,    52,
   336,   247,   132,    58,   497,   131,   248,   148,   134,   133,
   250,   495,    53,    54,    55,    60,   439,    57,    61,   492,
   490,   488,   438,   486,   221,   484,   482,   480,   478,    56,
   476,   474,   472,   399,   397,   395,   251,   252,   253,   255,
   254,   256,   257,   258,   393,   391,   381,   249,   379,   377,
   375,   373,   302,   300,   298,   296,   294,   195,   292,   290,
   288,   286,   284,   213,   282,   214,   128,   126,   124,   122,
   120,   305,   118,   116,   114,   112,   110,   108,   106,   104,
   102,   100,    98,    96,    94,    92,    90,    12,   471,   228,
    35,    64,   233,    17,   364,   219,   190,   501,   261,   191,
   260,   469,   383,   363,   306,   201,   494,   304,   384,   535,
    68,   558,   555,   550,   541,   539,   537,   534,   532,   362,
   530,   527,   524,   521,   518,   335,   516,   264,   514,   512,
   510,   508,   506,   226,   470,   468,   465,   462,   459,   457,
   454,   451,   448,   445,   443,   390,   389,   388,   387,   206,
    15,    10,     7,   386,   385,   372,   370,   222,   500,   369,
    68,   368,   367,   366,   365,   361,   359,   357,   354,   351,
   348,   345,   343,   341,   339,   337,   281,   280,   279,   278,
   277,   276,   275,   274,   273,   272,   271,   270,   269,   265,
   196,   259,   224,   223,   209,   199,   198,   192,   189,   498,
   188,   185,   182,   180,   177,   174,   496,   172,   170,   168,
   166,   164,   162,    62,   493,   491,   489,   160,   487,   504,
   485,   483,   481,   479,    65,   477,   475,   473,   400,   398,
   396,   158,   156,   154,   152,   149,   147,   145,   142,   394,
   392,   382,   135,   380,   378,   376,   374,   303,   301,   299,
   297,   295,   507,   293,   291,   289,   287,   285,    89,   283,
    88,   129,   127,   125,   123,   121,    87,   119,   117,   115,
   113,   111,   109,   107,   105,   103,   101,    99,    97,    95,
    93,    91,    86,    85,    84,    83,    82,    81,    80,    79,
    78,    77,    76,    75,    74,    73,    72,    71,    70,    69,
    59,   554,   505,   549,   544,   435,   200,   314,    16,   313,
   312,   311,   246,   310,   230,   309,   308,   263,   328,   327,
   326,   325,   324,   246,    66,   268,   553,   323,   227,   225,
   216,   545,   418,   417,   416,   415,   414,   413,   412,   411,
   410,   409,   408,   407,   406,   405,   404,   403,   402,   266,
   436,   245,   244,   243,   242,   241,   240,   239,   238,   237,
   236,   235,   234,   232,   218,   207,   139,   212,   211,   197,
   138,    37,    36,    34,    33,    32,    31,    30,    29,    28,
    27,    26,    25,    24,    23,    22,    21,    20,    19,    18,
   130,    11,   193,   136,    63,    13,     8,     5,     3,     2,
     1 };
yytabelem yypact[]={

-10000000,-10000000,  -248,   -57,   249,  -291,   248,    50,  -269,   247,
  -221,   461,   177,-10000000,   188,  -221,   -79,-10000000,   460,   459,
   458,   457,   456,   455,   454,   453,   452,   451,   450,   449,
   448,   447,   446,   445,   444,   443,   427,   421,   419,   245,
   244,   243,   242,   241,   240,   239,   238,   237,   236,   235,
   234,   233,   232,   231,   229,   228,   227,   226,   225,   -34,
   -29,   -30,   403,  -274,   -51,   399,  -122,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
   -59,   398,   -60,   397,   -31,   396,  -106,   395,   -61,   394,
   -62,   393,   -63,   392,   -64,   378,   -65,   373,   -66,   372,
   -67,   371,   -75,   370,   -78,   369,   -80,   368,   -83,   366,
  -107,   365,  -111,   364,   -84,   363,  -135,   362,  -149,   361,
   359,   258,   358,-10000000,-10000000,-10000000,  -276,   154,-10000000,   357,
-10000000,   356,-10000000,-10000000,   482,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,   200,
  -150,  -151,-10000000,-10000000,   246,  -294,   355,    27,-10000000,-10000000,
   -99,-10000000,-10000000,-10000000,-10000000,-10000000,  -295,  -253,   121,-10000000,
-10000000,-10000000,   354,   353,-10000000,-10000000,   230,    53,  -110,-10000000,
  -100,  -189,   352,-10000000,-10000000,   195,-10000000,   224,   350,-10000000,
-10000000,-10000000,   -47,-10000000,   349,   348,   347,   346,   345,   344,
   343,   342,   341,   340,   339,   338,   337,   223,   221,   220,
   219,   218,   217,   215,   214,   213,   212,   211,   266,-10000000,
-10000000,-10000000,   199,  -220,  -174,-10000000,   222,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,   -38,   336,  -101,   335,  -104,   334,  -233,   333,
  -105,   332,  -152,   331,  -158,   330,  -159,   329,  -166,   328,
  -109,   327,  -123,   326,   216,   198,-10000000,-10000000,  -220,   325,
   324,   323,   322,   320,   317,  -261,   316,   210,   209,   208,
   207,   205,   197,  -174,   315,   314,   309,   308,   307,   306,
   204,   203,   194,   193,   192,  -256,-10000000,-10000000,-10000000,-10000000,
   481,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,  -225,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,  -125,-10000000,  -168,   305,  -126,   304,  -169,   303,  -173,
   302,  -175,   301,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,  -176,   300,  -127,   299,  -177,   298,  -235,   297,  -236,
   296,   196,   295,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,    52,   191,
   190,   189,   187,   186,   185,   184,   182,   180,   179,   178,
   265,   170,   163,   122,   256,  -130,   -20,-10000000,   464,   293,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
  -256,   292,   -52,   291,  -133,   290,  -134,   289,  -239,   287,
  -153,   285,  -237,   284,  -242,   283,  -244,   282,  -254,   281,
  -154,   279,  -161,   278,   206,  -165,   277,  -217,   276,  -179,
   275,  -182,-10000000,-10000000,-10000000,  -224,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,   480,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,  -234,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,   479,   274,  -228,  -102,-10000000,   463,   273,  -229,
-10000000,-10000000,-10000000,-10000000,  -230,-10000000,-10000000,   272,-10000000 };
yytabelem yypgo[]={

     0,   620,   619,   618,   617,   616,   615,   614,   613,   612,
   611,   610,   528,   313,   609,   608,   607,   606,   605,   604,
   603,   602,   601,   600,   599,   598,   597,   596,   595,   594,
   593,   310,   592,   591,   590,   589,   588,   587,   586,   585,
   584,   583,   312,   582,   581,   580,   579,   578,   577,   576,
   575,   574,   573,   572,   571,   570,     2,   315,   569,     1,
   568,   567,   566,   565,   564,   563,   562,   561,   560,   559,
   558,   557,   556,   555,   554,   553,   552,   551,     0,   550,
   549,   548,     4,   547,   542,   541,   540,   539,   538,    29,
   537,     5,   536,   535,   533,   531,   530,   529,   527 };
yytabelem yyr1[]={

     0,     2,     1,     3,     3,    10,    10,    10,    11,    11,
    11,    11,    11,     4,     4,     5,     5,    12,    12,    13,
    13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
    13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
    14,    14,    15,    15,    16,    16,    17,    17,    17,    18,
    18,    19,    19,    20,    20,    21,    21,    22,    22,    23,
    23,    24,    24,    25,    25,    26,    26,    27,    27,    28,
    28,    29,    29,    29,    30,    30,    30,    32,    32,    32,
    33,    33,    33,     7,     6,     6,     6,    35,    35,    36,
    36,    34,    38,    38,    37,    37,     8,     8,    39,    39,
    41,    41,    42,    42,    42,    42,    42,    42,    42,    42,
    42,    42,    42,    42,    42,    43,    43,    44,    44,    45,
    45,    46,    46,    47,    47,    48,    48,    48,    49,    49,
    49,    50,    50,    50,    51,    51,    51,    52,    52,    53,
    53,    54,    55,    55,    56,    56,    31,    31,    40,    40,
    58,    57,    59,    59,    60,    60,    60,    60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    60,
    61,    61,    62,    62,    63,    63,    64,    64,    65,    65,
    66,    66,    66,    67,    67,    67,    68,    68,    68,    69,
    69,    69,    70,    70,    71,    71,    72,    77,    77,    78,
    78,    73,    73,    74,    74,    75,    75,    76,    76,     9,
    81,    79,    79,    82,    82,    83,    83,    83,    83,    83,
    83,    84,    84,    84,    85,    85,    86,    86,    86,    87,
    87,    87,    88,    88,    88,    80,    80,    90,    89,    91,
    91,    92,    92,    92,    92,    92,    92,    93,    93,    94,
    94,    94,    95,    95,    96,    96,    96,    97,    97,    97,
    98,    98,    98 };
yytabelem yyr2[]={

     0,     1,    16,     0,    14,     6,     6,     7,     6,     6,
     6,     6,     5,     8,     0,     8,     0,     4,     2,     4,
     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
     4,     4,     4,     4,     4,     4,     4,     4,     4,     5,
    11,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     1,    10,     7,     1,     4,     0,     4,
     5,     5,     2,     5,     2,     5,    11,     7,     8,     7,
     4,     2,     4,     4,     4,     4,     4,     4,     4,     4,
     4,     4,     4,     4,     4,     7,     7,     7,     7,    11,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,    10,     4,     2,     9,     5,     7,     7,     4,     2,
     1,    13,     0,     6,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     7,     7,     7,     7,    11,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,    10,     4,     2,     9,
     5,     7,     7,     7,     7,     7,     7,    10,     7,    10,
     1,    10,     7,     4,     0,     4,     4,     4,     4,     4,
     5,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     8,     6,     1,     5,     0,
     4,     4,     4,     4,     4,     4,     4,     7,     5,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7 };
yytabelem yychk[]={

-10000000,    -1,    -2,    -3,   267,    -4,   261,   123,    -5,   300,
   123,   -10,   257,    -6,   282,   123,   -12,   -13,   -14,   -15,
   -16,   -17,   -18,   -19,   -20,   -21,   -22,   -23,   -24,   -25,
   -26,   -27,   -28,   -29,   -30,   -31,   -32,   -33,   256,   260,
   264,   265,   287,   288,   290,   289,   291,   292,   293,   294,
   295,   297,   298,   311,   312,   313,   296,   316,   302,    59,
    58,    61,   256,    -7,   123,   256,   -12,   125,   -13,    59,
    59,    59,    59,    59,    59,    59,    59,    59,    59,    59,
    59,    59,    59,    59,    59,    59,    59,    59,    59,    59,
    61,   256,    61,   256,    61,   256,    61,   256,    61,   256,
    61,   256,    61,   256,    61,   256,    61,   256,    61,   256,
    61,   256,    61,   256,    61,   256,    61,   256,    61,   256,
    61,   256,    61,   256,    61,   256,    61,   256,    61,   256,
   -11,   259,   256,   258,   258,    59,    -8,   285,   -34,   -38,
   258,   256,    59,   125,   262,    59,   262,    59,   258,    59,
   299,   262,    59,   262,    59,   262,    59,   262,    59,   262,
    59,   262,    59,   262,    59,   262,    59,   262,    59,   262,
    59,   262,    59,   262,    59,   299,   262,    59,   299,   262,
    59,   262,    59,   299,   262,    59,   299,   262,    59,    59,
    58,    61,    59,    -9,   286,   123,   256,   -35,    59,    59,
    44,   125,   299,   262,   299,   262,   123,   -39,   301,    59,
   125,   -36,   -37,   256,   258,   262,   -79,   301,   -40,   -57,
   269,   123,   256,    59,    59,   -80,   123,   -81,   256,   125,
   -57,   262,   -41,   -42,   -43,   -44,   -45,   -46,   -47,   -48,
   -49,   -50,   -51,   -52,   -53,   -54,   -31,   268,   273,   314,
   277,   303,   304,   305,   307,   306,   308,   309,   310,    59,
   125,   123,   -89,   -90,   123,    59,   -58,   125,   -42,    59,
    59,    59,    59,    59,    59,    59,    59,    59,    59,    59,
    59,    59,    61,   256,    61,   256,    61,   256,    61,   256,
    61,   256,    61,   256,    61,   256,    61,   256,    61,   256,
    61,   256,    61,   256,    61,   -89,   125,   -91,   -92,   -93,
   -94,   -95,   -96,   -97,   -98,   262,   256,   276,   280,   318,
   319,   320,   -82,   -83,   -84,   -85,   -86,   -87,   -88,   256,
   276,   280,   318,   319,   320,   123,   258,    59,   262,    59,
   262,    59,   263,    59,   262,    59,   262,   299,    59,   262,
   299,    59,   299,   262,    59,   299,   262,    59,   262,    59,
   262,    59,   123,   125,   -91,    59,    59,    59,    59,    59,
    59,   275,    59,    61,   256,    61,   256,    61,   256,    61,
   256,    61,   256,   125,   -82,    59,    59,    59,    59,    59,
    59,    61,   256,    61,   256,    61,   256,    61,   256,    61,
   256,   -59,   -60,   -61,   -62,   -63,   -64,   -65,   -66,   -67,
   -68,   -69,   -70,   -71,   -72,   -73,   -74,   -75,   -76,   268,
   273,   314,   277,   303,   304,   305,   307,   306,   308,   309,
   310,   296,   315,   317,   321,    44,   -55,   -56,   262,   256,
   262,   262,   299,    59,   262,    59,   262,   299,    59,   262,
   299,    59,   262,   299,    59,   262,   299,    59,   262,    59,
   262,   299,    59,   262,   299,    59,   262,   299,    59,   125,
    59,   256,    61,   256,    61,   256,    61,   256,    61,   256,
    61,   256,    61,   256,    61,   256,    61,   256,    61,   256,
    61,   256,    61,   256,    61,    61,   256,    61,   256,    61,
   256,    61,   262,   125,   -56,    58,    59,   -59,    59,   258,
    59,   262,    59,   262,    59,   263,    59,   262,    59,   262,
   299,    59,   262,   299,    59,   299,   262,    59,   299,   262,
    59,   262,    59,   262,    59,   123,   262,    59,   258,    59,
   262,    59,   262,   262,    44,   -77,   -78,   262,   256,    44,
    59,   262,   125,   -78,    58,    59,   262,   262,    59 };
yytabelem yydef[]={

     1,    -2,     3,    14,     0,    16,     0,     0,    86,     0,
     0,     0,     0,    83,     0,     0,     0,    18,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    13,    17,    19,
    20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
    30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     5,     6,     7,     0,     0,    88,     0,
    92,     0,    85,    15,     0,    41,    42,    43,    44,    45,
    46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
    56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
    66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
    76,   146,   147,    77,    78,    79,    80,    81,    82,     0,
     0,     0,    12,     2,     0,     0,     0,     0,    91,    93,
     0,     4,     8,     9,    10,    11,     0,     0,     0,    97,
    84,    87,     0,     0,    94,    40,     0,    -2,     0,   149,
     0,     0,     0,    89,    -2,     0,   237,     0,     0,    96,
   148,   150,     0,   101,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    99,
   209,   237,     0,    -2,    -2,   212,     0,    98,   100,   102,
   103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
   113,   114,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   236,   238,    -2,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    -2,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   152,   115,   116,   117,   118,
     0,   120,   121,   122,   123,   124,   125,   126,   127,   128,
   129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
   139,   140,     0,   235,   240,   241,   242,   243,   244,   245,
   246,     0,   248,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   211,   213,   215,   216,   217,   218,   219,
   220,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   154,   155,   156,   157,   158,   159,   160,
   161,   162,   163,   164,   165,   166,   167,   168,    -2,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   143,     0,     0,
   247,   249,   250,   251,   252,   253,   254,   255,   256,   257,
   258,   259,   260,   261,   262,   221,   222,   223,   224,   225,
   226,   227,   228,   229,   230,   231,   232,   233,   234,   151,
   152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   119,   141,   142,     0,   145,   153,   208,   170,
   171,   172,   173,     0,   175,   176,   177,   178,   179,   180,
   181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
   191,   192,   193,   194,   195,     0,   201,   202,   203,   204,
   205,   206,     0,     0,     0,     0,   198,     0,     0,     0,
   144,   174,   196,   197,     0,   200,   207,     0,   199 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"NETWORK",	257,
	"STRING",	258,
	"VERSION",	259,
	"PASSTIME",	260,
	"NEST_PARAMS",	261,
	"NUMBER",	262,
	"TRUE_OR_FALSE",	263,
	"MAXNODES",	264,
	"MONITOR",	265,
	"NAME",	266,
	"HEADER",	267,
	"FUNCTION",	268,
	"NODE",	269,
	"START",	270,
	"HALT",	271,
	"REPEAT",	272,
	"DEST",	273,
	"FROM",	274,
	"TO",	275,
	"BANDWIDTH",	276,
	"PLOT",	277,
	"BROADCAST",	278,
	"POINT2POINT",	279,
	"LATENCY",	280,
	"CHANNEL_STACK",	281,
	"NODE_FUNCTIONS",	282,
	"MONITOR_FUNCTIONS",	283,
	"CHANNEL_FUNCTIONS",	284,
	"NODES",	285,
	"EDGES",	286,
	"INTER_PKT_DELAY",	287,
	"ACK_SIZE",	288,
	"BUFFER_SIZE",	289,
	"RANDOM_SEED",	290,
	"TELNET_PKT_SIZE",	291,
	"FTP_PKT_SIZE",	292,
	"FTP_WINDOW",	293,
	"TELNET_WINDOW",	294,
	"DECONGESTION_MECHANISM",	295,
	"SCH_POLICY",	296,
	"ROUTER_NODE",	297,
	"REAL_NUMBER",	298,
	"F_NUMBER",	299,
	"REAL_PARAMS",	300,
	"DEFAULT",	301,
	"DIAMETER",	302,
	"NUM_PKTS",	303,
	"ON_TIME",	304,
	"OFF_TIME",	305,
	"AVERAGE",	306,
	"PEAK",	307,
	"INTERVAL",	308,
	"JITTER",	309,
	"HRR_LEVELS",	310,
	"PRINT_INTERVAL",	311,
	"END_SIMULATION",	312,
	"SCALE_FACTOR",	313,
	"START_TIME",	314,
	"INPUT_FILE",	315,
	"UTIL_TIME",	316,
	"CLASS",	317,
	"LOSS_PROB",	318,
	"CORRUPTION_PROB",	319,
	"LOSS_BURST_SIZE",	320,
	"LOCATION",	321,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"network : /* empty */",
	"network : header nest_params real_params node_functions chan_mon_filler nodes edges",
	"header : /* empty */",
	"header : HEADER '{' name ';' version ';' '}'",
	"name : NETWORK ':' STRING",
	"name : NETWORK '=' STRING",
	"name : NETWORK error ';'",
	"version : VERSION ':' F_NUMBER",
	"version : VERSION ':' NUMBER",
	"version : VERSION '=' F_NUMBER",
	"version : VERSION '=' NUMBER",
	"version : error ';'",
	"nest_params : NEST_PARAMS '{' paramlist '}'",
	"nest_params : /* empty */",
	"real_params : REAL_PARAMS '{' paramlist '}'",
	"real_params : /* empty */",
	"paramlist : paramlist param",
	"paramlist : param",
	"param : passtime ';'",
	"param : maxnodes ';'",
	"param : monitor ';'",
	"param : inter_pkt_delay ';'",
	"param : ack_size ';'",
	"param : random_seed ';'",
	"param : buffer_size ';'",
	"param : telnet_pkt_size ';'",
	"param : ftp_pkt_size ';'",
	"param : ftp_window ';'",
	"param : telnet_window ';'",
	"param : decongestion_mechanism ';'",
	"param : router_node ';'",
	"param : real_number ';'",
	"param : print_interval ';'",
	"param : end_simulation ';'",
	"param : scale_factor ';'",
	"param : d_sch_policy ';'",
	"param : util_time ';'",
	"param : diameter ';'",
	"param : error ';'",
	"passtime : PASSTIME '=' NUMBER ',' NUMBER",
	"passtime : PASSTIME error ';'",
	"maxnodes : MAXNODES '=' NUMBER",
	"maxnodes : MAXNODES error ';'",
	"monitor : MONITOR '=' STRING",
	"monitor : MONITOR error ';'",
	"inter_pkt_delay : INTER_PKT_DELAY '=' F_NUMBER",
	"inter_pkt_delay : INTER_PKT_DELAY '=' NUMBER",
	"inter_pkt_delay : INTER_PKT_DELAY error ';'",
	"ack_size : ACK_SIZE '=' NUMBER",
	"ack_size : ACK_SIZE error ';'",
	"random_seed : RANDOM_SEED '=' NUMBER",
	"random_seed : RANDOM_SEED error ';'",
	"buffer_size : BUFFER_SIZE '=' NUMBER",
	"buffer_size : BUFFER_SIZE error ';'",
	"telnet_pkt_size : TELNET_PKT_SIZE '=' NUMBER",
	"telnet_pkt_size : TELNET_PKT_SIZE error ';'",
	"ftp_pkt_size : FTP_PKT_SIZE '=' NUMBER",
	"ftp_pkt_size : FTP_PKT_SIZE error ';'",
	"ftp_window : FTP_WINDOW '=' NUMBER",
	"ftp_window : FTP_WINDOW error ';'",
	"telnet_window : TELNET_WINDOW '=' NUMBER",
	"telnet_window : TELNET_WINDOW error ';'",
	"decongestion_mechanism : DECONGESTION_MECHANISM '=' NUMBER",
	"decongestion_mechanism : DECONGESTION_MECHANISM error ';'",
	"router_node : ROUTER_NODE '=' NUMBER",
	"router_node : ROUTER_NODE error ';'",
	"real_number : REAL_NUMBER '=' NUMBER",
	"real_number : REAL_NUMBER error ';'",
	"print_interval : PRINT_INTERVAL '=' NUMBER",
	"print_interval : PRINT_INTERVAL error ';'",
	"end_simulation : END_SIMULATION '=' F_NUMBER",
	"end_simulation : END_SIMULATION '=' NUMBER",
	"end_simulation : END_SIMULATION error ';'",
	"scale_factor : SCALE_FACTOR '=' F_NUMBER",
	"scale_factor : SCALE_FACTOR '=' NUMBER",
	"scale_factor : SCALE_FACTOR error ';'",
	"util_time : UTIL_TIME '=' F_NUMBER",
	"util_time : UTIL_TIME '=' NUMBER",
	"util_time : UTIL_TIME error ';'",
	"diameter : DIAMETER '=' F_NUMBER",
	"diameter : DIAMETER '=' NUMBER",
	"diameter : DIAMETER error ';'",
	"chan_mon_filler : /* empty */",
	"node_functions : NODE_FUNCTIONS '{' firstnodefunc functionlist '}'",
	"node_functions : NODE_FUNCTIONS error ';'",
	"node_functions : /* empty */",
	"functionlist : functionlist function",
	"functionlist : /* empty */",
	"function : fn ';'",
	"function : error ';'",
	"firstnodefunc : firstnfn ';'",
	"firstnfn : STRING",
	"firstnfn : error ';'",
	"fn : STRING",
	"fn : error ';'",
	"nodes : NODES '{' defaultnode nodelist '}'",
	"nodes : NODES error ';'",
	"defaultnode : DEFAULT '{' defaultdatalist '}'",
	"defaultnode : DEFAULT error ';'",
	"defaultdatalist : defaultdatalist defaultdata",
	"defaultdatalist : defaultdata",
	"defaultdata : d_nodefn ';'",
	"defaultdata : d_sink ';'",
	"defaultdata : d_start_time ';'",
	"defaultdata : d_plot ';'",
	"defaultdata : d_num_pkts ';'",
	"defaultdata : d_on_time ';'",
	"defaultdata : d_off_time ';'",
	"defaultdata : d_peak ';'",
	"defaultdata : d_average ';'",
	"defaultdata : d_interval ';'",
	"defaultdata : d_jitter ';'",
	"defaultdata : d_hrr_levels ';'",
	"defaultdata : d_sch_policy ';'",
	"d_nodefn : FUNCTION '=' STRING",
	"d_nodefn : FUNCTION error ';'",
	"d_sink : DEST '=' NUMBER",
	"d_sink : DEST error ';'",
	"d_start_time : START_TIME '=' NUMBER ',' NUMBER",
	"d_start_time : START_TIME error ';'",
	"d_plot : PLOT '=' TRUE_OR_FALSE",
	"d_plot : PLOT error ';'",
	"d_num_pkts : NUM_PKTS '=' NUMBER",
	"d_num_pkts : NUM_PKTS error ';'",
	"d_on_time : ON_TIME '=' NUMBER",
	"d_on_time : ON_TIME '=' F_NUMBER",
	"d_on_time : ON_TIME error ';'",
	"d_off_time : OFF_TIME '=' NUMBER",
	"d_off_time : OFF_TIME '=' F_NUMBER",
	"d_off_time : OFF_TIME error ';'",
	"d_peak : PEAK '=' F_NUMBER",
	"d_peak : PEAK '=' NUMBER",
	"d_peak : PEAK error ';'",
	"d_average : AVERAGE '=' F_NUMBER",
	"d_average : AVERAGE '=' NUMBER",
	"d_average : AVERAGE error ';'",
	"d_interval : INTERVAL '=' NUMBER",
	"d_interval : INTERVAL error ';'",
	"d_jitter : JITTER '=' NUMBER",
	"d_jitter : JITTER error ';'",
	"d_hrr_levels : HRR_LEVELS '=' '{' d_hrr_list '}'",
	"d_hrr_list : d_hrr_list d_hrr_pair",
	"d_hrr_list : d_hrr_pair",
	"d_hrr_pair : NUMBER ':' NUMBER ';'",
	"d_hrr_pair : error ';'",
	"d_sch_policy : SCH_POLICY '=' NUMBER",
	"d_sch_policy : SCH_POLICY error ';'",
	"nodelist : nodelist node",
	"nodelist : node",
	"node : NODE NUMBER",
	"node : NODE NUMBER '{' nodedata '}'",
	"nodedata : /* empty */",
	"nodedata : nodedatum ';' nodedata",
	"nodedatum : nodefn",
	"nodedatum : sink",
	"nodedatum : start_time",
	"nodedatum : plot",
	"nodedatum : num_pkts",
	"nodedatum : on_time",
	"nodedatum : off_time",
	"nodedatum : peak",
	"nodedatum : average",
	"nodedatum : interval",
	"nodedatum : jitter",
	"nodedatum : hrr_levels",
	"nodedatum : sch_policy",
	"nodedatum : input_file",
	"nodedatum : class",
	"nodedatum : location",
	"nodefn : FUNCTION '=' STRING",
	"nodefn : FUNCTION error ';'",
	"sink : DEST '=' NUMBER",
	"sink : DEST error ';'",
	"start_time : START_TIME '=' NUMBER ',' NUMBER",
	"start_time : START_TIME error ';'",
	"plot : PLOT '=' TRUE_OR_FALSE",
	"plot : PLOT error ';'",
	"num_pkts : NUM_PKTS '=' NUMBER",
	"num_pkts : NUM_PKTS error ';'",
	"on_time : ON_TIME '=' NUMBER",
	"on_time : ON_TIME '=' F_NUMBER",
	"on_time : ON_TIME error ';'",
	"off_time : OFF_TIME '=' NUMBER",
	"off_time : OFF_TIME '=' F_NUMBER",
	"off_time : OFF_TIME error ';'",
	"peak : PEAK '=' F_NUMBER",
	"peak : PEAK '=' NUMBER",
	"peak : PEAK error ';'",
	"average : AVERAGE '=' F_NUMBER",
	"average : AVERAGE '=' NUMBER",
	"average : AVERAGE error ';'",
	"interval : INTERVAL '=' NUMBER",
	"interval : INTERVAL error ';'",
	"jitter : JITTER '=' NUMBER",
	"jitter : JITTER error ';'",
	"hrr_levels : HRR_LEVELS '=' '{' hrr_list '}'",
	"hrr_list : hrr_list hrr_pair",
	"hrr_list : hrr_pair",
	"hrr_pair : NUMBER ':' NUMBER ';'",
	"hrr_pair : error ';'",
	"sch_policy : SCH_POLICY '=' NUMBER",
	"sch_policy : SCH_POLICY error ';'",
	"input_file : INPUT_FILE '=' STRING",
	"input_file : INPUT_FILE error ';'",
	"class : CLASS '=' NUMBER",
	"class : CLASS error ';'",
	"location : LOCATION '=' NUMBER ',' NUMBER",
	"location : location error ';'",
	"edges : EDGES '{' defaultedge edgelist '}'",
	"defaultedge : DEFAULT",
	"defaultedge : DEFAULT '{' default_edge_data '}'",
	"defaultedge : DEFAULT error ';'",
	"default_edge_data : default_edge_datum default_edge_data",
	"default_edge_data : /* empty */",
	"default_edge_datum : d_bandwidth ';'",
	"default_edge_datum : d_latency ';'",
	"default_edge_datum : d_loss_prob ';'",
	"default_edge_datum : d_corruption_prob ';'",
	"default_edge_datum : d_loss_burst_size ';'",
	"default_edge_datum : error ';'",
	"d_bandwidth : BANDWIDTH '=' NUMBER",
	"d_bandwidth : BANDWIDTH '=' F_NUMBER",
	"d_bandwidth : BANDWIDTH error ';'",
	"d_latency : LATENCY '=' NUMBER",
	"d_latency : LATENCY error ';'",
	"d_loss_prob : LOSS_PROB '=' NUMBER",
	"d_loss_prob : LOSS_PROB '=' F_NUMBER",
	"d_loss_prob : LOSS_PROB error ';'",
	"d_corruption_prob : CORRUPTION_PROB '=' NUMBER",
	"d_corruption_prob : CORRUPTION_PROB '=' F_NUMBER",
	"d_corruption_prob : CORRUPTION_PROB error ';'",
	"d_loss_burst_size : LOSS_BURST_SIZE '=' NUMBER",
	"d_loss_burst_size : LOSS_BURST_SIZE '=' F_NUMBER",
	"d_loss_burst_size : LOSS_BURST_SIZE error ';'",
	"edgelist : edgelist '{' edge '}'",
	"edgelist : '{' edge '}'",
	"edge : /* empty */",
	"edge : edgedata",
	"edgedata : /* empty */",
	"edgedata : edgedatum edgedata",
	"edgedatum : from ';'",
	"edgedatum : bandwidth ';'",
	"edgedatum : latency ';'",
	"edgedatum : loss_prob ';'",
	"edgedatum : corruption_prob ';'",
	"edgedatum : loss_burst_size ';'",
	"from : NUMBER TO NUMBER",
	"from : error ';'",
	"bandwidth : BANDWIDTH '=' NUMBER",
	"bandwidth : BANDWIDTH '=' F_NUMBER",
	"bandwidth : BANDWIDTH error ';'",
	"latency : LATENCY '=' NUMBER",
	"latency : LATENCY error ';'",
	"loss_prob : LOSS_PROB '=' NUMBER",
	"loss_prob : LOSS_PROB '=' F_NUMBER",
	"loss_prob : LOSS_PROB error ';'",
	"corruption_prob : CORRUPTION_PROB '=' NUMBER",
	"corruption_prob : CORRUPTION_PROB '=' F_NUMBER",
	"corruption_prob : CORRUPTION_PROB error ';'",
	"loss_burst_size : LOSS_BURST_SIZE '=' NUMBER",
	"loss_burst_size : LOSS_BURST_SIZE '=' F_NUMBER",
	"loss_burst_size : LOSS_BURST_SIZE error ';'",
};
#endif /* YYDEBUG */
#if !defined(lint) && !defined(__cplusplus)
static  char __yaccpar_sccsid1[] = "@(#) 7/13/94 yaccpar 6.11 Copyr 1991 Sun Micro";
#endif

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yynewmax * sizeof(type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside switch should never be
	executed; yypvt is set to 0 to avoid "used before set" warning.
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
	yypvt = 0;
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 103 "lang.yacc"
{ /* defaults go here  */
				 Sim_Graph = new(graph);
				 Sim_Graph->flags = Nest_Flags;
				 Sim_Graph->protocol = Nest_Graph;
				 Sim_Graph -> header = new(grhead);
				 Sim_Graph->header->wakeups.tv_sec= 0;
				 Sim_Graph->header->wakeups.tv_usec= 0;
				 Sim_Graph->header->delay= 0;
				 Sim_Graph->header->logging = false;
				 Sim_Graph->header->broadcast= false;
				 Sim_Graph->header->point2point= true;
				 Sim_Graph->header->timenow.tv_sec= 0;
				 Sim_Graph->header->timenow.tv_usec= 0;
				 Sim_Graph->header->passes= 0 ;
				 Sim_Graph->header->passtime.tv_sec= 1;
 				 Sim_Graph->header->passtime.tv_usec= 0;
				 Sim_Graph->header->nodes = MAX_NODES;
				 Sim_Graph->header->monitor = custom_monitor;
				 inter_pkt = 5.0;
				 ack_size = 40;
				 random_seed = 0;
				 op_qsize = 12000;
				 ftp_size = 500;
				 telnet_size = 40;
 				 ftp_window = 5;
				 telnet_window = 5;
				 decongest_mechanism = 1;
				 cc_router = 1;
				 realnum = 0;
				 print_interval = 100;
				 end_simulation = 1000;
				 scale_factor = 1.0;
				 d_node.policy = 1;
				} break;
case 7:
# line 154 "lang.yacc"
{ err("network : Example_network ; "); } break;
case 12:
# line 162 "lang.yacc"
{ err("version : 2.0 "); } break;
case 39:
# line 198 "lang.yacc"
{
			errline();
			printf("Declared parameter is not a REAL or NEST parameter\n");
			exit(0);
			} break;
case 40:
# line 206 "lang.yacc"
{
			Sim_Graph->header->passtime.tv_sec= yypvt[-2];
 			Sim_Graph->header->passtime.tv_usec= yypvt[-0];
			} break;
case 41:
# line 211 "lang.yacc"
{ err ("passtime = 1,0"); } break;
case 42:
# line 215 "lang.yacc"
{ Sim_Graph->header->nodes= yypvt[-0]; 
		 	  if(Sim_Graph->header->nodes >  MAX_NODES)
				pr_error("MAX_NODES in config.h less than in input declaration");
			} break;
case 43:
# line 220 "lang.yacc"
{ err("maxnodes = 20") ; } break;
case 44:
# line 224 "lang.yacc"
{ Sim_Graph->header->monitor = put_address(yypvt[-0]);} break;
case 45:
# line 226 "lang.yacc"
{ err("monitor = custom_monitor "); } break;
case 46:
# line 229 "lang.yacc"
{ inter_pkt = extract_float(yypvt[-0]); } break;
case 47:
# line 231 "lang.yacc"
{ inter_pkt = yypvt[-0]; } break;
case 48:
# line 233 "lang.yacc"
{err("inter_pkt_delay = 5.0 ");} break;
case 49:
# line 236 "lang.yacc"
{ ack_size = yypvt[-0];} break;
case 50:
# line 238 "lang.yacc"
{err("ack_size = 5");} break;
case 51:
# line 241 "lang.yacc"
{ random_seed = yypvt[-0];} break;
case 52:
# line 243 "lang.yacc"
{err("random_seed = 0");} break;
case 53:
# line 246 "lang.yacc"
{op_qsize =  yypvt[-0];} break;
case 54:
# line 248 "lang.yacc"
{err("buffer_size = 15") ;} break;
case 55:
# line 251 "lang.yacc"
{telnet_size =yypvt[-0]; } break;
case 56:
# line 253 "lang.yacc"
{err("telnet_pkt_size = 40 ");} break;
case 57:
# line 256 "lang.yacc"
{ftp_size =yypvt[-0];} break;
case 58:
# line 258 "lang.yacc"
{err("ftp_pkt_size = 5") ;} break;
case 59:
# line 261 "lang.yacc"
{ftp_window = yypvt[-0];
			if(ftp_window>MAX_WINDOW_SIZE)
				pr_error("ftp window larger than max in config.h"); } break;
case 60:
# line 265 "lang.yacc"
{err("ftp_window = 5") ;} break;
case 61:
# line 268 "lang.yacc"
{telnet_window = yypvt[-0];  
			if(telnet_window>MAX_WINDOW_SIZE) 
				pr_error("telnet window larger than max in config.h"); } break;
case 62:
# line 272 "lang.yacc"
{err("telnet_window = 5") ;} break;
case 63:
# line 275 "lang.yacc"
{decongest_mechanism =  yypvt[-0]; } break;
case 64:
# line 277 "lang.yacc"
{err("decongestion_mechanism = 0");} break;
case 65:
# line 281 "lang.yacc"
{cc_router = yypvt[-0]; } break;
case 66:
# line 283 "lang.yacc"
{err("router_node = 0 ");} break;
case 67:
# line 286 "lang.yacc"
{realnum = yypvt[-0]; } break;
case 68:
# line 288 "lang.yacc"
{err("real_number = 0") ;} break;
case 69:
# line 292 "lang.yacc"
{print_interval = yypvt[-0]; } break;
case 70:
# line 294 "lang.yacc"
{err(" print_interval = 3") ;} break;
case 71:
# line 297 "lang.yacc"
{end_simulation  = extract_float (yypvt[-0]); } break;
case 72:
# line 299 "lang.yacc"
{end_simulation = yypvt[-0]; } break;
case 73:
# line 301 "lang.yacc"
{err(" end_simulation = 500");} break;
case 74:
# line 305 "lang.yacc"
{scale_factor = extract_float(yypvt[-0]);} break;
case 75:
# line 307 "lang.yacc"
{scale_factor = yypvt[-0];} break;
case 76:
# line 309 "lang.yacc"
{err(" scale_factor = 1000");} break;
case 77:
# line 313 "lang.yacc"
{util_time = extract_float(yypvt[-0]);} break;
case 78:
# line 315 "lang.yacc"
{util_time = yypvt[-0];} break;
case 79:
# line 317 "lang.yacc"
{err(" util_time = 1000");} break;
case 80:
# line 321 "lang.yacc"
{diameter = extract_float(yypvt[-0]);} break;
case 81:
# line 323 "lang.yacc"
{diameter = yypvt[-0];} break;
case 82:
# line 325 "lang.yacc"
{err(" diameter = 1000.0");} break;
case 83:
# line 328 "lang.yacc"
{
			  nextfn = new(extfunc); 
			  nextfn->addr = tx_chan;
			  Sim_Graph->header->chanfns = nextfn;
			  nextfn->next = nil;
			  nextfn = new(extfunc); 
			  nextfn->addr = (char*)custom_monitor;
			  prevfn = Sim_Graph->header->monfns = nextfn;
		  	  prevfn->next = nil;
			  Sim_Graph->nodes = (grnode*) nil;
		  	} break;
case 85:
# line 342 "lang.yacc"
{err("node_functions { FUNCTION LIST }");} break;
case 86:
# line 347 "lang.yacc"
{nextfn = new(extfunc);
			 nextfn->addr = put_address("main");
			 nextfn->next = nil;
		         Sim_Graph->header->nodefns = nextfn;} break;
case 90:
# line 360 "lang.yacc"
{errline();
			printf ("function improperly declared \n");
			exit(0);} break;
case 91:
# line 368 "lang.yacc"
{nextfn = new(extfunc);
                         nextfn->addr = put_address("main");
                         nextfn->next = nil;
                         Sim_Graph->header->nodefns = nextfn;} break;
case 93:
# line 376 "lang.yacc"
{err("function = ftp_source") ;} break;
case 95:
# line 381 "lang.yacc"
{err("function = ftp_source ");} break;
case 96:
# line 385 "lang.yacc"
{Sim_Graph -> edges = (gredge*) nil ;} break;
case 97:
# line 387 "lang.yacc"
{err("nodes { {DEFAULT} NODE LIST } ");} break;
case 99:
# line 392 "lang.yacc"
{errline();
			 printf("Error in default node definition\n");
			exit(0);} break;
case 115:
# line 417 "lang.yacc"
{ d_node.nodefn = put_address(yypvt[-0]);} break;
case 116:
# line 419 "lang.yacc"
{err("function = ftp_source ");} break;
case 117:
# line 423 "lang.yacc"
{ d_node.sink = yypvt[-0];} break;
case 118:
# line 425 "lang.yacc"
{err("sink = 4") ;} break;
case 119:
# line 428 "lang.yacc"
{d_node.start_time_sec = yypvt[-2];
			d_node.start_time_usec = yypvt[-0];} break;
case 120:
# line 432 "lang.yacc"
{ err("start_time = 1,10000 "); } break;
case 121:
# line 437 "lang.yacc"
{ d_node.plot = yypvt[-0] ;} break;
case 122:
# line 439 "lang.yacc"
{err("plot = true ");} break;
case 123:
# line 443 "lang.yacc"
{ d_node.num_pkts = yypvt[-0];} break;
case 124:
# line 445 "lang.yacc"
{err ("num_pkts = 2000") ;} break;
case 125:
# line 449 "lang.yacc"
{ d_node.on_time = 1.0e-6 * ((float)yypvt[-0]);} break;
case 126:
# line 451 "lang.yacc"
{ d_node.on_time = 1.0e-6 * extract_float(yypvt[-0]);} break;
case 127:
# line 453 "lang.yacc"
{err ("on_time = 2000.0 ");} break;
case 128:
# line 457 "lang.yacc"
{ d_node.off_time = 1.0e-6 * ((float)yypvt[-0]);} break;
case 129:
# line 459 "lang.yacc"
{ d_node.off_time = 1.0e-6 * extract_float(yypvt[-0]);} break;
case 130:
# line 461 "lang.yacc"
{err ("off_time = 2000.0 ");} break;
case 131:
# line 465 "lang.yacc"
{ d_node.peak = extract_float(yypvt[-0]);} break;
case 132:
# line 467 "lang.yacc"
{ d_node.peak = yypvt[-0];} break;
case 133:
# line 469 "lang.yacc"
{err ("peak = 2000.0 ");} break;
case 134:
# line 473 "lang.yacc"
{ d_node.average = extract_float(yypvt[-0]);} break;
case 135:
# line 475 "lang.yacc"
{ d_node.average = yypvt[-0];} break;
case 136:
# line 477 "lang.yacc"
{err ("average = 2000.0") ;} break;
case 137:
# line 481 "lang.yacc"
{ d_node.interval = yypvt[-0];} break;
case 138:
# line 483 "lang.yacc"
{err ("interval = 2000");} break;
case 139:
# line 487 "lang.yacc"
{ d_node.jitter  = yypvt[-0];} break;
case 140:
# line 489 "lang.yacc"
{err ("jitter  = 2000") ;} break;
case 144:
# line 500 "lang.yacc"
{ d_nb_table[hrr_i] =  yypvt[-3];
			  d_b_table[hrr_i] =  yypvt[-1];
			  d_hrr_i++ ;
			} break;
case 145:
# line 505 "lang.yacc"
{ err("5:3 "); } break;
case 146:
# line 507 "lang.yacc"
{d_node.policy = yypvt[-0]; } break;
case 147:
# line 509 "lang.yacc"
{err("sch_policy = 3") ;} break;
case 150:
# line 517 "lang.yacc"
{ 
		 	newnode = new(grnode);
			node_table[yypvt[-0]] = newnode;
		        nodeid = yypvt[-0];
			newnode -> nodedata = new(grnodedat);
			newnode -> nodedata -> nodeid = yypvt[-0];
			newnode -> nodedata -> function = d_node.nodefn;
                        newnode->nodedata->start= true;
                        newnode->nodedata->repeat= false;
                        newnode->nodedata->halt= false;
			node_start_time[yypvt[-0]].tv_sec =d_node.start_time_sec;
			node_start_time[yypvt[-0]].tv_usec = d_node.start_time_usec;

			newnode->nodedata->sink = d_node.sink;
			
 			if (d_node.plot)
                        	newnode->nodedata->plot= true;
                        else
                         	newnode->nodedata->plot= false;

			num_pkts [yypvt[-0]] = 	d_node.num_pkts;
			on_time [yypvt[-0]]  = 	d_node.on_time;
			off_time [yypvt[-0]] = 	d_node.off_time;
			peak_bandwidth [yypvt[-0]] = 	d_node.peak;
			ave_bandwidth [yypvt[-0]] = 	d_node.average;
			interval [yypvt[-0]] = 	d_node.interval;
			jitter [yypvt[-0]] =		d_node.jitter;
			policy [yypvt[-0]] = 		d_node.policy;
		 	for(i=1; i <= NUM_LEVELS; i++)
				{
				 nb_table[yypvt[-0]][i] = d_nb_table[i];
				 b_table[yypvt[-0]][i] = d_b_table[i];
				}
		   	hrr_i =  1;
			} break;
case 151:
# line 554 "lang.yacc"
{insn(newnode, &Sim_Graph -> nodes);} break;
case 170:
# line 580 "lang.yacc"
{newnode ->nodedata->function = put_address(yypvt[-0]);} break;
case 171:
# line 582 "lang.yacc"
{err("function = ftp_source");} break;
case 172:
# line 586 "lang.yacc"
{ newnode->nodedata->sink = yypvt[-0];} break;
case 173:
# line 588 "lang.yacc"
{err("sink = 4") ;} break;
case 174:
# line 591 "lang.yacc"
{node_start_time[nodeid].tv_sec = yypvt[-2];
			 node_start_time[nodeid].tv_usec = yypvt[-0];} break;
case 175:
# line 595 "lang.yacc"
{ err("start_time = 1,10000") ; } break;
case 176:
# line 600 "lang.yacc"
{if (yypvt[-0])
				newnode->nodedata->plot= true;
			else
				newnode->nodedata->plot= false;} break;
case 177:
# line 605 "lang.yacc"
{err("plot = true ");} break;
case 178:
# line 609 "lang.yacc"
{num_pkts[nodeid] = yypvt[-0];} break;
case 179:
# line 611 "lang.yacc"
{err ("num_pkts = 2000") ;} break;
case 180:
# line 615 "lang.yacc"
{on_time[nodeid] = 1.0e-6 * ((float) yypvt[-0]);} break;
case 181:
# line 617 "lang.yacc"
{on_time[nodeid] = 1.0e-6 * extract_float(yypvt[-0]);} break;
case 182:
# line 619 "lang.yacc"
{err ("on_time = 2000.0 ");} break;
case 183:
# line 622 "lang.yacc"
{ off_time[nodeid] = 1.0e-6 * ((float) yypvt[-0]);} break;
case 184:
# line 624 "lang.yacc"
{ off_time[nodeid] = 1.0e-6 * extract_float(yypvt[-0]);} break;
case 185:
# line 626 "lang.yacc"
{err ("off_time = 2000.0 ");} break;
case 186:
# line 631 "lang.yacc"
{peak_bandwidth[nodeid] =  extract_float(yypvt[-0]);} break;
case 187:
# line 633 "lang.yacc"
{peak_bandwidth[nodeid] =  yypvt[-0];} break;
case 188:
# line 635 "lang.yacc"
{err ("peak = 2000.0") ;} break;
case 189:
# line 639 "lang.yacc"
{ave_bandwidth[nodeid] = extract_float(yypvt[-0]);} break;
case 190:
# line 641 "lang.yacc"
{ave_bandwidth[nodeid] = yypvt[-0];} break;
case 191:
# line 643 "lang.yacc"
{err ("average = 2000.0 ");} break;
case 192:
# line 647 "lang.yacc"
{ interval[nodeid] = yypvt[-0];} break;
case 193:
# line 649 "lang.yacc"
{err ("interval = 2000 ");} break;
case 194:
# line 653 "lang.yacc"
{ jitter [nodeid] =  yypvt[-0];} break;
case 195:
# line 655 "lang.yacc"
{err ("jitter = 2000") ;} break;
case 199:
# line 666 "lang.yacc"
{ nb_table[nodeid][hrr_i] =  yypvt[-3];
			  b_table[nodeid][hrr_i] =  yypvt[-1];
			  hrr_i++ ;
			} break;
case 200:
# line 671 "lang.yacc"
{ err("5:3 "); } break;
case 201:
# line 674 "lang.yacc"
{policy[nodeid] = yypvt[-0]; } break;
case 202:
# line 676 "lang.yacc"
{err("sch_policy = 3");} break;
case 203:
# line 680 "lang.yacc"
{strcat (input_file[nodeid], yypvt[-0]);} break;
case 204:
# line 682 "lang.yacc"
{ err("input_file = /usr/keshav/sim/sim/inp1; "); } break;
case 205:
# line 686 "lang.yacc"
{class[nodeid] = yypvt[-0]; } break;
case 206:
# line 688 "lang.yacc"
{err("class = 3");} break;
case 208:
# line 693 "lang.yacc"
{ err("location = 1, 5") ; } break;
case 210:
# line 702 "lang.yacc"
{
			d_edge.bandwidth = 0.0 ;
			d_edge.latency  = 0 ;
			d_edge.loss_prob = 0.0 ;
			d_edge.corruption_prob = 0.0 ;
			d_edge.loss_burst_size = 0.0 ;
			strcpy (d_edge.chan, "tx_chan");
			} break;
case 212:
# line 713 "lang.yacc"
{ errline();
			  printf("Error in default edge definition\n");
			  exit(0);
  			} break;
case 220:
# line 728 "lang.yacc"
{errline();
			 printf ("Error in default edge definition\n");
			 exit(0);} break;
case 221:
# line 734 "lang.yacc"
{ d_edge.bandwidth = (float) yypvt[-0];} break;
case 222:
# line 736 "lang.yacc"
{ d_edge.bandwidth = extract_float(yypvt[-0]);} break;
case 223:
# line 738 "lang.yacc"
{err("bandwidth = 40.0") ;} break;
case 224:
# line 742 "lang.yacc"
{d_edge.latency = yypvt[-0];} break;
case 225:
# line 744 "lang.yacc"
{err("latency = 10") ;} break;
case 226:
# line 748 "lang.yacc"
{ d_edge.loss_prob = (float) yypvt[-0];} break;
case 227:
# line 750 "lang.yacc"
{ d_edge.loss_prob = extract_float(yypvt[-0]);} break;
case 228:
# line 752 "lang.yacc"
{err("loss_prob = 0.5") ;} break;
case 229:
# line 756 "lang.yacc"
{ d_edge.corruption_prob = (float) yypvt[-0];} break;
case 230:
# line 758 "lang.yacc"
{ d_edge.corruption_prob = extract_float(yypvt[-0]);} break;
case 231:
# line 760 "lang.yacc"
{err("corruption_prob = 0.5") ;} break;
case 232:
# line 764 "lang.yacc"
{ d_edge.loss_burst_size = (float) yypvt[-0];} break;
case 233:
# line 766 "lang.yacc"
{ d_edge.loss_burst_size = extract_float(yypvt[-0]);} break;
case 234:
# line 768 "lang.yacc"
{err("loss_burst_size = 40.0") ;} break;
case 237:
# line 775 "lang.yacc"
{
			newedge = new(gredge);
			newedge->edgedata = new(gredgedat);
			newedge->edgedata->line_speed = d_edge.bandwidth;
			newedge->edgedata->loss_prob = d_edge.loss_prob;
			newedge->edgedata->corruption_prob = d_edge.corruption_prob;
			newedge->edgedata->loss_burst_size = d_edge.loss_burst_size;
                        newedge->edgedata->weight =d_edge.latency;
			nextchan = new(struct cfunc);
			nextchan->addr = put_address(d_edge.chan);
			newedge ->edgedata->delete = false;
			newedge ->edgedata->unused = 0;
			newedge ->edgedata->chanstack = nextchan ;
			newedge ->edgedata->chanstack->next = nil;} break;
case 238:
# line 792 "lang.yacc"
{insn(newedge, &Sim_Graph ->edges);} break;
case 247:
# line 807 "lang.yacc"
{newedge -> node1 = node_table[yypvt[-2]];
			 newedge -> node2 = node_table[yypvt[-0]]; } break;
case 248:
# line 810 "lang.yacc"
{err(" 1 -> 2; ");} break;
case 249:
# line 814 "lang.yacc"
{newedge->edgedata->line_speed=(float)yypvt[-0] ;} break;
case 250:
# line 816 "lang.yacc"
{newedge->edgedata->line_speed=extract_float(yypvt[-0]);} break;
case 251:
# line 818 "lang.yacc"
{err("bandwidth = 40.0 ");} break;
case 252:
# line 822 "lang.yacc"
{newedge->edgedata->weight =yypvt[-0];
		  	newedge->edgedata->delete=false;} break;
case 253:
# line 825 "lang.yacc"
{err("latency = 10 ");} break;
case 254:
# line 829 "lang.yacc"
{ newedge->edgedata->loss_prob = (float) yypvt[-0];} break;
case 255:
# line 831 "lang.yacc"
{ newedge->edgedata->loss_prob = extract_float(yypvt[-0]);} break;
case 256:
# line 833 "lang.yacc"
{err("loss_prob = 0.5") ;} break;
case 257:
# line 837 "lang.yacc"
{ newedge->edgedata->corruption_prob = (float) yypvt[-0];} break;
case 258:
# line 839 "lang.yacc"
{ newedge->edgedata->corruption_prob = extract_float(yypvt[-0]);} break;
case 259:
# line 841 "lang.yacc"
{err("corruption_prob = 0.5") ;} break;
case 260:
# line 845 "lang.yacc"
{ newedge->edgedata->loss_burst_size = (float) yypvt[-0];} break;
case 261:
# line 847 "lang.yacc"
{ newedge->edgedata->loss_burst_size = extract_float(yypvt[-0]);} break;
case 262:
# line 849 "lang.yacc"
{err("loss_burst_size = 40.0") ;} break;
	}
	goto yystack;		/* reset registers in driver code */
}

