%{

grnode* 	node_table [MAX_NODES]; 
int 		i,nodeid; 
char 		*s;
int 		hrr_i = 1;
int 		d_hrr_i = 1;

extern int yylineno;
extern char* get_node_name();
extptr          prevfn, nextfn;
extern 		tx_chan();
chanptr         prevchan, nextchan;
graph  		*Sim_Graph;
grnode         *newnode;
gredge         *newedge;
struct {
	long nodefn ;
	int sink;
	int plot;
	int num_pkts;
	float on_time;
	float off_time;
	float peak;
	float average;
	long interval;
	long jitter;
	long start_time_sec ;
	long start_time_usec ;
	int  policy;
} d_node;

int 	d_nb_table [NUM_LEVELS];
int 	d_b_table [NUM_LEVELS];

struct {
	float bandwidth;
	int latency;
	float loss_prob;
	float corruption_prob;
	float loss_burst_size;
	char chan [100] ;
}d_edge;

/* note that NUMBER has a yylval of atoi(yytext), but F_NUMBER 
   has a yylval of yytext, since yylval is of type integer */

float extract_float  (number) /* for sites that dont have atof() */
char * number ;
{
int 		i;
char 		*n ;
float 		result  = 0.0 ;
int 		places_after = 0;

n = number ;
while (*n != '.')
        result = result * 10 + *(n++) - '0' ;
      
n++;
while (*n !='\0') {
        places_after ++;
        result = result * 10 + *(n++) - '0' ;
        }
while (places_after -- != 0)
        result = result /10.0;
return result ;

}

err (s)
char * s;
{
printf ("\nError at line %d: ", yylineno);
printf ("An example of correct usage is\n 	%s\n\n",s);
exit(0);
}

errline()
{
printf ("\nError at line %d: ", yylineno);
}


%}

%token NETWORK  STRING  VERSION  PASSTIME  NEST_PARAMS
%token NUMBER TRUE_OR_FALSE MAXNODES  MONITOR  NAME HEADER
%token FUNCTION  NODE  START  HALT  REPEAT DEST
%token FROM  TO  BANDWIDTH  PLOT BROADCAST POINT2POINT
%token LATENCY  CHANNEL_STACK	NODE_FUNCTIONS 
%token MONITOR_FUNCTIONS CHANNEL_FUNCTIONS NODES EDGES 
%token INTER_PKT_DELAY ACK_SIZE BUFFER_SIZE RANDOM_SEED
%token TELNET_PKT_SIZE FTP_PKT_SIZE FTP_WINDOW TELNET_WINDOW
%token DECONGESTION_MECHANISM SCH_POLICY ROUTER_NODE REAL_NUMBER
%token F_NUMBER REAL_PARAMS DEFAULT DIAMETER
%token NUM_PKTS ON_TIME OFF_TIME AVERAGE PEAK INTERVAL JITTER HRR_LEVELS
%token PRINT_INTERVAL END_SIMULATION SCALE_FACTOR START_TIME INPUT_FILE
%token UTIL_TIME CLASS LOSS_PROB CORRUPTION_PROB LOSS_BURST_SIZE
%token LOCATION

%start network 
%% network 	:	{ /* defaults go here  */
				 Sim_Graph = new(graph);
				 Sim_Graph->flags = Nest_Flags;
				 Sim_Graph->protocol = Nest_Graph;
				 Sim_Graph -> header = new(grhead);
				 Sim_Graph->header->wakeups.tv_sec= 0;
				 Sim_Graph->header->wakeups.tv_usec= 0;
				 Sim_Graph->header->delay= 0;
				 Sim_Graph->header->logging = false;
				 Sim_Graph->header->broadcast= false;
				 Sim_Graph->header->point2point= true;
				 Sim_Graph->header->timenow.tv_sec= 0;
				 Sim_Graph->header->timenow.tv_usec= 0;
				 Sim_Graph->header->passes= 0 ;
				 Sim_Graph->header->passtime.tv_sec= 1;
 				 Sim_Graph->header->passtime.tv_usec= 0;
				 Sim_Graph->header->nodes = MAX_NODES;
				 Sim_Graph->header->monitor = custom_monitor;
				 inter_pkt = 5.0;
				 ack_size = 40;
				 random_seed = 0;
				 op_qsize = 12000;
				 ftp_size = 500;
				 telnet_size = 40;
 				 ftp_window = 5;
				 telnet_window = 5;
				 decongest_mechanism = 1;
				 cc_router = 1;
				 realnum = 0;
				 print_interval = 100;
				 end_simulation = 1000;
				 scale_factor = 1.0;
				 d_node.policy = 1;
				}
		        header
		        nest_params 
			real_params 
			node_functions 
			chan_mon_filler 
			nodes 
			edges 
		;

header 		:	/* null */
		|	HEADER	'{' name ';' version ';' '}'

		;

name 		:	NETWORK ':' STRING 
	        |	NETWORK '=' STRING 
		|	NETWORK error ';'
				{ err("network : Example_network ; "); }
		;

version 	: 	VERSION ':' F_NUMBER
		| 	VERSION ':' NUMBER
		| 	VERSION '=' F_NUMBER
		| 	VERSION '=' NUMBER
		|	error ';'
				{ err("version : 2.0 "); }
		;

nest_params 	: 	NEST_PARAMS '{'paramlist '}'
		|
		;

real_params 	: 	REAL_PARAMS '{'paramlist '}'
		|
		;

paramlist	: 	paramlist param
		|	param 
		;

param		: 	passtime ';' 
		|	maxnodes ';' 
		|	monitor ';' 
		| 	inter_pkt_delay ';'
		| 	ack_size ';'
		|	random_seed ';'
		|	buffer_size ';'
		|	telnet_pkt_size ';'
		|	ftp_pkt_size ';'
		|	ftp_window ';'
		| 	telnet_window ';'
		|	decongestion_mechanism ';'
		|	router_node ';'
		|	real_number ';'
		| 	print_interval ';'
		|	end_simulation ';'
		|	scale_factor ';'
		|	d_sch_policy ';'
		|	util_time ';'
		|	diameter ';'
		|	error ';'
			{
			errline();
			printf("Declared parameter is not a REAL or NEST parameter\n");
			exit(0);
			}
		;

passtime 	: 	PASSTIME '=' NUMBER ',' NUMBER 
			{
			Sim_Graph->header->passtime.tv_sec= $3;
 			Sim_Graph->header->passtime.tv_usec= $5;
			}
		|	PASSTIME error ';'
				{ err ("passtime = 1,0"); }
		;

maxnodes 	: 	MAXNODES '=' NUMBER 
			{ Sim_Graph->header->nodes= $3; 
		 	  if(Sim_Graph->header->nodes >  MAX_NODES)
				pr_error("MAX_NODES in config.h less than in input declaration");
			}
		|	MAXNODES error ';'
				{ err("maxnodes = 20") ; }
		;

monitor 	: 	MONITOR '=' STRING 
			{ Sim_Graph->header->monitor = put_address($3);}
		|	MONITOR error ';'
			{ err("monitor = custom_monitor "); }
		;
inter_pkt_delay :	INTER_PKT_DELAY '=' F_NUMBER
			{ inter_pkt = extract_float($3); }
 		|	INTER_PKT_DELAY '=' NUMBER
			{ inter_pkt = $3; }
		|	INTER_PKT_DELAY error ';'
			{err("inter_pkt_delay = 5.0 ");}
		;
ack_size	:	ACK_SIZE '=' NUMBER 
			{ ack_size = $3;}
		|	ACK_SIZE error ';'
			{err("ack_size = 5");}
		;
random_seed	:	RANDOM_SEED '=' NUMBER
			{ random_seed = $3;} 
		|	RANDOM_SEED error ';'
			{err("random_seed = 0");}
		;
buffer_size	:	BUFFER_SIZE '=' NUMBER
			{op_qsize =  $3;}  
		|	BUFFER_SIZE error ';'
			{err("buffer_size = 15") ;}
		;
telnet_pkt_size	:	TELNET_PKT_SIZE '=' NUMBER
                        {telnet_size =$3; }  
		|	TELNET_PKT_SIZE error ';'
			{err("telnet_pkt_size = 40 ");}
		;
ftp_pkt_size	:	FTP_PKT_SIZE '=' NUMBER 
                        {ftp_size =$3;}  
		|	FTP_PKT_SIZE error ';'
			{err("ftp_pkt_size = 5") ;}
		;
ftp_window	:	FTP_WINDOW '=' NUMBER 
			{ftp_window = $3;
			if(ftp_window>MAX_WINDOW_SIZE)
				pr_error("ftp window larger than max in config.h"); }   
		|	FTP_WINDOW error ';'
			{err("ftp_window = 5") ;}
                ;
telnet_window	:	TELNET_WINDOW '=' NUMBER 
                        {telnet_window = $3;  
			if(telnet_window>MAX_WINDOW_SIZE) 
				pr_error("telnet window larger than max in config.h"); }
		|	TELNET_WINDOW error ';'
			{err("telnet_window = 5") ;}
		;
decongestion_mechanism	:	DECONGESTION_MECHANISM '=' NUMBER
                                {decongest_mechanism =  $3; }
		|		DECONGESTION_MECHANISM error ';'
				{err("decongestion_mechanism = 0");}
   
		;
router_node	:	ROUTER_NODE '=' NUMBER 
                        {cc_router = $3; }  
		|	ROUTER_NODE error ';'
			{err("router_node = 0 ");}
		;
real_number	:	REAL_NUMBER	'=' NUMBER 
                        {realnum = $3; }      
		|	REAL_NUMBER error ';'
			{err("real_number = 0") ;}
		;

print_interval	:	PRINT_INTERVAL  '=' NUMBER                    
                       	{print_interval = $3; }      
		|	PRINT_INTERVAL  error ';'
			{err(" print_interval = 3") ;}
		;
end_simulation	:	END_SIMULATION  '=' F_NUMBER                    
                       	{end_simulation  = extract_float ($3); }      
		|	END_SIMULATION  '=' NUMBER
			{end_simulation = $3; }
		|	END_SIMULATION   error ';'
			{err(" end_simulation = 500");}
		;

scale_factor	:	SCALE_FACTOR '=' F_NUMBER
			{scale_factor = extract_float($3);}
		|	SCALE_FACTOR '=' NUMBER
			{scale_factor = $3;}
		|	SCALE_FACTOR error ';'
			{err(" scale_factor = 1000");}
		;

util_time	:	UTIL_TIME '=' F_NUMBER
			{util_time = extract_float($3);}
		|	UTIL_TIME '=' NUMBER
			{util_time = $3;}
		|	UTIL_TIME error ';'
			{err(" util_time = 1000");}
		;

diameter	:	DIAMETER '=' F_NUMBER                    
			{diameter = extract_float($3);}
		|	DIAMETER '=' NUMBER
			{diameter = $3;}
		|	DIAMETER error ';'
			{err(" diameter = 1000.0");}
		;

chan_mon_filler : 	{
			  nextfn = new(extfunc); 
			  nextfn->addr = tx_chan;
			  Sim_Graph->header->chanfns = nextfn;
			  nextfn->next = nil;
			  nextfn = new(extfunc); 
			  nextfn->addr = (char*)custom_monitor;
			  prevfn = Sim_Graph->header->monfns = nextfn;
		  	  prevfn->next = nil;
			  Sim_Graph->nodes = (grnode*) nil;
		  	}
	
node_functions 	: 	NODE_FUNCTIONS '{' firstnodefunc functionlist '}' 
		|	NODE_FUNCTIONS error ';'
			{err("node_functions { FUNCTION LIST }");}
		|
/* hack - if this is not defined, put in a single node function, for something
that will hopefully always be there i.e. main */

			{nextfn = new(extfunc);
			 nextfn->addr = put_address("main");
			 nextfn->next = nil;
		         Sim_Graph->header->nodefns = nextfn;}
		;

functionlist 	: 	functionlist  function  
	     	| 	/* null */
	     	;


function 	: 	fn ';' 
		|	error ';'
			{errline();
			printf ("function improperly declared \n");
			exit(0);}
		;

firstnodefunc	:	 firstnfn ';' 
		/* hack - put in a single node function, for something
		   that will hopefully always be there i.e. main */
                        {nextfn = new(extfunc);
                         nextfn->addr = put_address("main");
                         nextfn->next = nil;
                         Sim_Graph->header->nodefns = nextfn;}
		;

firstnfn	:	STRING
		|	error ';'
			{err("function = ftp_source") ;}
		;

fn 		: 	STRING 
		|	error ';'
			{err("function = ftp_source ");}
		;

nodes 		: 	NODES '{' defaultnode nodelist '}' 
			{Sim_Graph -> edges = (gredge*) nil ;}
		|	NODES error ';'
			{err("nodes { {DEFAULT} NODE LIST } ");}
		;

defaultnode	:	DEFAULT '{' defaultdatalist '}'
		|	DEFAULT error ';'
			{errline();
			 printf("Error in default node definition\n");
			exit(0);}
		;

defaultdatalist :	defaultdatalist defaultdata 
		| 	defaultdata 

defaultdata	:	d_nodefn ';' 
		|	d_sink ';' 
		|	d_start_time ';' 
		|	d_plot ';' 
		|	d_num_pkts ';' 
		|	d_on_time ';' 
		|	d_off_time ';' 
		|	d_peak ';' 
		|	d_average ';' 
		|	d_interval ';' 
		|	d_jitter ';'
		|       d_hrr_levels';'
		|	d_sch_policy ';'
		;


d_nodefn	:	FUNCTION '=' STRING
			{ d_node.nodefn = put_address($3);}
		|	FUNCTION error ';'
			{err("function = ftp_source ");}
		;

d_sink		: 	DEST '=' NUMBER
                        { d_node.sink = $3;}
		|	DEST error ';'
			{err("sink = 4") ;}
		;
d_start_time 	:	START_TIME '=' NUMBER ',' NUMBER
			{d_node.start_time_sec = $3;
			d_node.start_time_usec = $5;}
		|
			START_TIME error ';'
			{ err("start_time = 1,10000 "); }
		;


d_plot		:	PLOT '=' TRUE_OR_FALSE
                        { d_node.plot = $3 ;}
		|	PLOT error ';'
			{err("plot = true ");}
		;

d_num_pkts	:	NUM_PKTS '=' NUMBER 
			{ d_node.num_pkts = $3;}
		|	NUM_PKTS error ';'
			{err ("num_pkts = 2000") ;}
		;	

d_on_time	:	ON_TIME '=' NUMBER 
			{ d_node.on_time = 1.0e-6 * ((float)$3);}
		|	ON_TIME '=' F_NUMBER
			{ d_node.on_time = 1.0e-6 * extract_float($3);}
		|	ON_TIME error ';'
			{err ("on_time = 2000.0 ");}
		;	

d_off_time	:	OFF_TIME '=' NUMBER 
			{ d_node.off_time = 1.0e-6 * ((float)$3);}
		|	OFF_TIME '=' F_NUMBER
			{ d_node.off_time = 1.0e-6 * extract_float($3);}
		|	OFF_TIME error ';'
			{err ("off_time = 2000.0 ");}
		;	

d_peak		:	PEAK '=' F_NUMBER 
			{ d_node.peak = extract_float($3);}
     		|	PEAK '=' NUMBER 
			{ d_node.peak = $3;}
		|	PEAK error ';'
			{err ("peak = 2000.0 ");}
		;	

d_average	:	AVERAGE '=' F_NUMBER 
			{ d_node.average = extract_float($3);}
     		|	AVERAGE '=' NUMBER 
			{ d_node.average = $3;}
		|	AVERAGE error ';'
			{err ("average = 2000.0") ;}
		;	

d_interval	:	INTERVAL '=' NUMBER 
			{ d_node.interval = $3;}
		|	INTERVAL error ';'
			{err ("interval = 2000");}
		;	

d_jitter 	:	JITTER  '=' NUMBER 
			{ d_node.jitter  = $3;}
		|	JITTER  error ';'
			{err ("jitter  = 2000") ;}
		;	

d_hrr_levels	:	HRR_LEVELS '=' '{' d_hrr_list '}'
		;

d_hrr_list	:	d_hrr_list  d_hrr_pair 
		|	d_hrr_pair 
		;	

d_hrr_pair	:	NUMBER ':' NUMBER ';'
			{ d_nb_table[hrr_i] =  $1;
			  d_b_table[hrr_i] =  $3;
			  d_hrr_i++ ;
			}
		|	error ';'
			{ err("5:3 "); }
d_sch_policy	:	SCH_POLICY '=' NUMBER                    
                       	{d_node.policy = $3; }
		|	SCH_POLICY error ';'
			{err("sch_policy = 3") ;}
		;

nodelist 	: 	nodelist node 
		| 	node 
        	;

node 		: 	NODE NUMBER 
			{ 
		 	newnode = new(grnode);
			node_table[$2] = newnode;
		        nodeid = $2;
			newnode -> nodedata = new(grnodedat);
			newnode -> nodedata -> nodeid = $2;
			newnode -> nodedata -> function = d_node.nodefn;
                        newnode->nodedata->start= true;
                        newnode->nodedata->repeat= false;
                        newnode->nodedata->halt= false;
			node_start_time[$2].tv_sec =d_node.start_time_sec;
			node_start_time[$2].tv_usec = d_node.start_time_usec;

			newnode->nodedata->sink = d_node.sink;
			
 			if (d_node.plot)
                        	newnode->nodedata->plot= true;
                        else
                         	newnode->nodedata->plot= false;

			num_pkts [$2] = 	d_node.num_pkts;
			on_time [$2]  = 	d_node.on_time;
			off_time [$2] = 	d_node.off_time;
			peak_bandwidth [$2] = 	d_node.peak;
			ave_bandwidth [$2] = 	d_node.average;
			interval [$2] = 	d_node.interval;
			jitter [$2] =		d_node.jitter;
			policy [$2] = 		d_node.policy;
		 	for(i=1; i <= NUM_LEVELS; i++)
				{
				 nb_table[$2][i] = d_nb_table[i];
				 b_table[$2][i] = d_b_table[i];
				}
		   	hrr_i =  1;
			}
		        
			'{' nodedata '}'
			{insn(newnode, &Sim_Graph -> nodes);}
		;

nodedata 	: 	/* nil */	
		| 	nodedatum ';' nodedata
		;

nodedatum	: 	nodefn 
		|	sink 
		| 	start_time
		|	plot 
		|	num_pkts
		| 	on_time
		| 	off_time
		| 	peak
		|	average
		|	interval 
		| 	jitter
	 	| 	hrr_levels
		|	sch_policy;
	 	|	input_file;
	 	|	class;
	 	|	location;
		;

nodefn 		: 	FUNCTION '=' STRING 
			{newnode ->nodedata->function = put_address($3);}
		|	FUNCTION error ';'
			{err("function = ftp_source");}
		;

sink 		: 	DEST '=' NUMBER 
			{ newnode->nodedata->sink = $3;}
		|	DEST error ';'
			{err("sink = 4") ;}
		;
start_time 	:	START_TIME '=' NUMBER ',' NUMBER
			{node_start_time[nodeid].tv_sec = $3;
			 node_start_time[nodeid].tv_usec = $5;}
		|
			START_TIME error ';'
			{ err("start_time = 1,10000") ; }
		;


plot		:	PLOT '=' TRUE_OR_FALSE
			{if ($3)
				newnode->nodedata->plot= true;
			else
				newnode->nodedata->plot= false;}
		|	PLOT error ';'
			{err("plot = true ");}
		;

num_pkts	:	NUM_PKTS '=' NUMBER 
			{num_pkts[nodeid] = $3;}
		|	NUM_PKTS error ';'
			{err ("num_pkts = 2000") ;}
		;	

on_time		:	ON_TIME '=' NUMBER 
			{on_time[nodeid] = 1.0e-6 * ((float) $3);}
		|	ON_TIME '=' F_NUMBER 
			{on_time[nodeid] = 1.0e-6 * extract_float($3);}
		|	ON_TIME error ';'
			{err ("on_time = 2000.0 ");}    
		;	
off_time	:	OFF_TIME '=' NUMBER 
			{ off_time[nodeid] = 1.0e-6 * ((float) $3);}
		|	OFF_TIME '=' F_NUMBER 
			{ off_time[nodeid] = 1.0e-6 * extract_float($3);}
		|	OFF_TIME error ';'
			{err ("off_time = 2000.0 ");}
		;	


peak		:	PEAK '=' F_NUMBER 
			{peak_bandwidth[nodeid] =  extract_float($3);}
     		|	PEAK '=' NUMBER 
			{peak_bandwidth[nodeid] =  $3;}
		|	PEAK error ';'
			{err ("peak = 2000.0") ;}
		;	

average		:	AVERAGE '=' F_NUMBER 
			{ave_bandwidth[nodeid] = extract_float($3);}
     		|	AVERAGE '=' NUMBER 
			{ave_bandwidth[nodeid] = $3;}
		|	AVERAGE error ';'
			{err ("average = 2000.0 ");}
		;	

interval	:	INTERVAL '=' NUMBER 
			{ interval[nodeid] = $3;}
		|	INTERVAL error ';'
			{err ("interval = 2000 ");}
		;	

jitter 		:	JITTER  '=' NUMBER 
			{ jitter [nodeid] =  $3;}
		|	JITTER  error ';'
			{err ("jitter = 2000") ;}
		;	

hrr_levels	:	HRR_LEVELS '=' '{' hrr_list '}'
		;

hrr_list	:	hrr_list  hrr_pair 
		|	hrr_pair 
		;	

hrr_pair	:	NUMBER ':' NUMBER ';'
			{ nb_table[nodeid][hrr_i] =  $1;
			  b_table[nodeid][hrr_i] =  $3;
			  hrr_i++ ;
			}
		|	error ';'
			{ err("5:3 "); }

sch_policy	:	SCH_POLICY '=' NUMBER                    
                       	{policy[nodeid] = $3; }      
		|	SCH_POLICY error ';'
			{err("sch_policy = 3");}
		;

input_file	:	INPUT_FILE '='  STRING 
			{strcat (input_file[nodeid], $3);}
		|	INPUT_FILE error ';'
				{ err("input_file = /usr/keshav/sim/sim/inp1; "); }
		;

class		:	CLASS '=' NUMBER                    
                       	{class[nodeid] = $3; }      
		|	CLASS error ';'
			{err("class = 3");}
		;
location 	:	LOCATION '=' NUMBER ',' NUMBER
		|
			location error ';'
			{ err("location = 1, 5") ; }
		;


		;
edges 		: 	EDGES '{' defaultedge edgelist '}'
		;

defaultedge	:	DEFAULT 
			{
			d_edge.bandwidth = 0.0 ;
			d_edge.latency  = 0 ;
			d_edge.loss_prob = 0.0 ;
			d_edge.corruption_prob = 0.0 ;
			d_edge.loss_burst_size = 0.0 ;
			strcpy (d_edge.chan, "tx_chan");
			} 
		 	'{' default_edge_data '}'

		|	DEFAULT error ';'
			{ errline();
			  printf("Error in default edge definition\n");
			  exit(0);
  			}
		;

default_edge_data : 	default_edge_datum default_edge_data
		|	/* nothing */
		;
default_edge_datum : 	d_bandwidth  ';'
		|	d_latency ';'
		|	d_loss_prob ';'
		|	d_corruption_prob  ';'
		| 	d_loss_burst_size ';'
		|	error ';'
			{errline();
			 printf ("Error in default edge definition\n");
			 exit(0);}
		;

d_bandwidth 	:	BANDWIDTH '=' NUMBER
			{ d_edge.bandwidth = (float) $3;}
		|	BANDWIDTH '=' F_NUMBER
			{ d_edge.bandwidth = extract_float($3);} 
		|	BANDWIDTH error ';'
			{err("bandwidth = 40.0") ;}
		;

d_latency	:	LATENCY '=' NUMBER
			{d_edge.latency = $3;}
		|	LATENCY error ';'
			{err("latency = 10") ;}
		;

d_loss_prob	:	LOSS_PROB '=' NUMBER
			{ d_edge.loss_prob = (float) $3;}
		|	LOSS_PROB '=' F_NUMBER
			{ d_edge.loss_prob = extract_float($3);} 
		|	LOSS_PROB error ';'
			{err("loss_prob = 0.5") ;}
		;

d_corruption_prob	:	CORRUPTION_PROB '=' NUMBER
			{ d_edge.corruption_prob = (float) $3;}
		|	CORRUPTION_PROB '=' F_NUMBER
			{ d_edge.corruption_prob = extract_float($3);} 
		|	CORRUPTION_PROB error ';'
			{err("corruption_prob = 0.5") ;}
		;

d_loss_burst_size 	:	LOSS_BURST_SIZE '=' NUMBER
			{ d_edge.loss_burst_size = (float) $3;}
		|	LOSS_BURST_SIZE '=' F_NUMBER
			{ d_edge.loss_burst_size = extract_float($3);} 
		|	LOSS_BURST_SIZE error ';'
			{err("loss_burst_size = 40.0") ;}
		;

edgelist 	: 	edgelist '{' edge '}'
		| 	'{' edge '}'
		;

edge 		: 	{
			newedge = new(gredge);
			newedge->edgedata = new(gredgedat);
			newedge->edgedata->line_speed = d_edge.bandwidth;
			newedge->edgedata->loss_prob = d_edge.loss_prob;
			newedge->edgedata->corruption_prob = d_edge.corruption_prob;
			newedge->edgedata->loss_burst_size = d_edge.loss_burst_size;
                        newedge->edgedata->weight =d_edge.latency;
			nextchan = new(struct cfunc);
			nextchan->addr = put_address(d_edge.chan);
			newedge ->edgedata->delete = false;
			newedge ->edgedata->unused = 0;
			newedge ->edgedata->chanstack = nextchan ;
			newedge ->edgedata->chanstack->next = nil;}

			edgedata 

			{insn(newedge, &Sim_Graph ->edges);}
		;
edgedata	:	/* null */
		|	edgedatum  edgedata 
		;

edgedatum	: 	from  ';'
		|	bandwidth ';' 
		|	latency  ';'
		|	loss_prob ';'
		|	corruption_prob ';'
		| 	loss_burst_size ';'
		;

from 		: 	NUMBER TO NUMBER 
			{newedge -> node1 = node_table[$1];
			 newedge -> node2 = node_table[$3]; }
		|	error ';'
			{err(" 1 -> 2; ");}
		;

bandwidth 	: 	BANDWIDTH '=' NUMBER 
			{newedge->edgedata->line_speed=(float)$3 ;}
		|	BANDWIDTH '=' F_NUMBER 
			{newedge->edgedata->line_speed=extract_float($3);}
		|	BANDWIDTH error ';'
			{err("bandwidth = 40.0 ");}
		;

latency		: 	LATENCY '=' NUMBER 
			{newedge->edgedata->weight =$3;
		  	newedge->edgedata->delete=false;}
		|	LATENCY error ';'
			{err("latency = 10 ");}
		;

loss_prob	:	LOSS_PROB '=' NUMBER
			{ newedge->edgedata->loss_prob = (float) $3;}
		|	LOSS_PROB '=' F_NUMBER
			{ newedge->edgedata->loss_prob = extract_float($3);} 
		|	LOSS_PROB error ';'
			{err("loss_prob = 0.5") ;}
		;

corruption_prob	:	CORRUPTION_PROB '=' NUMBER
			{ newedge->edgedata->corruption_prob = (float) $3;}
		|	CORRUPTION_PROB '=' F_NUMBER
			{ newedge->edgedata->corruption_prob = extract_float($3);} 
		|	CORRUPTION_PROB error ';'
			{err("corruption_prob = 0.5") ;}
		;

loss_burst_size 	:	LOSS_BURST_SIZE '=' NUMBER
			{ newedge->edgedata->loss_burst_size = (float) $3;}
		|	LOSS_BURST_SIZE '=' F_NUMBER
			{ newedge->edgedata->loss_burst_size = extract_float($3);} 
		|	LOSS_BURST_SIZE error ';'
			{err("loss_burst_size = 40.0") ;}
		;

%% /* programs */

char           *
get_node_name()
{
	static int      count = 1;
	char           *name, c;
	int             i;

	name = (char *) malloc((unsigned) 9);
	/* 9 bytes should be enough to get a node number */
	sprintf(name, "%s%d\0", "node", count++);
	return name;
}

 yyerror()
{ printf("Syntax error in parsing input file!\n");
}


#include "../lang/lex.yy.c"
