typedef struct pkt_type PKT, *PKT_PTR;
	
struct pkt_type /* this holds a bunch of per-packet information
		 * that really ought to be moved somewhere else */
{
    char            type;	/* packet type */
    int             source;	/* node id of source */
    int             dest;	/* node id of destination */
    timev           gen_time;	/* generation time */
    int             seq_no;	/* sequence number */
    int             last_recvd_offset;	/* ack was generated by this seq. no */
    int             size;	/* packet size in bytes */
    timev           arr_time;	/* time when it reached the scheduler */
    char            decbit;	/* DEC bit */
    char            gs;		/* set for a guaranteed srvc pkt */
    int    	    id;		/* used by timers */
    char 	    resent;	/* number of time it has been retransmitted */
    double	    bid;	/* FQ bid number */
    PKT_PTR         next;	/* next packet in gateway buffer */
    PKT_PTR         prev;	/* previous packet in gateway buffer */
    char	    trace; 	/* gateway should trace this conversation */
    float           peak_bandwidth;	/* peak b/w allocation request */
    float           ave_bandwidth;	/* average allocation request */
    float           interval;	/* estimation interval */
    long            jitter;  	/* max service delay at each node */
    float	    proto_flag; /* protocol specific flag information */
    int		    low_mb, high_mb; /* used by coder */
    int 	    frameno;	/* frame number, used by coder */
    char	    class;      /* xunet service class */
    char	    priority;   /* node queue priority */
    char	    data[DATA_SIZE]; /* the data in the packet */
};

/* definition of table structure used in report generation */
typedef struct table_type TABLE;

struct table_type
{
    float           mean;
    float 	    min_entry;
    float 	    max_entry;
    int             num_entries;
    float	    sum_mean;
    float	    sum_mean_sq;
    int 	    sum_count;
    int 	    sum_count_sq;
};

/* conversation structure used in converstion management */
typedef struct conv_type CONV, *CONV_PTR;
struct conv_type
{
    int             conv_id;
    CONV_PTR        next;
};

typedef struct recv_type RECV, *RECV_PTR;
struct recv_type
{
    int		   conv_id;
    int		   last_in_seq;
    char	   seen [MAX_WINDOW_SIZE];
    RECV_PTR	   next;
};

/* make_pkt is generic way to make a packet. It DOES NOT SET gen_time,
   which should be set after dequeueing the packet from the node 
   transmission queue, or seq_no, which may be changed for retxed pkts. 
   or id, which should be set immediately before transmission.
*/

#define make_pkt(pkt)\
    pkt = (PKT_PTR) malloc ((unsigned) sizeof (PKT)); \
    if(pkt is NULL)\
	pr_error("malloc failed in make_pkt"); \
    pkt -> type = DATA; \
    pkt -> source = node; \
    pkt -> dest = assigned_sink[node]; \
    pkt -> size = ftp_size; \
    pkt -> decbit = 0; \
    pkt -> gs = 0; \
    pkt -> resent = 0; \
    if (plot_option[node]) \
	pkt -> trace = 1; \
    else \
	pkt -> trace = 0; \

#define initiate_setup\
   { PKT_PTR pkt; \
    make_pkt(pkt);\
    pkt->seq_no = seq_no++;\
    pkt->gen_time = runtime();\
    pkt->type = SETUP;\
    pkt->ave_bandwidth = ave_bandwidth[node];\
    pkt->peak_bandwidth = peak_bandwidth[node];\
    pkt->interval = interval[node];\
    pkt->jitter = jitter[node];\
    pkt->class = class[node];\
    send_pkt(pkt);}\

