#include "real.h"
#define extern
#include "../../src/message.h"
#undef extern
#include "../../src/network.h"
#include "../../src/simulate.h"
#include "../../src/process.h"

/*
 * set a timer for delay seconds. At this time, the pkt is sent to the
 * sending node 
 */

set_timer (delay, pkt)
    float	  delay;
    PKT_PTR         pkt;
{
    timev           now, tv_delay;

    if(delay < 0){
	pr_error("set_timer given negative value for delay !\n");
    }
	
    now = runtime ();
    if (pkt is NULL)
	pr_error ("set timer got a null pkt");

    /*
    printf("node %d, now %d,%d setting timer for %f seconds\n",
	_current_node, now.tv_sec, now.tv_usec,delay); 
    */

    reliable (_current_node, _current_node, _current_node, 0, pkt, (long)(1.0e6*delay));
}

