/* modified 8/10/94 to add nxmit table */

extern int             TAB_DEBUG ;

#include "real.h"
#include <math.h>

#define NSKIP 1
	 /* how many time periods to skip in evaluating variance */
#define Q_DELAY_THRESH 0.001
 	/* if queueing delay is less than this, it will not be printed */

#define P(x) fprintf(result_file, x);
#define P2(x,y) fprintf(result_file, x,y);
#define P3(x,y,z) fprintf(result_file, x,y,z);

/*
 * Tables are data structures that store running sum, running squared sum
 * min and max of a variable. The number of calls to the entry routine 
 * is also stored. This allows the system to compute counts, means,
 * variances and min/max. Tables are cleared every print interval.
 * Variances are not computed for means computed during the first NSKIP
 * print intervals 
 */

extern TABLE so_tossed[MN]; 		/* packet losses for each source */
extern TABLE retxs[MN]; 	  	/* number of retransmissions */
extern TABLE rt_time[MN];   		/* real RTTs */
extern TABLE qing_delay[MN][MN];	/* queueing delay in router */
extern TABLE nxmit[MN][MN];		/* # of packets forwarded that were not retxs. */
extern int      num_buffers_in_q[MN][MAX_CONVERSATIONS];
extern char    *strcpy ();
extern char* router_type();

FILE           *result_file;		  
int             _table_count = 0; 	/* # of times print_report called */


/* 
 * Initialize 
 */

init_table (table)
    TABLE          *table;
{
    table->mean = table->max_entry = table->sum_mean = table->sum_mean_sq = 0.0;
    table->min_entry = 9999999999.0;
    table->num_entries = table->sum_count = table->sum_count_sq = 0;
}


/*
 * make an entry in a table
 */

make_entry (entry, table)
    float           entry;
    TABLE          *table;
{
    table->num_entries++;
    table->mean += entry;
    if (entry < table->min_entry)
	table->min_entry = entry;
    if (entry > table->max_entry)
	table->max_entry = entry;
    if (TAB_DEBUG)
	printf ("make_entry : entry was %f, mean %f, num %d\n",
		entry, table->mean, table->num_entries);
}

/*
 * result file handling
 */

open_result_file ()
{
    result_file = fopen (DUMP_FILE, "a");
      if (result_file == 0)
    pr_error ("Unable to open results file"); 
}

close_result_file ()
{
    fclose (result_file);
}

/*
 * the main report printing function - messy but unavodable 
 */

print_report (graf)
    graph          *graf;
{

    int             i, j, k, node;
    int		    gw_count = 0;
    int		    node_count = 0;

    if (graf->header->timenow.tv_sec is 0)
	return;
	
    if (!_table_count)
			/* if called the first time, print the header */
    {
	P("\n");
P("-------------------------------------------------------------------------------");
	P("\n");
P("Time   #  Type           G/w   NXmit  Xmit Q'ing(min,ave,max)[#]  Drops Retx  RTT(min,ave,max)");
	P("\n");
P("...............................................................................");

    }
    P2("\n%-6d ", graf->header->timenow.tv_sec);
    for (node = 0; node < MAX_NODES + 1; node++)
    {
	if (source_node_type[node] != -1 and
	    source_node_type[node] != ROUTER and
	    source_node_type[node] != CC_ROUTER and
	    source_node_type[node] != CODER_SOURCE  and
	    source_node_type[node] != SINK)
	{
	    if (node_count++ is 0)
	    	P2("%-3d ", node)
	    else
	    	P2("       %-3d ", node)

	/* on an SGI machine, 12.12s will give a string exactly 12 chars long */
	/*  your mileage may vary */

	    switch (source_node_type[node])
	    {
	    case ROUTER :
		    P2("%-12.12s ", "Router")
		    break;
	    case CC_ROUTER :
		    P2("%-12.12s ", "CC_Router")
		    break;
	    case SINK :
		    P2("%-12.12s ", "Sink");
		    break;
	    case BACKGROUND_SOURCE :
		    P2("%-12.12s ", "Bgrnd");
		    break;
	    case CONTROLLED_RATE_SOURCE :
		    P2("%-12.12s ", "On_off");
		    break;
	    case DEC_SOURCE :
		    P2("%-12.12s ", "Dec");
		    break;
	    case GENERIC_SOURCE :
		    P2("%-12.12s ", "Generic");
		    break;
	    case JK_RENO_SOURCE :
		    P2("%-12.12s ", "JK_Reno");
		    break;
	    case JK_TAHOE_SOURCE :
		    P2("%-12.12s ", "JK_Tahoe");
		    break;
	    case MALICIOUS_SOURCE :
		    P2("%-12.12s ", "Malic");
		    break;
	    case MMPP_SOURCE :
		    P2("%-12.12s ", "MMPP");
		    break;
	    case POISSON_SOURCE :
		    P2("%-12.12s ", "Poisson");
		    break;
	    case PP_SOURCE :
		    P2("%-12.12s ", "PP");
		    break;
	    case PP_TX :
		    P2("%-12.12s ", "PP_tx");
		    break;
	    case RANDOM_RATE_SOURCE :
		    P2("%-12.12s ", "On_off_rand");
		    break;
	    case TELNET_SOURCE :
		    P2("%-12.12s ", "Telnet");
		    break;
	    }

	    /* for each router, print out the queueing delay, if it is
	     * non-zero */

	    for (k = 0, gw_count = 0; k < MAX_NODES + 1; k++){
		if (source_node_type[k] is ROUTER){
			if ((gw_count is 0) or (qing_delay[k][node].mean > Q_DELAY_THRESH)){
			    if (gw_count++ > 0){
			        P("\n                        ");
			    }
			    P3("%3d(%-2.2s) ", k, router_type(k));
			    P2("%-5d ", nxmit[k][node].num_entries);
			    report(&(qing_delay[k][node]), 1);
			    P2("[%-d]  ", num_buffers_in_q[k][hash (k,node,assigned_sink[node])]);
			} 

		        if(_table_count > NSKIP -1) {
		            nxmit[k][node].sum_count +=  nxmit[k][node].num_entries;
			    nxmit[k][node].sum_count_sq += nxmit[k][node].num_entries *
								nxmit[k][node].num_entries;
		   	}
		        nxmit[k][node].num_entries = 0.0;
		    }
	    }

	    P3("%-5d %-5d ", (so_tossed[node].num_entries), num_retransmissions[node]);
	    report (&rt_time[node], 2);

	/* update so_tossed and num_retx variance computations */

	if (_table_count > NSKIP - 1)	/* skip first time period to avoid
					 * transients */
	{
	     so_tossed[node].sum_count += so_tossed[node].num_entries;
	     so_tossed[node].sum_count_sq += 
	       so_tossed[node].num_entries * so_tossed[node].num_entries;
	     retxs[node].sum_count += num_retransmissions[node];
	     retxs[node].sum_count_sq +=
	       num_retransmissions[node] * num_retransmissions[node];
	}
	so_tossed[node].num_entries = 0;
	num_retransmissions[node] = 0;
	rt_time[node].mean = 0.0;
	rt_time[node].num_entries = 0;
	P("\n");
	}
    }
    _table_count++;
}

report (table, pflag)
    TABLE          *table;
    int 	   pflag;
			/* flag = 1 => print num_entries as well as delays
			   flag = 2 => print delays only 
			   flag = 3 => update stats, but no printing 
		        */
{
    float           mean;

    if (table->num_entries is 0){
	fprintf (result_file, "No Entries           ");
	return;
    }
    
    switch(pflag) 
    {
	case 1:
		fprintf (result_file, "%-5d ", table->num_entries);
	case 2: 
		fprintf (result_file, "%4.2f ", table->min_entry);
                mean = table->mean / table->num_entries;
		fprintf (result_file, "%4.2f ", mean);
		fprintf (result_file, "%4.2f ", table->max_entry);
    }

    if (_table_count > NSKIP - 1) {	/* skip first time period to avoid
					 * transients */
            mean = table->mean / table->num_entries;
	    table->sum_mean += mean;
	    table->sum_mean_sq += mean * mean;
	    table->sum_count += table->num_entries;
	    table->sum_count_sq += table->num_entries * table->num_entries;

     } else { /* reset min, max values to avoid transients */
	    table->min_entry = 999999999.0;
	    table->max_entry = 0.0;
     }

     /* reset for next period */
     table->mean = 0.0;
     table->num_entries = 0;
}

print_summary (graf)
    graph          *graf;
{

    int             i, j, node;
    int             k, count = 0;

    P("\n\nSummary\n\n");
    P("Node G/w T'put(mean,sd)  Q'ing(mean,sd)  RTT(mean,sd)    Drops(mean,sd) Retxs(mean, sd) \n");
    for (node = 0; node < MAX_NODES + 1; node++)
    {
	if (source_node_type[node] != ROUTER  &&
	    source_node_type[node] != CC_ROUTER &&
	    source_node_type[node] != -1 &&
	    source_node_type[node] != SINK)
	{
	    fprintf (result_file, "\n%-3d  ", node);
	    for (count = 0, k = 0; k < MAX_NODES + 1; k++)
	    {
		if (source_node_type[k] is ROUTER)
		    if (nxmit[k][node].sum_count > 0)
		    {
			if (count++ > 0)
			    fprintf (result_file, "\n  ");
			fprintf (result_file, "%-3d ", k);
			report_var(&(nxmit[k][node]), 1);
			report_var (&(qing_delay[k][node]), 2);
		    }
	    }
	    report_var (&rt_time[node], 2);
	    report_var(&so_tossed[node], 1);
	    report_var(&retxs[node], 1);
	    fprintf (result_file, "\n");
	}
    }
}

report_var (table, code)
    TABLE          *table;
    int             code;
	
/* 
   code = 1: print out count, variance of count (# pkts. )
   code = 2: print out value, variance of value (delay)
   code = 3: print out both 1 and 2 stuff
*/

{
    float           mean, diff, sd;
    int             n;
    /* if sqrt() is handed a number close to 0.0, it screws up !! */
    n = _table_count - NSKIP;	/* to account for skipping */
    if (code is 1 or code is 3)
    {
	mean = ((float) table->sum_count) / (float) n;
	diff = (((float) table->sum_count_sq) / ((float) n) - mean * mean);
	if (diff > 0.0000001)
	    sd = sqrt ((double) diff);
	else
	    sd = 0.0;
	fprintf (result_file, "(%-6.2f %-6.2f) ", mean, sd);
    }
    if (code is 2 or code is 3)
    {
	mean = table->sum_mean / n;
	diff = ((float) table->sum_mean_sq / ((float) n) - mean * mean);
	if (diff > 0.0000001)
	    sd = sqrt ((double) diff);
	else
	    sd = 0.0;
	fprintf (result_file, "(%-6.2f %-6.2f) ", mean, sd);
    }
}



char            r_string[10];

char           *
router_type (k)
    int             k;
{
    switch (policy[k])
    {
    case FCFS:
	return strcpy (r_string, "FC");
    case HRR:
	return strcpy (r_string, "HR");
    case FQ:
	return strcpy (r_string, "FQ");
    case FQBIT:
	return strcpy (r_string, "FB");
    case DECBIT:
	return strcpy (r_string, "DB");
    default:
	return strcpy (r_string, "??");
    }
}

char           *
type_to_str(k)
    int             k;
{
    switch (k)
    {
    case INT:
	return strcpy (r_string, "INT");
    case TIMEOUT:
	return strcpy (r_string, "TIMEOUT");
    case TIMER:
	return strcpy (r_string, "TIMER");
    case RATE:
	return strcpy (r_string, "RATE");
    case HRR_TIMER:
	return strcpy (r_string, "HRR_TIMER");
    case WAKEUP:
	return strcpy (r_string, "WAKEUP");
    case UTIL:
	return strcpy (r_string, "UTIL");

    case DATA:
	return strcpy (r_string, "DATA");
    case ACK:
	return strcpy (r_string, "ACK");
    case SETUP:
	return strcpy (r_string, "SETUP");
    case SETUP_ACK:
	return strcpy (r_string, "SETUPACK");
    case TEARDOWN:
	return strcpy (r_string, "TEARDOWN");
    default:
	return strcpy (r_string, "??");
    }
}
