#include "real.h"
#include "hash.h"
#include <stdio.h>

extern c_compare(); /* use the same one as in plotting.c */
extern c_hashfn();

#define MAX_NAMES 8196
#define MAX_NAME_LENGTH 256

FILE * f;
struct hash_template * h;

char 	       *
put_address (name)
    char           *name;
{
    char **c;
    c = hash_locate (h, name) ;
    if(c is (char **) -1)
	pr_error("Symbol not found in FUNC_TABLE!");
    return *c;
}

scan_in ()
{
  char		 *address;
  char            *s, name [MAX_NAME_LENGTH];
  char		  fname [100];
  char     	**c;
  
   sprintf(fname, "../FUNC_TABLE");
   f = fopen (fname, "r");
   if (!f) 
	printf("kernel/symtab.c: Symbol table scanner unable to find function table in current directory\n");

   h = hash_create (MAX_NAMES, c_compare, c_hashfn);

   while (fscanf (f, "%lx %s", &address, name) != EOF) {
	s = (char *) malloc(100);
	strcpy(s, name);
	c = (char **) malloc ((unsigned)sizeof(char*));
	*c = address;
	hash_insert(h, s, c);
    }
}

/* testing...
main(argc, argv)
char argc;
char ** argv;
{
scan_in();
printf("%x\n", put_address(argv[1]));
}
*/
