#include "real.h"
#include <sys/stat.h>
#include <errno.h>
#include <stdlib.h>

#define FILENAMELEN 80

extern struct graph *custom_monitor ();
extern int      initialise ();
extern int      realnum;
extern double   log ();

/* globals */

#define MN MAX_NODES + 1
#define MF MAX_FAN_OUT 

TABLE    qing_delay[MN][MN];
TABLE    nxmit[MN][MN];
TABLE    so_tossed[MN];
TABLE    rt_time[MN];
TABLE    retxs[MAX_NODES +1];                 /* number of retransmissions */

timev    node_start_time[MN];

float	 on_time[MN];
float	 off_time[MN];
float    peak_bandwidth[MN];
float    ave_bandwidth[MN];
long     interval[MN];
long     jitter[MN];
int      nb_table[MN][NUM_LEVELS];
int      b_table[MN][NUM_LEVELS];
int      policy[MN];

int      source_node_type[MN]; 		/* type of node */
int      busy[MN][MF];			/* set if a line is busy */
ident    assigned_sink[MN]; 		/* where to send packets */
float    line_speeds[MN][MN]; 		/* line speeds of the lines */
float    weight [MN][MN]; 		/* latency of the line */
float    loss_prob[MN][MN]; 		/* pkt burst loss probabilty */
float    corruption_prob [MN][MN]; 	/* bit corruption probability */
float    loss_burst_size [MN][MN]; 	/* mean # pkts lost when pkt is lost */
int      num_retransmissions[MN]; 	/* # pkts retxed by a source */
char     plot_option[MN]; 		/* plot node? */
int    	 num_pkts[MN]; 			/* # pkts sent by a source */
char	 input_file[MN][400];
int	 class [MN];			/* class of a node */

int 	realnum;			/* ID for dist. simln */
int     cc_router;			/* cross computer router */

/* default parameter values are set in the lang.yacc file */

int	ack_size; 			/* size of ack packets */
int     random_seed; 			/* seed for random number */
float   inter_pkt; 			/* not used */
int     op_qsize; 			/* size of an output queue */
int     decongest_mechanism; 		/* last */
int     telnet_size;
int     ftp_size;
int     ftp_window;
int     telnet_window;
int     print_interval;
float	end_simulation;
float   alpha_rtt_ftp;			/* used to compute rtt */
float   alpha_rtt_telnet;		/* used to compute rtt */
float 	scale_factor;		
					/* factor by which to scale 
					 * simulations - e.g if factor 
					 * = 1e3, 1 simln sec = 1ms. 
					 * Sources scale initial values of 
					 * RTT and timeout by this factor */

float	diameter;			/* diameter of LAN segment (secs) */
float	util_time;			

/* ====================================================================*/

extern graph   *initialize_graph ();
extern void    real_parse_args();
  
main (argc, argv)
    int             argc;
    char           *argv[];

{
    int             i;


    (void) nest_parse_args (argc, argv);
    (void) real_parse_args(argc,argv);

    trace_set ();

    if (Nodes is 0)
	Nodes = MAX_NODES;

    if (StackSize is 0)
	StackSize = 1024 * Nodes;

    if (Graph is nil)
	Graph = initialize_graph ();

    initialise ();

    if (random_seed is 0)	/* initialise random number generator */
	random_seed = (int) time (0);
    srandom (random_seed);

    if (simulate (Nodes, (unsigned) StackSize, Graph, PortNumber) is Error)
	exit (1);
}

pr_error (s)
    char           *s;
{
    printf ("\n\n\nWe interrupt this program to bring you this important message: \n Node %d: %s \n\n", get_node_id(), s);
    exit (0);
}

float
expntl (mean)
    float           mean;
{
    float           ret;

    ret = (float) ((float) (-1) * (log (1.0 - (double) RANDOM) *
				   (float) (mean)));
    return ret;

}

int
pkt_print (pkt)
PKT_PTR pkt;
{
  timev		    now;
  int node = get_node_id();

  if(plot_option[node]){
      now = runtime();
      printf("(%f) Node %d recvd %s pkt\n", make_float(now), get_node_id(), 
		pkt_types[pkt->type]);
  }
	
}

#include "../lang/y.tab.c"

graph          *
initialize_graph ()
{
    scan_in ();
    yyparse ();
    return Sim_Graph;
}


void
real_parse_args(argc, argv)
  int argc;
  char *argv[];
{
    extern optind;
    int i, j, infilelen, outpathlen;
    FILE *infilep;
    char in_file[FILENAMELEN];
    char dump_file[FILENAMELEN];
    char dump_dir[FILENAMELEN];
    char dump_path[255];
    char errstring[80];

  /* always put results relative to current directory */

  for(i=0; i < 255; i++)
	dump_path[i] = NULL;

  *dump_path = '.';
  outpathlen = strlen(dump_path);
  dump_path[outpathlen] = '/';
  outpathlen++;

  if (argc > 1) 
      {    
      infilelen = strlen(argv[optind]);
      if (!(argv[optind][infilelen-2] == '.' && argv[optind][infilelen-1] == 'l')) 
        sprintf(in_file, "%s.l", argv[optind]);
   else 
        strcpy(in_file, argv[optind]);

   infilep = fopen((char *) in_file, "r");
   if (!infilep) {
 sprintf(errstring, "Unable to find input file %s. Does it end with a .l?", in_file);    
       pr_error(errstring); 
      }
      fclose(stdin);

     /* set stdin to the input file, so that getc() in lex reads from this 
      * file instead of from stdin */

      *stdin = *infilep;
      
      for (i=0, j = outpathlen; i < infilelen && j < FILENAMELEN - 1; i++, j++) 
	{
        switch(argv[optind][i]) 
	{
        case '/':
          j=outpathlen - 1;
          break;
        case '.':
          if (argv[optind][i+1] == 'l' && argv[optind][i+2] == '\0') {
    	    dump_path[j] = '\0';
            i = infilelen;
            break;
          }
        default:
          dump_path[j] = argv[optind][i];
          break;
       }
      }    
        
    dump_path[j] = '\0';
    i = mkdir(dump_path, S_IRWXU|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH);
    if (i) {
      switch (errno) 
      {
      case EEXIST:      /* no problem. */
        break;
      default:
        sprintf(errstring, "Cannot create output directory %s.", dump_path);
        pr_error(errstring);
        break;
      }
    }
  }
else sprintf(dump_path, "%s\0", "../results");

  if (chdir(dump_path)) 
  {
    sprintf(errstring, "Cannot change working directory to %s. Make sure it's not a plain file.", dump_path);
    pr_error(errstring);
  }
}


