/* routing code for general topologies */
/* based on min-cost routing algorithm in Bertsekas' book */
/* S. Keshav, 7/18/88 */

#include "real.h"

extern int             ROU_DEBUG ;

#define MAX_DIAMETER 10000

int             hop_count[MAX_NODES + 1];

 /* hop_count to reach a node  */

int             adj[MAX_NODES + 1][MAX_NODES + 1];

 /* adjacency matrix */

int             route[MAX_NODES + 1][MAX_NODES + 1];

 /* routing table */
int             sources_added = 0, num_sources;
int             parent[MAX_NODES + 1];

 /* parent of a node : if a route to a node has been found, its parent is
  * set to the source (root) */

route_graph (graf)
    graph          *graf;

{
    int             source, root, i, j, k, l, w;
    grnodeptr       node;
    gredgeptr       edge;

/* initialize : set parent of node to be itself */
    for (i = 0; i < MAX_NODES + 1; i++)
	parent[i] = i;

/* find the number of sources */
    num_sources = 0;
    node = graf->nodes;
    while (node != 0)
    {
	num_sources++;
	node = node->next;
    }
    if (ROU_DEBUG)
	printf ("number of nodes %d\n", num_sources);

/* set up the adjacency matrix */
    for (i = 0; i < MAX_NODES + 1; i++)
	for (j = 0; j < MAX_NODES + 1; j++)
	{
	    adj[i][j] = MAX_DIAMETER;
	    route[i][j] = 0;
	    /* for sanity check later ... */
	}
    edge = graf->edges;
    while (edge != 0)
    {
	adj[((edge->node1)->nodedata)->nodeid][((edge->node2)->nodedata)->nodeid] = 1;
	adj[((edge->node2)->nodedata)->nodeid][((edge->node1)->nodedata)->nodeid] = 1;
	edge = edge->next;
    }

/* do for all the sources */
    for (root = 0; root < MAX_NODES + 1; root++)
    {
	if (ROU_DEBUG)
	    printf ("source is now %d\n", root);

/* set the route for all neighbours first */
	for (source = 0; source < MAX_NODES + 1; source++)
	    if (parent[source] != root)
	    {
		hop_count[source] = adj[source][root];
		if (hop_count[source] != MAX_DIAMETER)
		    route[root][source] = source;
	    }
/* go thru all sources adding them to the list of reachable nodes */
	sources_added = 1;	/* self */

	while (sources_added < num_sources)
	{
	    hop_count[0] = MAX_DIAMETER;
	    w = 0;
/* w is the node that is the nearest to the subtree that has
been routed */

	    for (source = 1; source < MAX_NODES + 1; source++)
		if (parent[source] != root)
		    if (hop_count[source] < hop_count[w])
			w = source;
	    if (ROU_DEBUG)
		printf ("w set to %d\n", w);
	    parent[w] = root;
	    sources_added++;

/* update distance counts for the nodes that are adjacent to w */
	    if (w != 0)
	    {
		for (source = 1; source < MAX_NODES + 1; source++)
		    if (parent[source] != root)
			if (hop_count[w] + adj[w][source] < hop_count[source])
			{
			    route[root][source] = route[root][w];
			    if (ROU_DEBUG)
				printf ("route[%d][%d] set to %d\n", root, source, route[root][w]);
			    hop_count[source] = hop_count[w] + 1;
			}
	    }
	}
	/* reinitialize */
	for (i = 0; i < MAX_NODES + 1; i++)
	    parent[i] = i;
    }
}
