#include "real.h"
#include "hash.h"
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef __alpha
#include <cvt.h>
#endif

#define 	NAME_SIZE 64
#define 	SB_SIZE 512
#define D(x) 

extern int      PLOT_ON;
extern struct hash_template *hnameptr[MAX_NODES + 1];

/* all chars, so that the compiler won't pad it for me */
struct dbuf {
    unsigned char   index [1];
    unsigned char   time [4];
    unsigned char   value[4];
};

#define TEXT_PKT 0
#define CHART_PKT 1
#define DATA_PKT 2

/* the smart bufffer data structure */
struct {
    char 	   *dataptr;
    int             num_elements;
    int             size;
    int             fd;
    int		    count;
}               sb;


struct {
    char            type;
    short           length;
}               data_packet_template;

struct {
    unsigned char   type;
    unsigned short  length;
    unsigned char   index;
    char            name[64];
}               chart_packet_template;

struct intbits {
    unsigned        sign:1;
    unsigned        exponent:8;
    unsigned        mantissa:23;
};

/* add to smart buffer:  dump if full */
sb_append(index, data)
    unsigned char   index;
    float           data;
{
    timev           now;
    int		    count;
    static int step = sizeof(struct dbuf);
    float ftemp, gtemp;

    now = runtime();

    D( printf("now %f, index %d, data %f\n", (float)(now.tv_sec + ((float)now.tv_usec)/MILLION), index, data);)

    count = sb.count * sizeof(struct dbuf);

    /* copy the index */
    bcopy(&index, &(sb.dataptr[count]), 1); 

    /* convert time to float value and send it */
    ftemp = (float) ((float) now.tv_sec + ((float)(now.tv_usec))/MILLION);
#ifdef __alpha
    cvt_ftof(&ftemp, CVT_IEEE_S, &gtemp, CVT_BIG_ENDIAN_IEEE_S, 0);
    bcopy(&gtemp, &(sb.dataptr[count])+1, 4); 
#else
    bcopy(&ftemp, &(sb.dataptr[count])+1, 4); 
#endif

    /* send the data value itself */
    ftemp = data;
#ifdef __alpha
    cvt_ftof(&ftemp, CVT_IEEE_S, &gtemp, CVT_BIG_ENDIAN_IEEE_S, 0);
    bcopy(&gtemp, &(sb.dataptr[count])+5, 4); 
#else
    bcopy(&ftemp, &(sb.dataptr[count])+5, 4); 
#endif

    sb.count++;

    if (sb.count >= sb.num_elements) {
	data_packet_template.type = DATA_PKT;
	write(sb.fd, &(data_packet_template.type), sizeof(data_packet_template.type));
	data_packet_template.length = htons(sb.num_elements * sizeof(struct dbuf));
	write(sb.fd, &(data_packet_template.length), sizeof(data_packet_template.length));
	write(sb.fd, sb.dataptr, sb.num_elements * sizeof(struct dbuf));
	D(printf("writing data packet: length %d\n", (sb.num_elements * sizeof(struct dbuf)));)

	sb.count = 0;
    }
}

/*
 * make a file name from string and current node number
 */

static char    *
make_fname(s, n)
    char           *s;
    int             n;
{
    char           *buf;

    buf = malloc(NAME_SIZE);
    sprintf(buf, "%s%d", s, n);
    return buf;
}

/* comparision for string names */
int
c_compare(a, b)
char *a, *b;
{
    char           *v1, *v2;

    v1 = a;
    v2 = b;

    return (not strcmp(v1, v2));
}

/* hash a string */
int
c_hashfn(input, size)
    void           *input;
    int             size;
{
    char           *s;
    int             i, j;
    unsigned int    hash;

    s = input;
    i = strlen(s);

    hash = 23;
    for (j = 0; j < i; j++)
	hash *= s[j];
    return hash % size;
}

make_flt_plot(name, data)
    char           *name;
    float           data;
{
    struct hash_template *h;
    timev           now;
    int             node, *c, name_len;
    char           *s;
    static char     index = 0;


    /* test if we have work to do */
    if (!PLOT_ON)
	return;

    node = get_node_id();
    if (!plot_option[node])
	return;

    /* look up in hash table */
    h = hnameptr[node];

    if (h is 0) {	     /* no hash table */
	/* largest # of indices is 256, so use 8 times that */
	h = hash_create(2048, c_compare, c_hashfn);
	hnameptr[node] = h;
    }

    /* look for record in hash table */
    s = make_fname(name, node);
    if ((c = hash_locate(h, s)) is(int *) -1) {	/* no record */
	c = (int *) malloc((unsigned) sizeof(int));
	*c = index;
	hash_insert(h, s, c);

	/* send the CHART type packet */
	/* sb.fd is initialised by the init_sb */
	chart_packet_template.type = CHART_PKT;
	chart_packet_template.index = (unsigned char) *c;

	name_len = strlen(s);

	/* if too long, truncate the name */
	if (name_len >= sizeof(chart_packet_template.name))
	    s[sizeof(chart_packet_template.name)-1] = '\0';

	strcpy(chart_packet_template.name, s);
	chart_packet_template.length = htons((unsigned short)(name_len + 2));
	/* 1 for the null, and 1 for the index field */

	D(printf("writing chart packet: length %d name %s index %d\n", name_len + 2, s, *c);)

	write(sb.fd, &(chart_packet_template.type), sizeof(chart_packet_template.type));
	write(sb.fd, &(chart_packet_template.length), sizeof(chart_packet_template.length));
	write(sb.fd, &(chart_packet_template.index), sizeof(chart_packet_template.index));
	write(sb.fd, &(chart_packet_template.name), strlen(s));

	index++;
    }

    /* append to smart buffer */
    sb_append((char) *c, data);
}

make_plot(name, data)
    char           *name;
    int             data;
{
    make_flt_plot(name, (float) data);
}

init_sb()
{
    int             sock, msgsock;
    struct sockaddr_in server;

    sb.count = 0;
    sb.dataptr = malloc(SB_SIZE);
    sb.size = SB_SIZE; 
    sb.num_elements = sb.size / sizeof(struct dbuf);

    if (PortNumber is 0) {
	if((sb.fd = open("./plot", O_CREAT | O_APPEND | O_WRONLY | O_TRUNC, S_IRUSR | S_IWUSR)) is -1){
	    perror("open");
	    pr_error("unable to open plot file!");
	 }
    }
    else {
	printf("PortNumber %d\n", PortNumber);
	sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock < 0) {
	    perror("opening stream");
	    return -1;
	}
	server.sin_family = AF_INET;
	server.sin_addr.s_addr = INADDR_ANY;
	server.sin_port = PortNumber;	/* already did htons earlier */

	if (bind(sock, &server, sizeof(server))) {
	    perror("binding");
	    return -1;
	}
	printf("Waiting for connection from GUI on port %d\n", PortNumber);
	listen(sock, 5);
	msgsock = accept(sock, 0, 0);
	sb.fd = msgsock;
    }
}

close_smart_buffer()
{
    data_packet_template.type = DATA_PKT;
    data_packet_template.length = htons(sb.count * sizeof(struct dbuf));

    write(sb.fd, &(data_packet_template.type), sizeof(data_packet_template.type));
    write(sb.fd, &(data_packet_template.length), sizeof(data_packet_template.length));
    write(sb.fd, sb.dataptr, sb.count * sizeof(struct dbuf));

    D(printf("writing data packet: length %d\n", ((sb.count + 1) * sizeof(struct dbuf)));)

    D(printf("closing plot file or socket \n");)
    close(sb.fd);
}
