/* parameters received from input file */
/***************************************/

#define MN MAX_NODES + 1

/* from header */

extern float inter_pkt ; 		/* avg. interpkt. time in seconds */
extern int random_seed;			/* seed for random number generator */
extern int op_qsize ; 			/* size of an output queue */ 
extern int telnet_size, ftp_size;  	/* pkt sizes */
extern int   ack_size; 			/* size of ack packets */
extern int ftp_window;			/* max ftp window size */
extern int telnet_window; 		/* max telnet window size */
extern int decongest_mechanism ; 	/* 0 = first, 1 = last , 2 = random */
extern int realnum; 			/* number of this simulatio */
extern int cc_router; 			/* cross computer router */
extern float end_simulation;		/* time to stop simulation */
extern int print_interval;		/* how often to print stats */
extern float scale_factor;		/* simulation scaling factor */
extern float util_time;			/* time period for router utilizn */

/* from node description */

extern ident assigned_sink[MN]; 	/* where to send packets */
extern timev node_start_time [MN]; 	/* time to start node */
extern char plot_option[MN];		/* set to plot node */
extern int num_pkts[MN];		/* number of pkts to send */
extern float on_time[MN]; 		/* how long an on-off source is on */
extern float off_time[MN]; 		/* how long an on-off source is off */
extern float peak_bandwidth[MN];
extern float ave_bandwidth[MN]; 	/* average bandwidth */
extern long interval[MN]; 		/* averaging interval  */
extern long jitter[MN]; 		/* worst jitter tolerable */
extern int nb_table[MN][NUM_LEVELS];	/* HRR starting nb value */
extern int b_table[MN][NUM_LEVELS];	/* HRR starting b value */
extern int policy [MN]; 		/* scheduling policy */
extern char input_file[MN][400];	/* file to read trace from */
extern int class[MN];			/* QOS class of a node for xunet */

/* from edge description */

extern float line_speeds[MN][MN]; 	/* line speeds of the lines */
extern float weight[MN][MN]; 		/* prop delay of the line */
extern float loss_prob[MN][MN]; 	/* prob. of a burst loss */
extern float corruption_prob[MN][MN]; 	/* prob. of a corrupted bit */
extern float loss_burst_size [MN][MN]; 	/* mean pkts. lost in burst */

/*  other shared globals */
/**********************************/

extern int source_node_type[MN]; 	/* type of a node */
extern int num_buffers_in_q[MN][MAX_CONVERSATIONS];	
					/* conv's queue length */
extern int busy [MN][MAX_FAN_OUT]; 	/* set if the line is busy */
extern float alpha_rtt_ftp ;		/* alpha for computing rtt */
extern float alpha_rtt_telnet ;
extern float beta_rtt;
extern int route[MN][MN];		/* routing table */
extern int num_retransmissions [MN];	/* # pkts retxed by src */
extern TABLE rt_time[MN];            	/* real RTTs */
extern TABLE so_tossed[MN];          	/* packet losses for each source */
extern TABLE retxs[MN];              	/* number of retransmissions */
extern TABLE qing_delay[MN][MN];     	/* queueing delay in router */

/* function prototypes */

extern          enq (), num_in_q ();
extern float    expntl ();
extern PKT_PTR  deq ();
extern char * type_to_str();
