/**************** queueing stuff for node functions **********/

#include "real.h"

#define NULPTR (PKT_PTR) 0
#define LOW 0
#define HIGH 1
PKT_PTR         src_head[MAX_NODES + 1]; 
PKT_PTR         src_tail[MAX_NODES + 1];

/* high priority packet enqueue */

enq_high (node, pkt)
    ident           node;
    PKT_PTR         pkt;

{
    PKT_PTR p;

    pkt->priority = HIGH;

    p = src_head[node];

    if(p is NULPTR){
	src_head[node] = pkt;
        src_tail[node] = pkt;
	pkt->next = NULPTR;
    }
    else if (p->next is NULPTR) {	/* one packet in queue */
	if(p->priority is LOW){
   	    src_head[node] = pkt;
	    pkt->next = p;
	} else {
	    p->next = pkt;
	    pkt->next = NULPTR;
	    src_tail[node] = pkt;
	}
   } else {				/* more than one packet */ 
	while( p->next isnt NULPTR and p->next->priority is HIGH)
	    p = p->next;

	/* at this point, either end of high pri zone, or end of list */
	if(p->next is NULPTR){ /* end of list */
	    p->next = pkt;
	    pkt->next = NULPTR;
	    src_tail[node] = pkt;
	} else if(src_head[node] is p) { /* no hi pri zone at all */
	    pkt->next = src_head[node];
	    src_head[node] = pkt;
	} else {	/* p is the last hi pri packet */
	    pkt->next = p->next;
	    p->next = pkt;
	}
    }
}

enq (node, pkt)
    ident           node;
    PKT_PTR         pkt;

{
    if (src_head[node] == NULPTR)
	src_head[node] = pkt;
    else
	src_tail[node]->next = pkt;
    src_tail[node] = pkt;
    pkt->next = NULPTR;
    pkt->priority = LOW;
}

PKT_PTR
deq (node)
    ident           node;
{
    PKT_PTR         tptr;

    if (src_head[node] == NULPTR)	/* MT Q */
	return NULL;
    if (src_head[node] == src_tail[node])
	/* One element in Q */
    {
	tptr = src_head[node];
	src_head[node] = src_tail[node] = NULPTR;
	return tptr;
    }
    /* at least 2 elements */
    tptr = src_head[node];
    src_head[node] = tptr->next;
    tptr->next = NULPTR;	/* Annul pointer */
    return tptr;
}

int
num_in_q (node)
{
    int             i;
    PKT_PTR         tptr;

    if (src_head[node] == NULPTR)
	return 0;
    if (src_head[node] == src_tail[node])
	return 1;

    tptr = src_head[node];
    for (i = 0; tptr != NULPTR; i++, tptr = tptr->next)
	;
    return i;
}
