extern int             MON_DEBUG;

#include "real.h"

extern FILE    *result_file;
extern          close_result_file ();
extern graph   *nest_monitor ();

static int      first_pass = true;

graph*
custom_monitor (graf)
graph * graf;

{
    timev 	now;

    now = graf->header->timenow;
    if (first_pass)
    {
	printf ("\nREAL Version 5.0 Under Licence from Columbia University, UC Berkeley and Cornell University\n\n");

	route_graph (graf);		/* set up static routing */
	init_values(graf);		/* initialize stuff from graph */

#ifdef DISTRIBUTE
	init_socks ();		/* entry point for dist simulation */
#endif
	first_pass = false;
    }
    else
    {
	if (now.tv_sec % print_interval is 0)
	{
	    open_result_file ();
	    print_report (graf);
	    close_result_file ();

	    printf ("%4.3f...", make_float(now));
	    fflush (stdout);
	}
    }

#ifdef DISTRIBUTE
    coord (newgraf->header->timenow);
#endif

    if (make_float(now) >= end_simulation)
    {
        open_result_file ();
        print_summary (graf);
        close_result_file ();
        close_smart_buffer();
        printf ("\n Goodbye !\n");
        exit ();
    }
    return nil;
}

init_values(graf)
    graph          *graf;
{
    grnodeptr       node;
    gredgeptr       edge;
    int             count = 0;

    node = graf->nodes;
    while (node != nil)
    {
	assigned_sink[node->nodedata->nodeid] = node->nodedata->sink;
	plot_option[node->nodedata->nodeid] = node->nodedata->plot;
	node = node->next;
    }

    edge = graf->edges;
    while (edge != nil)
    {
	line_speeds[edge->node1->nodedata->nodeid][edge->node2->nodedata->nodeid] = edge->edgedata->line_speed;
	line_speeds[edge->node2->nodedata->nodeid][edge->node1->nodedata->nodeid] = edge->edgedata->line_speed;

	weight[edge->node1->nodedata->nodeid][edge->node2->nodedata->nodeid] = edge->edgedata->weight;
	weight[edge->node2->nodedata->nodeid][edge->node1->nodedata->nodeid] = edge->edgedata->weight;
	loss_prob[edge->node1->nodedata->nodeid][edge->node2->nodedata->nodeid] = edge->edgedata->loss_prob;

	loss_prob[edge->node2->nodedata->nodeid][edge->node1->nodedata->nodeid] = edge->edgedata->loss_prob;

	corruption_prob[edge->node1->nodedata->nodeid][edge->node2->nodedata->nodeid] = edge->edgedata->corruption_prob;
	corruption_prob[edge->node2->nodedata->nodeid][edge->node1->nodedata->nodeid] = edge->edgedata->corruption_prob;

	loss_burst_size[edge->node1->nodedata->nodeid][edge->node2->nodedata->nodeid] = edge->edgedata->loss_burst_size;
	loss_burst_size[edge->node2->nodedata->nodeid][edge->node1->nodedata->nodeid] = edge->edgedata->loss_burst_size;

	edge = edge->next;
    }
}

/* print out current value of the graph */
dump_graf (graf)
    graph          *graf;
{
    gredgeptr       edge;
    grnodeptr       node;

    printf ("Graph structure at time (%d,%d)\n", graf->header->
	    timenow.tv_sec, graf->header->timenow.tv_usec);

    edge = graf->edges;
    node = graf->nodes;

    printf ("nodes : \n");

    while (node != nil)
    {
	printf ("node id %d	function %d\n", node->nodedata->
		nodeid, node->nodedata->function);
	node = node->next;
    }

    while (edge != nil)
    {
	printf ("edge from %d to %d \n", edge->node1->nodedata->nodeid, edge->node2->nodedata->nodeid);
	edge = edge->next;
    }
    printf ("\n\n");
}

