case $CONFIG in
'')
    if test ! -f ../../src/config.sh; then
	(echo "Can't find ../../src/config.sh."; exit 1)
    fi
    . ../../src/config.sh
    ;;
esac

: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.

echo "Extracting makefile (with variable substitutions)"
cat >makefile <<!GROK!THIS!

#
# makefile for REAL 5.0
# 

# Configuration options
 
INC = ../../src 
 
# Standard make variables
 
CC = cc
CFLAGS = -g -c -w 
 
LINT = lint
LINTFLAGS = -buxz
 
CPP = /lib/cpp 
AS = as
 
LD = ld
LDFLAGS = 
LIBS = 

RANLIB = /usr/bin/ranlib

headers = ../kernel/config.h ../kernel/parameters.h ../kernel/types.h  	../../src/nest.h ../../src/graph.h  ../../src/dcctime.h  	../../src/nest.a  ../router/router.h

functions = 	channels.c     monitor.c      timer.c 	symtab.c 	\
		fuzzy.c	       node_queue.c   routing.c	     table.c  	\
		hash.c	       plotting.c     sim.c	  init.c \
		switches.c     


functionobj = 	channels.o     monitor.o      timer.o 	symtab.o 	\
		fuzzy.o	       node_queue.o   routing.o	     table.o  	\
		hash.o	       plotting.o     sim.o	  init.o \
		switches.o     


final: $(functionobj) $(headers) demux

symtab.o: symtab.c makefile
	$(CC) $(CFLAGS) $(LIBS) $(LDFLAGS) symtab.c

sim.o: sim.c
	$(CC) $(CFLAGS) -I$(INC) $(LIBS) $(LDFLAGS)  $d_cckr sim.c

!GROK!THIS!
cat >>makefile <<'!NO!SUBS!'

.c.o : ; $(CC) $(CFLAGS)  $*.c

tags :
	ctags *.c

demux: demux.c
	$(CC) demux.c -o demux -lm

depend: $(functions) 
	../../src/makedepend $(functions) > depends
	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
	echo '$$r depends' >>eddep
	echo 'w' >>eddep
	cp makefile makefile.bak
	ed - makefile < eddep
	rm -f eddep depends
	echo '' >> makefile
	echo '# DEPENDENCIES MUST END AT END OF FILE' >> makefile
	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> makefile
	echo '# see make depend above' >> makefile

# DO NOT DELETE THIS LINE -- make depend uses it


# DEPENDENCIES MUST END AT END OF FILE
# IF YOU PUT STUFF HERE IT WILL GO AWAY
# see make depend above



!NO!SUBS!
