/* fuzzy controller for estimation of service rate. notes 6:34 */
/* 1 step spike elimination */
/* S. Keshav, UCB 3/13/91 */
/* all the code in this file is bottom up */

/******************************************/
/* EXPORTS: compute_alpha(sbest, sbact);  */
/******************************************/

#include "real.h"

typedef struct trap TRAP, *TRAP_PTR;/* trapezium structure */

struct trap
{
    float   x1, x2, x3, x4, y0, area, xcentroid, ycentroid;
};
 /* ycentroid is not used */


float   old_error_1[MAX_NODES + 1];/* last value of error (unsmoothed) */
float   old_error_2[MAX_NODES + 1];/* last value of error (unsmoothed) */
float   error_est[MAX_NODES + 1];/* estimator */
char    fuzzy_start[MAX_NODES + 1];
			     /* 1 when fuzzy is called for the first time
			        by a node */

/* LP and RP for alpha, beta and error are all assumed to be 0 and 1 */

#define LP 0.0		     /* left end point */
#define MP_E 0.7	     /* middle point for error */
#define MP_A 0.5	     /* middle point for alpha */
#define RP 1.0		     /* values suggested by P.S. Khedkar, UCB */

float
moddiff (a, b)
float   a, b;
{
    return ((a > b) ? a - b : b - a);
}

float
        xintercept (x1, y1, x2, y2, y)
float   x1, y1, x2, y2, y;
{
    return (((x2 - x1) / (y2 - y1)) * (y - (x2 * y1 - x1 * y2) / (x2 - x1)));
}

float
        yintercept (x1, y1, x2, y2, x)
float   x1, y1, x2, y2, x;
{
    return (((y2 - y1) / (x2 - x1)) * x + ((x2 * y1 - x1 * y2) / (x2 - x1)));
}

float
        get_error (sbest, sbact, beta)
float   sbest, sbact, beta;
{
    float   error;	     /* error is the |error| in the estimate */
    int     node;

    node = get_node_id ();
    error = moddiff (sbest, sbact) / sbest;
    old_error_2[node] = old_error_1[node];
    old_error_1[node] = error;
    error_est[node] = beta * error_est[node] + (1 - beta) * error;
    return error_est[node];
}


float
        poss_low (error, mp) /* possibility of `low', mp is the middle
			        point */
float   error, mp;	     /* error = proportional error */
{
    if (error <= LP)
	return 1.0;
    if (error >= mp)
	return 0.0;
    return (yintercept (LP, 1.0, mp, 0.0, error));
}

float
        poss_high (error, mp)/* possibility of `high' */
float   error, mp;
{
    if (error <= mp)
	return 0.0;
    if (error >= RP)
	return 1.0;
    return (yintercept (mp, 0.0, RP, 1.0, error));
}

float
        poss_med (error, mp) /* possibility of `medium ' */
float   error, mp;
{
    if (error <= LP)
	return 0.0;
    if (error >= RP)
	return 0.0;
    if (error >= LP and error < mp)
	return (yintercept (LP, 0.0, mp, 1.0, error));
    return (yintercept (mp, 1.0, RP, 0.0, error));
}

xcentroid (trap)	     /* x coordinate of centriod of a trapezium */
TRAP_PTR trap;
{
    float   x1, x2, x3, x4;

    x1 = trap -> x1;
    x2 = trap -> x2;
    x3 = trap -> x3;
    x4 = trap -> x4;

    trap -> xcentroid = ((x3 * x4 - x1 * x2 + x3 * x3 + x4 * x4 - x1 * x1 - x2 * x2) /
	    (3 * (x3 + x4 - x1 - x2)));
}

ycentroid (trap)	     /* y coordinate of centriod of a trapezium */
TRAP_PTR trap;
{
    float   x1, x2, x3, x4, y0;

    if (trap -> area == 0)
    {
	trap -> ycentroid = 0.0;
	return;
    }
    x1 = trap -> x1;
    x2 = trap -> x2;
    x3 = trap -> x3;
    x4 = trap -> x4;
    y0 = trap -> y0;

    trap -> ycentroid = ((y0 * (2 * x3 + x4 - x1 - 2 * x2)) /
	    (3 * (x4 + x3 - x2 - x1)));
}

find_area (trap)		     /* compute area of trapezium */
TRAP_PTR trap;
{
    float   x1, x2, x3, x4, y0;
    x1 = trap -> x1;
    x2 = trap -> x2;
    x3 = trap -> x3;
    x4 = trap -> x4;
    y0 = trap -> y0;

    trap -> area = 0.5 * y0 * (x4 + x3 - x2 - x1);
}

init_trap (trap, x1, x2, x3, x4, y0)
TRAP_PTR trap;
float   x1, x2, x3, x4, y0;
{
    trap -> x1 = x1;
    trap -> x2 = x2;
    trap -> x3 = x3;
    trap -> x4 = x4;
    trap -> y0 = y0;
}

float
        compute_alpha (sbest, sbact)
float   sbest, sbact;
{
   /* for beta, only use low and high */
    float   error, ce, beta;
    /* ce is the change in the mod proportional error */
    float   low, med, high;  /* these are the heights in the result space 
			     */
    float   x11, x12, x21, x22, x23, x24, x31, x32;
    /* intercepts (pg 6:47) */
    float   wa, wb, wc, wd, we;
    /* relative weights of a, b, c, d, e */
    float   value;
    int     node;
    static float    inv_range_a, inv_range_b, 
		    left_xcentroid_a, left_xcentroid_b;
    static  TRAP left;
    TRAP a, b, c, d, e, right;

    node = get_node_id ();

    if (fuzzy_start[node])
    {
	fuzzy_start[node] = 0;
	sbest = 1.5 * sbact; /* hack for start up */
	old_error_1[node] = old_error_2[node] = 0.0;
	error_est[node] = 0.5;

	init_trap (&left, 0.0, 0.0, LP, MP_A, 1.0);
	init_trap (&right, MP_A, RP, 1.0, 1.0, 1.0);
	xcentroid (&left);
	xcentroid (&right);
	inv_range_a = 1.0 / (right.xcentroid - left.xcentroid);
        left_xcentroid_a = left.xcentroid;

	init_trap (&left, 0.0, 0.0, LP, RP, 1.0);
	init_trap (&right, LP , RP, 1.0, 1.0, 1.0);
	xcentroid (&left);
	xcentroid (&right);
	inv_range_b = 1.0 / (right.xcentroid - left.xcentroid);
        left_xcentroid_b = left.xcentroid;
    }

    ce = moddiff (moddiff (sbest, sbact) / sbest, old_error_1[node]);
    /* change in error */
    low =  1 - ce ; 
	/* = yintercept(0.0, 1.0, 1.0, 0.0, ce);*/
    high = ce ;
	/* = yintercept(0.0, 0.0, 1.0, 1.0, ce);*/

    x23 = low;
    x24 = 1 - low;
    x31 = high;
    x32 = 1 - high;

    init_trap (&b, LP, LP, x24, RP, low);
    init_trap (&c, LP, x31, 1.0, 1.0, high);
    init_trap (&e, LP, min (x23, x31), max (x24, x32), RP, min (low, high));

    find_area (&b); find_area (&c); find_area (&e);
    xcentroid (&b); xcentroid (&c); xcentroid (&e);

    if (b.area != 0) wb = b.area * b.xcentroid; else wb = 0.0;
    if (c.area != 0) wc = c.area * c.xcentroid; else wc = 0.0;
    if (e.area != 0) we = e.area * e.xcentroid; else we = 0.0;

    value = ((wb + wc - we) / (b.area + c.area - e.area));

    beta = ((value - left_xcentroid_b) * inv_range_b);
    /* fuzzy control for beta */

    error = get_error (sbest, sbact, beta);
    /* these three lines implement the control law */
    low = poss_high (error, MP_E);
    med = poss_med (error, MP_E);
    high = poss_low (error, MP_E);

    x11 = xintercept (LP, 1.0, MP_A, 0.0, low);
    x12 = xintercept (LP, 0.0, MP_A, 1.0, low);
    x21 = xintercept (LP, 0.0, MP_A, 1.0, med);
    x22 = xintercept (LP, 1.0, MP_A, 0.0, med);
    x23 = xintercept (MP_A, 0.0, RP, 1.0, med);
    x24 = xintercept (MP_A, 1.0, RP, 0.0, med);
    x31 = xintercept (MP_A, 0.0, RP, 1.0, high);
    x32 = xintercept (MP_A, 1.0, RP, 0.0, high);

    init_trap (&a, 0.0, 0.0, x11, MP_A, low);
    init_trap (&b, LP, x21, x24, RP, med);
    init_trap (&c, MP_A, x31, 1.0, 1.0, high);
    init_trap (&d, LP, min (x11, x21), max (x12, x22), MP_A, min (low, med));
    init_trap (&e, MP_A, min (x23, x31), max (x24, x32), RP, min (med, high));

    find_area (&a); find_area (&b); find_area (&c); find_area (&d); find_area (&e);
    xcentroid (&a); xcentroid (&b); xcentroid (&c);
    xcentroid (&d); xcentroid (&e);

    if (a.area != 0) wa = a.area * a.xcentroid; else wa = 0.0;
    if (b.area != 0) wb = b.area * b.xcentroid; else wb = 0.0;
    if (c.area != 0) wc = c.area * c.xcentroid; else wc = 0.0;
    if (d.area != 0) wd = d.area * d.xcentroid; else wd = 0.0;
    if (e.area != 0) we = e.area * e.xcentroid; else we = 0.0;

    value = ((wa + wb + wc - wd - we)
	    / (a.area + b.area + c.area - d.area - e.area));

    return ((value - left_xcentroid_a) * inv_range_a);
    /* scale to [0,1] */
}
