#include "real.h"
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef __alpha
#include <cvt.h>
#endif

#define D(x) 

/* all chars, so that the compiler won't pad it for me */
struct dbuf {
    unsigned char   index[1];
    unsigned char   time[4];
    unsigned char   value[4];
};

#define CHART_PKT 1
#define DATA_PKT 2
#define MAX_CHARTS 64

FILE           *ftab[MAX_CHARTS];

struct {
    char            type;
    short           length;
}               data_packet_template;

struct {
    unsigned char   type;
    unsigned short  length;
    unsigned char   index;
    char            name[64];
}               chart_packet_template;

unsigned char
read_char(fd)
    int             fd;
{
    char            data;
    int             r;

    if ((r = read(fd, &data, 1)) is - 1) {
	perror("read");
	pr_error("couldn't read plot file\n");
    }
    if (r is 0)
	exit();
    return data;
}

unsigned short
read_short(fd)
    int             fd;
{
    short           data;
    int             r;

    if ((r = read(fd, &data, 2)) is - 1) {
	perror("read");
	pr_error("couldn't read plot file\n");
    }
    if (r is 0)
	exit();
    return data;
}

float
read_float(fd)
    int             fd;
{
    float           data;
    int             r;
    if ((r = read(fd, &data, 4)) is - 1) {
	perror("read");
	pr_error("couldn't read plot file\n");
    }
    if (r is 0)
	exit();
    return data;
}

main(argc, argv)
    char            argc;
    char          **argv;
{

    int             i, fd;
    unsigned char   type, index, *zerobuf;
    unsigned short  length;
    char            nmbuf[64];
    float	    time, value, t;

    if (argc < 2){
	printf("usage: demux <file>\n");
	exit();
    }

    zerobuf = (unsigned char *) calloc(64, 1);

    if ((fd = open(argv[1], O_RDONLY)) is - 1) {
	perror("open");
	pr_error("unable to open plot file!");
    }
    while (1) {
	type = read_char(fd);
	D(printf("type = %d ", type);)

	length = ntohs(read_short(fd));
	D(printf("length = %d ", length);)

        switch (type) {

	case CHART_PKT:
	    index = read_char(fd);
	    bcopy(zerobuf, nmbuf, 64);
	    read(fd, nmbuf, length-2);
	    D(printf("index %d name %s\n", index, nmbuf);)
	    printf("Creating file %s\n", nmbuf);
	    ftab[index] = fopen(nmbuf, "w+");
	    break;

	case DATA_PKT:
	    for(i = 0; i < length/9; i++){
	        index = read_char(fd);
	        time = read_float(fd);
#ifdef __alpha
		cvt_ftof(&time, CVT_BIG_ENDIAN_IEEE_S, &t, CVT_IEEE_S, 0);
		time = t;
#endif
	        value = read_float(fd);
#ifdef __alpha
                cvt_ftof(&value, CVT_BIG_ENDIAN_IEEE_S, &t, CVT_IEEE_S, 0);
                value = t;
#endif
	        D(printf("index %d, time %f, value %f\n", index, time, value);)
	        fprintf(ftab[index], "%f %f\n", time, value);
	    }
	    break;
	}
    }
}

pr_error(s)
char *s;
{
  printf("Fatal error %s\n", s);
  exit();
}
