/* simulation configuration parameters */
/* S. Keshav UC-Berkeley 3/26/88 */

#include <stdio.h>

/* Simulator sizing info */

#define MAX_NODES 40

#define MAX_FAN_OUT 15 		/* Max number of outgoing trunks */
#define MAX_CONVERSATIONS 50	/* Max conversations in system */
#define MAX_WINDOW_SIZE 10000 	/* window size limit */
#define NUM_LEVELS 2		/* at least 2, if d_hrr_levels is used */

#define FQ_DELTA  0		/* Delta for Fair Queueing */
#define INFINITY 9999999999.0
#define MAX_LONG 1000000000	/* largest long int supported */
#define CAPACITY_FACTOR 0.9	/* used by DECbit */
#define XU_PHASE_SIZE 0.000809
#define DATA_SIZE 500		/* data area in packet */

#define DUMP_FILE "dump"	/* report file */
#undef  DISTRIBUTE		/* defined if distributed simulation */
#undef  RESERVATIONS		/* only used for choosing weights in FQ */

/* scheduling policies */
#define FCFS 1			/* FCFS  */
#define FQ 2			/* Fair queueing */
#define DECBIT 3		/* selective dec bit */
#define FQBIT 4			/* fair queueing with bit setting */
#define HRR 5			/* hierarchical round robin */
#define SFQ 6			/* Stochastic Fairness Queueing */
#define XUNET 7                 /* Xunet II */

/* node types */
#define ROUTER 			1
#define CC_ROUTER 		2 
#define SINK 			3
#define BACKGROUND_SOURCE 	4 
#define CONTROLLED_RATE_SOURCE 	5
#define DEC_SOURCE 		6
#define GENERIC_SOURCE 		7
#define JK_RENO_SOURCE 		8 
#define JK_TAHOE_SOURCE 	9 
#define MALICIOUS_SOURCE 	10
#define MMPP_SOURCE 		11
#define POISSON_SOURCE 		12 
#define PP_SOURCE		13
#define RANDOM_RATE_SOURCE 	14
#define TELNET_SOURCE 		15
#define TRACE_SOURCE		16
#define CODER_SOURCE		17
#define PP_TX			18
#define TEMPLATE		19

static char *node_types[]= {
"0",
"ROUTER ",
"CC_ROUTER ",
"SINK ",
"BACKGROUND_SOURCE ",
"CONTROLLED_RATE_SOURCE",
"DEC_SOURCE ",
"GENERIC_SOURCE ",
"JK_RENO_SOURCE ",
"JK_TAHOE_SOURCE ",
"MALICIOUS_SOURCE ",
"MMPP_SOURCE ",
"POISSON_SOURCE 1",
"PP_SOURCE",
"RANDOM_RATE_SOURCE ",
"TELNET_SOURCE ",
"TRACE_SOURCE",
"CODER_SOURCE",
"PP_TX",
"TEMPLATE"
};

/* packet types */

#define INT 			1	/* interrupt from line card */
#define TIMEOUT 		2	/* timer interrupt */
#define TIMER 			3	/* rate timer interrupt */
#define RATE			4	/* used by coder source */
#define HRR_TIMER 		6	/* used by HRR scheduler */
#define WAKEUP			7	/* used by telnet */
#define UTIL			8	/* used by router to compute
								utilizations */
#define NO_MORE_DATA		9       /* interlock between app and tx */
#define TX_Q_EMPTY		10	/* another interlock */
#define SINGLETON		11	/* used by PP for sweeping up singletons */
#define TICK	  		12	/* timeout */
#define IDLE			13	/* CSMA simulation */
#define BUSY			14	/* CSMA simulation */
#define NACK			15	/* CSMA simulation */

#define NUM_VIRTUAL_TYPES 	20	/* used by channels */

#define DATA			21	/* generic data pkt */
#define ACK 			22	/* acks for data */
#define SETUP 			23	/* signalling */
#define SETUP_ACK 		24	/* signalling */
#define TEARDOWN 		25	/* signalling */

static char *pkt_types[] = {
"0",
"INT",
"TIMEOUT",
"TIMER",
"RATE",
"5",
"HRR_TIMER",
"WAKEUP",
"UTIL",
"NO_MORE_DATA",
"TX_Q_EMPTY",
"SINGLETON",
"TICK",
"IDLE",
"BUSY",
"NACK",
"16",
"17",
"18",
"19",
"NUM_VIRTUAL_TYPES",
"DATA",
"ACK",
"SETUP",
"SETUP_ACK",
"TEARDOWN"
};

/* Random number definition */

#define RANDOM  ( (float)random()/2147483647.00)

/* conversion from timeval to float */

#define make_float(time)\
((float)((float)(time).tv_sec + (float)((time).tv_usec)/1000000.0))

/* macro to round up a timer to the next 500 ms */
#define coarser(x)\
((float)((int)((x * 40.0 + 10.0)/10.0))) * 0.25

/* used to be ((float)((int)((x * 20.0 + 10.0)/10.0))) * 0.5 */

#define  ERROR 			-1
#define  OK 			1
#define TRUE 			1
#define FALSE 			0
#define UP			1
#define DOWN			-1 
