/* channel functions */

#include "real.h"
int      pkts_lost[MAX_NODES + 1][MAX_NODES + 1];             
				/* # pkts dropped in curr.  burst */

/* the random number generator is pretty correlated! So
 * consecutive losses can be much larger than the one selected */

tx_chan (a_node, sender, dest, key, dataptr)
    ident           a_node,	/* actual destination node (never 0) */
                    sender,	/* sender (usually _current_node) */
                    dest;	/* destination node (0 if all nbrs) */
    long            key;	/* message code (user defined int) */
    char           *dataptr;	/* pointer to message string */
{
    timev          *sleeptime;
    PKT_PTR         pkt, intr;
    float           r, bw;
    long            tx_delay, latency;
    int             i;

    bw = line_speeds[a_node][sender] / 8.0;	/* bps -> bytes/sec */
    latency = weight[a_node][sender];

    pkt = (PKT_PTR) dataptr;

    /* look at the size of the packet, and figure out the transmission
     * delay in sending it . The transmitter gets back an INT packet after
     * the tx delay, and the recipient gets it after tx delay + line
     * delay. */

    tx_delay = (long) (((float) pkt->size / (float) bw) * MILLION);

    /* create an INT packet only if the packet is not a virtual pkt */

    if (pkt->type > NUM_VIRTUAL_TYPES) 
    {
        /* create an interrupt packet */

        intr = (PKT_PTR) malloc ((unsigned) sizeof (PKT));
        *intr = *pkt;
        intr->type = INT;

        /* send this to the sender, when sender gets it, it will know that
         * the line is now free */
    
        reliable (sender, 0, sender, key, intr, tx_delay, 0);

	/* burst loss */
        if(pkts_lost[a_node][sender] > 0) { /* middle of a burst */
	    make_entry(1.0, &so_tossed[pkt->source]);
	    pkts_lost[a_node][sender]--;
	    free(pkt);
	    return 1;
	} else {	/* should we start burst? */
	    if (r = RANDOM < loss_prob[a_node][sender]) { /* yes */
	        if(loss_burst_size[a_node][sender] is 1 ) { /* special case */
		    make_entry(1.0, &so_tossed[pkt->source]);
              	    pkts_lost[a_node][sender] = 0;
            	    free(pkt);
            	    return 1;
		} else { /* figure out how many pkts to toss */
		    pkts_lost[a_node][sender] =
			(int)(expntl(loss_burst_size[a_node][sender]) + 0.5) - 1;
		    make_entry(1.0, &so_tossed[pkt->source]);
		    free(pkt);
                    return 1;
                }
	    }
	}
		    
    	/* corruption: only if pkt has a data field */

	if(corruption_prob[a_node][sender] > 0) 
    	    for (i = 0; i < sizeof(pkt->data); i++) 
	        if(RANDOM < corruption_prob[a_node][sender]) 
	   	    pkt->data[i] |= 0x10;
    }
    
    /* pass on the packet to the destination ... */
    return (reliable (a_node, sender, dest, key, dataptr, tx_delay +
		          latency, 0));

}



