# This is a sample input file for the simulator
# it can also be found as lang/example.l
# To see if your simulator is OK, run it on this example as 
# simulate example.l
# Remember that your REALDIR environment variable should be set
# to something reasonable

# the header section is optional

header					
{
network = example;
version = 0;
}

# nest_params section is optional. Default passtime is 1 second
# default maxnodes is MAXNODES in config.h and default monitor is
# custom_monitor in kernel/monitor.c

nest_params {
	passtime = 1,0;
	maxnodes = 30;
	monitor = custom_monitor;
}

# real_params section is also optional. Default definitions are in
# lang/lang.yacc

real_params {
	inter_pkt_delay = 5.0;
#                                       seconds (optional - not used)
	random_seed = 23;
	buffer_size = 440000;
#					bytes 	(different from REAL3.0)
	ftp_pkt_size = 500;
#                                       bytes
	telnet_pkt_size = 40;
#					bytes
	ack_size = 40;
#                                       bytes
	ftp_window = 600;
#                                       packets
	telnet_window = 400;
#                                       packets
	decongestion_mechanism = 4;
#					0 = drop from head
#					1 = drop from tail
#					2 = drop from random position
#					3 = drop all from longest queue
	real_number  = 0;
#					used for distributed REAL
	router_node = 0;
#					used for distributed REAL
	util_time = 1.0;
#					time interval over which to 
#					measure router utilization (secs)
	end_simulation = 50;
#					simulation end time in seconds
	print_interval = 10;
#					print and flush statistics every 
#					print_interval seconds
	scale_factor = 1;
#					time scale factor; if scale factor =
#					1000, 1 simulated second = 1ms realtime
}

nodes{ 
# 					first define the default node type
#					all fields are optional
	default{
		function = poisson;
		dest = 4;
#					destination node to send to 
		start_time = 0,10000;
#					start node at seconds, microseconds
		plot = false ;
#					set to true if you want to plot data
		num_pkts = 1000;
#					number of packets to send 
		on_time = 0;
#					for on-off style sources:
#					on_time is the time from the start
#					of the sending of the first
# 					packet in the on period to the start 
#					of sending of the last pkt.

		off_time = 40000;
#					off_time is time between start
#					of last pkt. in prev burst
#					to start of first pkt in next burst
		peak = 20000.0;
#					for controlled sources: this is the
#					declared peak rate in bits/sec
		average = 5000.0;
#					declared average rate in bits/sec
		interval = 1000000;
#					interval over which average is computed
#					(in microseconds)
		jitter = 20000000;
#					desired max delay jitter from the 
#					network (in microseconds)
		hrr_levels = { 10:0 ; } ;
#					for a hrr router, the b and nb values
#					at each level. Ignored for a source.
		sch_policy = 2;	
#					for router nodes 
#					1 = fcfs
#					2 = fair queueing
#					3 = decbit
#					4 = fqbit
#					5 = hrr
		}

#					for each source, just need to specify
#					what is different compared to the default
	node 1 { function = poisson; plot = true; num_pkts = 4000; dest = 3;}
	node 2 { function = router; plot = true;}
	node 3 { function = sink; location = 1,3;}

}

edges{
	default {
		bandwidth = 2000000;
#					in bits/sec
		latency = 10000;
#					in microseconds
		loss_prob = 0.0;	
#					probability of a loss burst
		loss_burst_size = 0.0;	
#					mean number of packets in loss burst
		corruption_prob = 0.0;
#					probability of bit corruption
		}
	{ 1 -> 2;}
	{ 2 -> 3; bandwidth = 400000; latency = 20000; }
}
