/* 
 * binary tree routines for storing symbol table . Not used--- see sim/kernel/hash.c
 */

#include "tree.h"

/* ROOT */
treenodeptr     treeroot = nilnode;


 /* function to gen up a node and insert appropriate values */
treenodeptr
get_treenode (address, name)
    char	   *address;
    char           *name;
{
    treenodeptr     nodeptr;

    nodeptr = (treenodeptr) malloc ((unsigned) sizeof (treenode));
    nodeptr->lson = nodeptr->rson = nilnode;
    nodeptr->address = address;
    nodeptr->name = (char *) malloc ((unsigned) (strlen (name) + 1));
    strcpy (nodeptr->name, name);
    return nodeptr;
}

insert_address (name, address, nodeptr)
    treenodeptr    *nodeptr;
    char           *name;
    char	   *address;
{
    if ((*nodeptr) is nilnode)
    {
	(*nodeptr) = get_treenode (address, name);
	return;
    }
    if (address < (*nodeptr)->address)
    {
	if ((*nodeptr)->lson is nilnode)
	{
	    (*nodeptr)->lson = get_treenode (address, name);
	    return;
	} else
	    return insert_address (name, address, &((*nodeptr)->lson));
    }
    if (address > (*nodeptr)->address)
    {
	if ((*nodeptr)->rson is nilnode)
	{
	    (*nodeptr)->rson = get_treenode (address, name);
	    return;
	} else
	    return insert_address (name, address, &((*nodeptr)->rson));
    }

/* silently ignore - may be a BUG, but right now is a FEATURE */
/*
	printf("WARNING : trying to insert DUPLICATE ADDRESS !! \n");
*/
}

insert_name (name, address, nodeptr)
    treenodeptr    *nodeptr;
    char           *name;
    char	   *address;
{
    if ((*nodeptr) is nilnode)
    {
	(*nodeptr) = get_treenode (address, name);
	return;
    }
    while(1)
    {
        if (strcmp ((*nodeptr)->name, name) > 0)
        {
	    if ((*nodeptr)->lson is nilnode)
	    {
	        (*nodeptr)->lson = get_treenode (address, name);
	        return;
	    } else
	        nodeptr = &((*nodeptr)->lson);
        }
        if (strcmp ((*nodeptr)->name, name) < 0)
        {
	    if ((*nodeptr)->rson is nilnode)
	    {
	        (*nodeptr)->rson = get_treenode (address, name);
	        return;
	    } else
	        nodeptr = &((*nodeptr)->rson);
        }
    }
}
    
/* find the string name asociated with an address */
char           *
find_name (address, nodeptr)
    char	   *address;
    treenodeptr     nodeptr;
{
    if (nodeptr->address is address)
	return (nodeptr->name);
    else if (nodeptr->address < address)
    {
	if (nodeptr->rson != nilnode)
	    return (find_name (address, nodeptr->rson));
	else
	{
	    printf ("find: SYMBOL NOT FOUND !! \n");
	    exit ();
	}
    } else if (nodeptr->address > address)
    {
	if (nodeptr->lson != nilnode)
	    return (find_name (address, nodeptr->lson));
	else
	{
	    printf ("find : SYMBOL NOT FOUND !! \n");
	    exit ();
	}
    }
}

/* find the address asociated with a name */
char *
find_address (name, nodeptr)
    char           *name;
    treenodeptr     nodeptr;
{
    if (!strcmp (name, nodeptr->name))
	return (nodeptr->address);
    else if (strcmp (nodeptr->name, name) < 0)
    {
	if (nodeptr->rson != nilnode)
	    return (find_address (name, nodeptr->rson));
	else
	{
	    printf ("find: %s : ADDRESS NOT FOUND !! \n", name);
	    exit ();
	}
    } else if (strcmp (nodeptr->name, name) > 0)
    {
	if (nodeptr->lson != nilnode)
	    return (find_address (name, nodeptr->lson));
	else
	{
	    printf ("find: %s : ADDRESS NOT FOUND !! \n", name);
	    exit ();
	}
    }
}

/* free the entire tree */
freetree (nodeptr)
    treenodeptr     nodeptr;
{
    if (nodeptr is nilnode)
	return;
    freetree (nodeptr->lson);
    freetree (nodeptr->rson);
    free (nodeptr->name);
    free (nodeptr);
}

/* testing 1,2,3... */
/*
main()
{
	insert_name("alpha", 1000, &treeroot);
	insert_name("beta", 2000, &treeroot);
	insert_name("gamma", 1500,&treeroot);
	insert_name("delta", 1600,&treeroot);
	insert_name("epsilon", 1700,&treeroot);

	printf("%d\n", find_address("delta", treeroot));
	printf("%d\n", find_address("gamma", treeroot));
	printf("%d\n", find_address("alpha", treeroot));
	
	freetree(treeroot);
}

*/
