/*
 * Implements per channel queueing with a heap on the heads and tails
 * of queues. This is the best way to implement fair queueing
 */

#include "real.h"
#define  MAX  170
#define lson(x) ((2*(x) > num)? (x) : (2*(x)))
#define rson(x) (((2*(x)+1) > num)? (x): (2*(x)+1))
#define parent(x) ((x == 1) ? x : x / 2 )

int             num = 0;	/* num of elements */
int             num_pkts = 0;
int             traverse = 0, old_traverse = 0;
int             del_traverse = 0, ins_traverse = 0;
int             min_ins, max_ins;
int             min_del, max_del;
float           data;
int             channel;
float           min[MAX_CONVERSATIONS + 2], max[MAX_CONVERSATIONS + 2];
typedef struct pkt PKT, *PKT_PTR;

struct pkt {
    PKT_PTR         next;
    PKT_PTR         prev;
    float           data;
}               pkt;

#define nilnode ((PKT_PTR) 0 )
PKT_PTR         head[MAX_CONVERSATIONS], tail[MAX_CONVERSATIONS];
int             min_conv[MAX_CONVERSATIONS], max_conv[MAX_CONVERSATIONS];
int             num_in_q[MAX_CONVERSATIONS];
int             max_ptr[MAX_CONVERSATIONS];
int             min_ptr[MAX_CONVERSATIONS];

insert (data, conv_id)
    float           data;
    int             conv_id;
{
    struct node    *ptr, *newnode;

    /* preemptive strike: see if this packet has to be dropped */
    if ((num_pkts is MAX) and (max_conv[1] is conv_id))
	return;

    /* put in q anyway, this will fix num_in_q as a side effect */
    insert_in_q (data, conv_id);

    /* handle special case of a single packet = new conv */
    if (num_in_q[conv_id] is 1)
    {
	min_insert (data,conv_id);
	num++;
	max_ptr[conv_id] = num;
	max_conv[num] = conv_id;
    }
    /* switch in new max value */
    max[max_ptr[conv_id]] = data;
    max_adjust (max_ptr[conv_id]);
    num_pkts++;
    if (num_pkts > MAX)		/* drop largest */
    {
	int             del_conv;	/* conv to be deleted */

	del_conv = max_conv[1];
	if (num_in_q[del_conv] is 1)	/* only packet */
	{
	    int             save;

	    max_exchg (1, num);
	    max[num] = -1;
	    max_adjust (1);
	    max_ptr[del_conv] = -1;

	    save = min_ptr[del_conv];
	    min_exchg (save, num);
	    min[num] = INFINITY;
	    min_adjust (save);
	    min_ptr[del_conv] = -1;
	    num --;
	} else
	{
	    max[1] = (tail[del_conv]->prev)->data;
	    max_adjust (1);
	}
	delete_tail (del_conv);
	num_pkts--;
    }
}


get_min ()
{
    int             del_conv;

    if (num_pkts is 0)		/* empty heaps */
	return;
    del_conv = min_conv[1];
    if (num_in_q[del_conv] is 1)	/* single pkt */
    {
	int             save;

	min_exchg (1, num);
	min[num] = INFINITY;
  	min_ptr[del_conv] = -1;
	min_adjust (1);

	save = max_ptr[del_conv];
	max_exchg (save, num);
	max[num] = -1;
	max_adjust (save);
	max_ptr[del_conv] = -1;
	num--;
    } else
    {
	min[1] = (tail[del_conv]->prev)->data;
	min_adjust (1);
    }
    delete_tail (del_conv);
    num_pkts--;
}



min_exchg (a, b)
    int             a, b;
{
    float           ftmp;
    int             tmp;

    ftmp = min[a];
    min[a] = min[b];
    min[b] = ftmp;

    tmp = min_ptr[min_conv[a]];
    min_ptr[min_conv[a]] = min_ptr[min_conv[b]];
    min_ptr[min_conv[b]] = tmp;

    tmp = min_conv[a];
    min_conv[a] = min_conv[b];
    min_conv[b] = tmp;

    traverse++;
}

max_exchg (a, b)
    int             a, b;
{
    float           ftmp;
    int             tmp;

    ftmp = max[a];
    max[a] = max[b];
    max[b] = ftmp;

    tmp = max_ptr[max_conv[a]];
    max_ptr[max_conv[a]] = max_ptr[max_conv[b]];
    max_ptr[max_conv[b]] = tmp;

    tmp = max_conv[a];
    max_conv[a] = max_conv[b];
    max_conv[b] = tmp;

    traverse++;
}


min_insert (data,conv_id)
    float           data;
    int conv_id;
{
    int             ptr;

    ptr = num + 1;
    min[ptr] = data;
    min_ptr[conv_id] = ptr;
    min_conv[ptr] = conv_id;

    for (; (ptr / 2 >= 1) && (min[ptr] < min[ptr / 2]); ptr /= 2)
	min_exchg (ptr, ptr / 2);
}

min_adjust (a)
{
    int             smaller, smaller_son;

    smaller = a;		/* smaller than parent ? */
    if (min[a] < min[parent (a)])
	smaller = parent (a);
    smaller_son = (min[lson (a)] < min[rson (a)]) ? lson (a) : rson (a);
    if (min[smaller_son] < min[a])
	smaller = smaller_son;
    if (smaller != a)
    {
	min_exchg (a, smaller);
	min_adjust (smaller);	/* recursively readjust */
    }
}

max_adjust (a)
{
    int             larger, larger_son;

    larger = a;
    if (max[a] > max[parent (a)])
	larger = parent (a);
    larger_son = (max[lson (a)] > max[rson (a)]) ? lson (a) : rson (a);
    if (max[larger_son] > max[a])
	larger = larger_son;
    if (larger != a)
    {
	max_exchg (a, larger);
	max_adjust (larger);
    }
}

sanity ()
{
    int             i;

    for (i = 1; i <= (num / 2); i++)
    {
	if (min[i] > min[lson (i)])
	{
	    printf ("min tree screwed up!\n");
	    dump_tree (i);
	    exit();
	}
	if (min[i] > min[rson (i)])
	{
	    printf ("min tree screwed up!\n");
	    dump_tree (i);
		exit();
	}
	if (max[i] < max[lson (i)])
	{
	    printf ("max tree screwed up!\n");
	    dump_tree (i);
		exit();
	}
	if (max[i] < max[rson (i)])
	{
	    printf ("max tree screwed up!\n");
	    dump_tree (i);
		exit();
	}
	if ((min_ptr[i] is -1) and (max_ptr[i] isnt -1))
	{
	    printf ("both ptrs not -1 !\n");
	    dump_tree (i);
		exit();
	}
    }

    for (i = 1; i <= num; i++)
    {
	if (max_ptr[max_conv[i]] isnt i)
	{
	    printf ("max_ptr bug\n");
	    dump_tree (i);
	    exit ();
	}
	if (min_ptr[min_conv[i]] isnt i)
	{
	    printf ("min_ptr bug\n");
	    dump_tree (i);
	    exit ();
	}
    }
}

dump_tree (i)
    int             i;
{
    int             j;

    printf ("Bug detected for index %d\n\n", i);
    for (j = 1; j <= num; j++)
	printf ("min[%d] = %f \n", j, min[j]);
    printf ("\n");
    for (j = 1; j <= num; j++)
	printf ("max[%d] = %f \n", j, max[j]);
    printf ("\n");
    for (j = 1; j <= num; j++)
	printf ("max_ptr[%d] = %d \n", j, max_ptr[j]);
    printf ("\n");
    for (j = 1; j <= num; j++)
	printf ("min_ptr[%d] = %d \n", j, min_ptr[j]);
    printf ("\n");
}

init_q ()
{
    int             i, j;

    for (j = 0; j < MAX_CONVERSATIONS; j++)
    {
	head[j] = tail[j] = nilnode;
	num_in_q[j] = 0;
    }
}


dump_q (conv_id)
    int             conv_id;
{
    PKT_PTR         q_ptr;
    int             posn;

    if (num_in_q[conv_id] == 0)
	return;
    printf ("Queue for conversation %d\n", conv_id);
    q_ptr = head[conv_id];
    posn = 1;
    while (q_ptr != nilnode)
    {
	printf (" %d : data =  %f\n", posn, q_ptr->data);
	q_ptr = q_ptr->next;
	posn++;
    }
}


insert_in_q (data, conv_id)
    int             conv_id;
    float           data;
{
    PKT_PTR         pkt;

    pkt = (PKT_PTR) malloc ((unsigned) sizeof (PKT));
    pkt->data = data;
    pkt->next = head[conv_id];

    if (head[conv_id] isnt nilnode)
	head[conv_id]->prev = pkt;
    pkt->prev = nilnode;
    head[conv_id] = pkt;
    num_in_q[conv_id]++;
    if (num_in_q[conv_id] is 1)
    {
	tail[conv_id] = pkt;
	pkt->next = nilnode;
    }
}

delete_tail (conv_id)
    int             conv_id;
{
    PKT_PTR         save;

    if (tail[conv_id] is nilnode)	/* empty queue */
	return ERROR;
    save = tail[conv_id];
    tail[conv_id] = save->prev;
    if (tail[conv_id] != nilnode)
	tail[conv_id]->next = nilnode;
    free (save);
    num_in_q[conv_id]--;
    if (num_in_q[conv_id] is 0)
	head[conv_id] = nilnode;
}

delete_head (conv_id)
    int             conv_id;
{
    PKT_PTR         save;

    if (head[conv_id] is nilnode)
	return ERROR;
    save = head[conv_id];
    head[conv_id] = save->next;
    if (head[conv_id] != nilnode)
	head[conv_id]->prev = nilnode;
    free (save);
    num_in_q[conv_id]--;
    if (num_in_q[conv_id] is 0)
	tail[conv_id] = nilnode;
}
