/* *********************************************************************** */
/*   File:  distrib.h                                                      */
/*                                                                         */
/*       contents:  This file contains necessary definitions for the       */
/*                 distrib.cc file, so that the latter need not include    */
/*                 glob.h.  Definitions are needed for the various         */
/*                 available distributions, and for random number          */
/*                 generation.                                             */
/*                                                                         */
/* *********************************************************************** */

#define FIXED     0
#define UNIFORM   1
#define NORMAL    2
#define EXPNTL    3
#define ERLANG    4 
#define GAMMA     5
#define POISSON   6    /* not yet fixed */
#define BINOMIAL  7    /* not yet fixed */
#define BETA      8    /* not yet fixed */
#define LOGNORMAL 9    /* not yet fixed */
#define WEIBULL   10   /* not yet fixed */

#define srand(a)     srand48(a)
#define drand01()    drand48()

extern double drand48();


typedef struct {                       /* >>>> distrib_struc <<<< */
            char            type;
            double          param1;
            double          param2;
            double          min;
            double          max;
} distrib_struc;
         

extern double get_time();
