# This is the input for the assignment on switching and scheduling

# The real_params section is optional. Default definitions are in
# lang/lang.yacc
  
real_params {
	random_seed = 23;
	buffer_size = 40000;
#					bytes 	(different from REAL3.0)
	ftp_pkt_size = 500;
#                                       bytes
	ack_size = 40;
#                                       bytes
	end_simulation = 100;
#					simulation end time in seconds
	print_interval = 10;
#					print and flush statistics every 
#					print_interval seconds
       
	scale_factor = 1;
#					time scale factor; if scale factor =
#					1000, 1 simulated second = 1ms realtime
}

nodes{ 
# 					first define the default node type
#					all fields are optional
	default{
		function = ecn_sender1;
		dest = 7;
#					destination node to send to 
		start_time = 0,10000;
#					start node at seconds, microseconds
		plot = true;
#					set to true if you want to plot data
		num_pkts = 4;
#					number of packets to send 
		sch_policy = 2;	
#					for router nodes 
#					1 = fcfs
#					2 = roundrobin
#					3 = decbit
#					4 = fqbit
#					5 = hrr
		}

#				for each source, just need to specify
#				what is different compared to the default

	node 1 { function = ecn_sender1; dest = 7;}
	node 2 { function = ecn_sender2; dest = 8; start_time = 0,40000; }
	node 3 { function = ecn_sender3; dest = 9; start_time = 0,40000; }
	node 4 { function = ecn_sender1; dest = 10; start_time = 0,40000; }
	node 5 { function = ecn_router;}
	node 6 { function = ecn_router;}
	node 7 { function = ecn_receiver;}
	node 8 { function = ecn_receiver;}
	node 9 { function = ecn_receiver;}
	node 10 { function = ecn_receiver;}

}

edges{
	default {
		bandwidth = 400000;
#					in bits/sec
		latency = 10000;
#					in microseconds
		}
	{ 1 -> 5;}
	{ 2 -> 5;}
	{ 3 -> 5;}
	{ 4 -> 5;}
	{ 5 -> 6; bandwidth = 40000; latency = 1000000;}
	{ 6 -> 7;}
	{ 6 -> 8;}
	{ 6 -> 9;}
	{ 6 -> 10;}
}
