# This is a sample input file for the simulator
# it can also be found as lang/example.l
# To see if your simulator is OK, run it on this example as 
# simulate example.l
# Remember that your REALDIR environment variable should be set
# to something reasonable

# the header section is optional

header					
{
network: example;
version: 0;
}

# nest_params section is optional. Default passtime is 1 second
# default maxnodes is MAXNODES in config.h and default monitor is
# custom_monitor in kernel/monitor.c

nest_params {
	passtime = 1,0;
	maxnodes = 30;
	monitor = custom_monitor;
}

# real_params section is also optional. Default definitions are in
# lang/lang.yacc

real_params {
	inter_pkt_delay = 5.0;
#                                       seconds (optional - not used)
	random_seed = 25;
	buffer_size = 440000;
#					bytes 	(different from REAL3.0)
	ftp_pkt_size = 500;
#                                       bytes
	telnet_pkt_size = 40;
#					bytes
	ack_size = 40;
#                                       bytes
	ftp_window = 600;
#                                       packets
	telnet_window = 400;
#                                       packets
	decongestion_mechanism = 1;
#					1 = drop from tail
#					2 = drop from head
#					3 = drop from random position
	real_number  = 0;
#					used for distributed REAL
	router_node = 0;
#					used for distributed REAL
	util_time = 1.0;
#					time interval over which to 
#					measure router utilization (secs)
	diameter = 0.1;
#					diameter of LAN segment (secs)
	end_simulation = 10;
#					simulation end time in seconds
	print_interval = 1;
#					print and flush statistics every 
#					print_interval seconds
	scale_factor = 1;
#					time scale factor; if scale factor =
#					1000, 1 simulated second = 1ms realtime
}

nodes{ 
# 					first define the default node type
#					all fields are optional
	default{
		function = ecn_slave;
		dest = 1;
#					destination node to send to 
		start_time = 0,10000;
#					start node at seconds, microseconds
		plot = true ;
#					set to true if you want to plot data
		num_pkts = 100;
#					number of packets to send 

		average = 20000.0;
#					declared average rate in bits/sec
		}

#					for each source, just need to specify
#					what is different compared to the default
	node 1 { function = ecn_master;}
	node 2 { function = ecn_slave;}
	node 3 { function = ecn_slave;}
	node 4 { function = ecn_slave;}
	node 5 { function = ecn_slave;}
	node 6 { function = ecn_slave;} 
}

edges{
	default {
		bandwidth = 2000000;
#					in bits/sec
		latency = 0;
#					in microseconds
		}
	{ 1 -> 2;}
	{ 1 -> 3;}
	{ 1 -> 4;}
	{ 1 -> 5;}
	{ 1 -> 6;}
}
