#include "../src/nest.h"
#include "../src/defs.h"
#include "../src/graph.h"
#include "config.h"
#include "types.h"
#include "disreal.h"
#include "sockets.h"

/* size of send and receive buffers */

 /* creates a sending side  socket and returns a socket id */
int
create_send_connection (host, port)
    char           *host, *port;
{
    int             sock = -1;
    extern char    *inet_ntoa ();

    struct sockaddr_in master;
    struct hostent *hp;		/* host database entry */
    int             portno;	/* port number */
    int             status;	/* connection status */
    char            message[100];

    /* create a socket to the specified host and port */

    sock = socket (AF_INET, SOCK_STREAM, 0);

    if (sock is Error || sock == 0)
    {
	perror ("create_send : Can't create socket");
	return -1;
    }
    /* make it non blocking */
/*
    if (fcntl (sock, F_SETFL, O_NDELAY) is - 1)
    {
	perror("create_send: fcntl failed ");
	close (sock);
	sock = Error;
	return -1 ;
    }
*/
    /* set up server socket address structure */
    if ((hp = gethostbyname (host)) is 0)
    {
	perror ("create_send : Unknown host");
	close (sock);
	sock = Error;
	return -1;
    }
    portno = atoi (port);
    master.sin_family = AF_INET;
    bcopy (hp->h_addr, &(master.sin_addr.s_addr), hp->h_length);
    master.sin_port = htons (portno);
    /* if (status = connect (sock, &master, sizeof (master)) < 0) */
    while (status = connect (sock, &master, sizeof (master)) < 0)
    {
	printf ("waiting for connection to be established \n");
	sleep (1);
    }
    printf ("Connection established\n");
/*
    {
	perror ("create_send : Can't connect ");
	close (sock);
	sock = Error;
	return -1;
    }
*/
    if (setsockopt (sock, SOL_SOCKET, SO_REUSEADDR, NULL, 0) == -1)
    {
	perror ("set socket option SO_REUSEADDR");
	exit (1);
    }
    if (setsockopt (sock, SOL_SOCKET, (~SO_LINGER), NULL, 0) == -1)
    {
	perror ("set socket option SO_DONTLINGER");
	exit (1);
    }
    /* connection id ok */
    return sock;
}



/* creates a socket willing to accept any connection on port
    and returns the socket id */

int
create_receive_connection (port)
    char           *port;
{
    int             portno;
    int             nread, sock, length;
    struct sockaddr_in server;
    int             msgsock;

    portno = atoi (port);
    sock = socket (AF_INET, SOCK_STREAM, 0);
    if (sock < 0)
    {
	perror ("opening stream");
	return -1;
    }
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons (portno);

    if (bind (sock, &server, sizeof (server)))
    {
	perror ("binding");
	return -1;
    }
    length = sizeof (server);
    if (getsockname (sock, &server, &length))
    {
	perror ("getting sock name");
	return -1;
    }
    listen (sock, 5);
    printf ("Waiting for accept to unblock \n");
    msgsock = accept (sock, 0, 0);
    return msgsock;
}

/* returns a malloced string read in - remember to DELETE */

char           *
read_sock (sock)
    int             sock;
{
    int             nread, rval;
    char           *buf;

    buf = (char *) malloc ((unsigned) BUFSIZE);
    nread = 0;
    while (nread < BUFSIZE)
	if ((rval = read (sock, buf + nread, BUFSIZE - nread)) < 0)
	{
	    perror ("reading msg");
	    return;
	} else
	    nread += rval;
    return buf;
}

write_sock (sock, buf)
    int             sock;
    char           *buf;
{
    if (write (sock, buf, BUFSIZE) < 0)
	perror ("error in writing ");
}

pkt_to_stream (pkt, stream)
    PKT_PTR         pkt;
    char           *stream;
{
    writew (stream, pkt->gen_time.tv_sec);
    writew (stream, pkt->gen_time.tv_usec);
    writew (stream, pkt->source);
    writew (stream, pkt->dest);
    writew (stream, pkt->type);
    writew (stream, pkt->seq_no);
    writef (stream, pkt->alpha);
    writew (stream, pkt->timeout);
    writew (stream, pkt->s_time);
    writef (stream, pkt->size);
    writeb (stream, pkt->decbit);
    writef (stream, pkt->bid);
    writew (stream, pkt->arr_time.tv_sec);
    writew (stream, pkt->arr_time.tv_usec);
    writeb (stream, pkt->resent);
    writew (stream, pkt->next_in_q);
}

PKT_PTR
stream_to_pkt (stream)
    byte           *stream;
{

    PKT_PTR         pkt;
    int             magic;

    pkt = (PKT_PTR) malloc ((unsigned) sizeof (PKT));

    pkt->gen_time.tv_sec = readw (stream);
    pkt->gen_time.tv_usec = readw (stream);
    pkt->source = readw (stream);
    pkt->dest = readw (stream);
    pkt->type = readw (stream);
    pkt->seq_no = readw (stream);
    pkt->alpha = readf (stream);
    pkt->timeout = readw (stream);
    pkt->s_time = readw (stream);
    pkt->size = readf (stream);
    pkt->decbit = readb (stream);
    pkt->bid = readf (stream);
    pkt->arr_time.tv_sec = readw (stream);
    pkt->arr_time.tv_usec = readw (stream);
    pkt->resent = readb (stream);
    pkt->next_in_q = (PKT_PTR) readw (stream);

    return pkt;
}
