extern int             MASTER_DEBUG ;

/* This controls and coordinates all the single instances of REAL */
/* Written 11/11/88 S. Keshav UCB - Xerox PARC */

#include "../src/nest.h"
#include "../src/defs.h"
#include "../src/graph.h"
#include "config.h"
#include "types.h"
#include "disreal.h"
static int      send_sock[MAXREALS]; /* array starts at 1, indexed by realnum */

static int      num_reals = 0;
static int      done[MAXREALS];
extern char    *read_sock ();
int             read_mask;
extern int      create_read_mask ();

/*
packet format
----------------------------------------------------------------------
magic | type | real number | ccr id | time ccr sent it OR delay in receiving ccr
----------------------------------------------------------------------
*/

main ()
{
    int             ccrid, discard;
    int             sending_sock, sock, recvid, realnum;
    char           *message, *save, *reallysave;
    int             foo;

    /* message scans thru the list while reading, save scans thru while
     * writing, and reallysave really saves the start of the string */

    timev           send_time;
    timev           recv_time;

    initialize_master ();
    send_proceed_to_all ();


    while (1)
    {
	/* read the socket to see what is there */
	read_mask = create_read_mask ();
	select (8 * sizeof (read_mask), &read_mask, 0, 0, 0);
	sock = first (read_mask);
	reallysave = save = message = read_sock (sock);

	if (readw (message) == MAGIC)
	{
	    foo = readw (message);
	    switch (foo)
	    {
	    case PACKET:
		/* get the number of the real */
		realnum = readw (message);
		if (MASTER_DEBUG)
		{
		    if (realnum == 1)
			printf (">");
		    else
			printf ("<");
		}
		ccrid = readw (message);
		send_time.tv_sec = readw (message);
		send_time.tv_usec = readw (message);
		if (MASTER_DEBUG)
		    printf ("Master received a packet : realnum %d, ccrid %d \n",
			    realnum, ccrid);

		/* see when the receiver is supposed to get it */
		/* skip the gen time and source fields */
		discard = readw (message);
		discard = readw (message);
		discard = readw (message);
		recvid = readw (message);
		/* set delay should find out the delay and place it in
		 * send_time */
		set_delay (realnum, ccrid, recvid, &send_time);
		/* the only thing the monitor has to know is the message
		 * type (PACKET) and the delay time */
		writew (save, MAGIC);
		writew (save, PACKET);
		writew (save, (long) 0);
		writew (save, (long) 0);
		writew (save, send_time.tv_sec);
		writew (save, send_time.tv_usec);
/*IMPORTANT - change if pkt_type changes */
		save += 3 * sizeof (long);
/*IMPORTANT - change if pkt_type changes */
		/* skip over gen_time and source */
		/* write in the local node id */
		writew (save, map_global_to_local (realnum, ccrid, recvid));
		sending_sock = figure_out_sock (realnum, ccrid, recvid);
		if (sending_sock != 0)
		    write_sock (sending_sock, reallysave);
		else
		    printf ("Receiving machine does not exist \n");
		free (reallysave);
		break;
	    case END:
		realnum = readw (message);
		printf (" ! \n");
		if (MASTER_DEBUG)
		    printf ("Master received an END packet: realnum %d\n", realnum);
		note_done (realnum);
		if (all_really_done ())
		{
		    send_proceed_to_all ();
		    clear_done ();
		}
		break;
	    default:
		printf ("unknown type message \n");
	    }
	}
    }
}

initialize_master ()
{
    create_machine_list ();
    clear_done ();
    create_all_send_connections ();
    read_mask = create_read_mask ();
}

create_all_send_connections ()
{
    char           *name;
    int             realnum;

    while (step_machine (&name, &realnum) != 0)
	if ((send_sock[realnum] = create_send_connection (name, MASTER_PORT)) == -1)
	{
	    printf ("unable to create all connections : ABORT\n");
	    exit (0);
	} else
	    num_reals++;
}

send_proceed_to_all ()
{
    char            message[BUFSIZE];
    char           *save;
    int             i;

    if (MASTER_DEBUG)
	printf ("sending proceed to all \n");
    save = message;
    writew (save, MAGIC);
    writew (save, PROCEED);
    for (i = 1; i <= num_reals; i++)
	write_sock (send_sock[i], message);
}

all_really_done ()
{
    int             i;

    for (i = 1; i <= num_reals; i++)
	if (done[i] != 1)
	    return 0;
    return 1;
}

note_done (realnum)
    int             realnum;
{
    done[realnum] = 1;
}

clear_done ()
{
    int             i;

    for (i = 1; i <= num_reals; i++)
	done[i] = 0;
}

figure_out_sock (realnum, ccrid, recvid)
    int             realnum, ccrid, recvid;
{
    return send_sock[(int) recvid / ABSOLUTE_MAX_NODES];
}

map_global_to_local (realnum, ccrid, recvid)
    int             realnum, ccrid, recvid;
{
    return recvid;
}

set_delay (realnum, ccrid, recvid, send_time)
    int             realnum, ccrid, recvid;
    timev          *send_time;
{
    timev           delay;
    timev           now;
    timev           tmp;

    /* essentially, it is the delay between the two reals */
    /* assume that all the cc lines have a delay of 1.5s */

    now.tv_sec = send_time->tv_sec + 1;
    now.tv_usec = 0;

    delay.tv_sec = 1;
    delay.tv_usec = 500000;

    tmp = time_plus (*send_time, delay);
    tmp = time_minus (tmp, now);
    *send_time = time_normalize (tmp);
}


/*
main ()

{
    timev           test;

    test.tv_sec = 1;
    test.tv_usec = 300000;

    set_delay (1, 1, 1, &test);
    printf ("%ld  %ld\n", test.tv_sec, test.tv_usec);
}
*/

int
create_read_mask ()
{
    int             mask, i;

    mask = 0;
    for (i = 1; i <= num_reals; i++)
	if (send_sock[i] != 0)
	    mask |= 1 << send_sock[i];
    return mask;
}

first (mask)
    int             mask;
{
    int             i;

    for (i = 0; i < 8 * sizeof (mask); i++)
	if ((0x01 << i) & mask)
	    return i;
}

read_message (message)
    char           *message;
{
    printf ("MAGIC %d \n", readw (message));
    printf ("type %d \n", readw (message));
    printf ("realnum %d\n", readw (message));
    printf ("ccrid %d\n", readw (message));
    printf ("send.tv_sec %ld \n", readw (message));
    printf ("send.tv_usec %ld \n", readw (message));
    printf (" pkt->gen_time.tv_sec %d\n", readw (message));
    printf (" pkt->gen_time.tv_usec %d\n", readw (message));
    printf (" pkt->source %d\n", readw (message));
    printf (" pkt->dest %d\n", readw (message));
    printf (" pkt->type %d\n", readw (message));
    printf (" pkt->seq_no %d\n", readw (message));
    printf (" pkt->alpha %f\n", readf (message));
    printf (" pkt->timeout %d\n", readw (message));
    printf (" pkt->s_time %d\n", readw (message));
    printf (" pkt->size %f\n", readf (message));
    printf (" pkt->decbit %d\n", readb (message));
    printf (" pkt->bid %f\n", readf (message));
    printf (" pkt->arr_time.tv_sec %d\n", readw (message));
    printf (" pkt->arr_time.tv_usec %d\n", readw (message));
    printf (" pkt->resent %d\n", readb (message));
    printf (" pkt->next_in_q %d\n", readw (message));
}

clear_mask (read_mask, sock)
    int            *read_mask;
    int             sock;
{
    *read_mask = *read_mask & ~(1 << sock);
}
