 /* EXPORTS : int create_machine_list() step_machine(name,realnum)
  * 
  * create_machine_list creates a list of machines read from a file machine.h
  * returns the number of machines step_machine () will fill in the name
  * and realnum fields, these are char**name, and int * realnum. Name
  * points to an allocated space. returns 1 if more, 0 if no more names
  * 
  * MALLOCS : to create the machine list - no frees required
  * 
  * Written 11/11/88  S.Keshav UCB */

#include "../src/nest.h"
#include "../src/defs.h"
#include "../src/graph.h"
#include "config.h"
#include "types.h"
#include "disreal.h"

#define NULPTR 0

char            line[80];
FILE           *f, *fopen ();

create_machine_list ()
{
    int             realnum;
    int             count = 0;

    f = fopen ("machines.h", "r");
    while (fscanf (f, "%s %d %d", line, &realnum) != EOF)
    {
	add_machine (line, realnum);
	count++;
    }
    return count;
}

/* queueing stuff */
static MACHINE_PTR machine_head = (MACHINE_PTR) 0,
                machine_tail = (MACHINE_PTR) 0;
extern char    *strcpy ();

add_machine (name, realnum)
    int             realnum;
    char           *name;
{
    MACHINE_PTR     machine;

    machine = (MACHINE_PTR) malloc ((unsigned) sizeof (MACH));
    machine->machine = malloc ((unsigned) strlen (name) + 2);
    strcpy (machine->machine, name);
    machine->realnum = realnum;

    if (machine_head == (MACHINE_PTR) NULPTR)
	machine_head = machine;
    else
	machine_tail->next = machine;
    machine_tail = machine;
    machine->next = (MACHINE_PTR) NULPTR;
}

step_machine (name, realnum)
    int            *realnum;
    char          **name;
{
    static MACHINE_PTR mark;
    static          first = 1;

    if (first)
    {
	mark = machine_head;
	first = 0;
    }
    if (mark == (MACHINE_PTR) NULPTR)	/* end */
    {
	mark = machine_head;	/* reset */
	first = 1;
	return 0;
    } else
    {
	*name = mark->machine;
	*realnum = mark->realnum;
	mark = mark->next;
	return 1;
    }
}

/* testing ...
main ()
{
    char           *name;
    int             realnum;

    create_machine_list ();
    while (step_machine (&name, &realnum) != 0)
	printf ("%s  %d\n", name, realnum);
}
*/
