extern int             COORD_DEBUG;

 /* stuff used by the monitor to talk with the master */

#include "../src/nest.h"
#include "../src/defs.h"
#include "../src/graph.h"
#include "types.h"
#include "disreal.h"
#include "config.h"

#define NULPTR 0
static int      send_sock;
static char     message[BUFSIZE];
extern          pkt_to_stream ();
extern int      cntrl_skt;
extern PKT_PTR  stream_to_pkt ();

extern int      realnum;
extern ident    cc_router;

 /* set from screen, I suppose */
extern char    *read_sock ();
extern int      close_show ();

init_socks ()
{
    send_sock = create_receive_connection (MASTER_PORT);
}

coord (now)
    timev           now;

 /* now is used by deliver_packet */
{
    /* coordinate with other REALs */
    /* assume that init_socks() has been called already */

    char           *message;
    int             type, cont;


    cont = 1;
    send_all_packets ();
    if (COORD_DEBUG)
	printf ("sent all packets, ready to recv.\n");
    while (cont)
    {
	message = read_sock (send_sock);
	if (readw (message) == MAGIC)
	{
	    type = readw (message);
	    switch (type)
	    {
	    case PACKET:
		/* deliver gets 2 zeroes, then the time, then the packet
		 * itself */

		if (COORD_DEBUG)
		    printf (" received a packet \n");
		deliver_pkt (message, now);
		if (COORD_DEBUG)
		    printf (" packet delivered \n");
		break;
	    case PROCEED:
		cont = 0;
		break;
	    default:
		printf (" unknown message type received at coord \n");
		read_message (message);
	    }
	}
    }
}


send_all_packets ()
{
    int             ccrid;
    timev           now;
    PKT_PTR         pkt;
    char           *end_message, *foo;

    /* grab packets off the list and send them */
    while (get_cc_pkt (&pkt, &ccrid, &now) != 0)
	send_a_packet (pkt, ccrid, now);
    /* send the end message */
    end_message = foo = message;
    writew (end_message, MAGIC);
    writew (end_message, END);
    writew (end_message, realnum);
    writew (end_message, ccrid);
    writew (end_message, now.tv_sec);
    writew (end_message, now.tv_usec);
    /* read_message (foo); */
    write_sock (send_sock, message);
}

send_a_packet (pkt, ccrid, now)
    PKT_PTR         pkt;
    int             ccrid;
    timev           now;

{
    /* frame and send the packet */
    char           *wrtptr;

    wrtptr = message;
    /* create the header */
    writew (wrtptr, MAGIC);
    writew (wrtptr, PACKET);
    writew (wrtptr, realnum);
    /* a global */
    writew (wrtptr, ccrid);
    writew (wrtptr, now.tv_sec);
    writew (wrtptr, now.tv_usec);
    pkt_to_stream (pkt, wrtptr);

    write_sock (send_sock, message);
}

read_message (message)
    char           *message;
{
    printf ("MAGIC %d \n", readw (message));
    printf ("type %d \n", readw (message));
    printf ("realnum %d\n", readw (message));
    printf ("ccrid %d\n", readw (message));
    printf ("send.tv_sec %ld \n", readw (message));
    printf ("send.tv_usec %ld \n", readw (message));
    printf (" pkt->gen_time.tv_sec %d\n", readw (message));
    printf (" pkt->gen_time.tv_usec %d\n", readw (message));
    printf (" pkt->source %d\n", readw (message));
    printf (" pkt->dest %d\n", readw (message));
    printf (" pkt->type %d\n", readw (message));
    printf (" pkt->seq_no %d\n", readw (message));
    printf (" pkt->alpha %f\n", readf (message));
    printf (" pkt->timeout %d\n", readw (message));
    printf (" pkt->s_time %d\n", readw (message));
    printf (" pkt->size %f\n", readf (message));
    printf (" pkt->decbit %d\n", readb (message));
    printf (" pkt->bid %f\n", readf (message));
    printf (" pkt->arr_time.tv_sec %d\n", readw (message));
    printf (" pkt->arr_time.tv_usec %d\n", readw (message));
    printf (" pkt->resent %d\n", readb (message));
    printf (" pkt->next_in_q %d\n", readw (message));
}


deliver_pkt (message, now)
    char           *message;
    timev           now;

{
    timev           delay;
    PKT_PTR         pkt;
    long            weight;
    ident           dest;

    if (COORD_DEBUG)
	printf ("about the deliver a message \n");
    readw (message);
    readw (message);
    /* discard 1st two words */
    delay.tv_sec = readw (message);
    delay.tv_usec = readw (message);
    pkt = stream_to_pkt (message);
    weight = (delay.tv_sec * MILLION) + delay.tv_usec;
    dest = cc_router;
    /* global */
    own_reliable (dest, 0, dest, 0, pkt, weight, now);
    /* instead of delivering the packet, just put it in a q that the
     * cc_router can read from later */
    /* add_mon_pkt(pkt); */
    free (message);
}


/* queueing stuff for the packets */

FRAME_PTR       cc_head = 0, cc_tail = 0;

add_cc_pkt (pkt, ccrid, now)
    PKT_PTR         pkt;
    int             ccrid;
    timev           now;

{
    FRAME_PTR       frame;

    frame = (FRAME_PTR) malloc ((unsigned) sizeof (FRAME));
    frame->send_time = now;
    frame->pkt = pkt;
    frame->ccrid = ccrid;

    if (cc_head == NULPTR)
	cc_head = frame;
    else
	cc_tail->next = frame;
    cc_tail = frame;
    frame->next = NULPTR;
}



get_cc_pkt (pkt, ccrid, time)
    PKT_PTR        *pkt;
    int            *ccrid;
    timev          *time;

{
    FRAME_PTR       tptr;

    if (cc_head == NULPTR)	/* MT Q */
	return 0;
    if (cc_head == cc_tail)
	/* One element in Q */
    {
	tptr = cc_head;
	cc_head = cc_tail = NULPTR;
    } else
    {
	/* at least 2 elements */
	tptr = cc_head;
	cc_head = tptr->next;
	tptr->next = NULPTR;	/* Annul pointer */
    }
    *ccrid = tptr->ccrid;
    *time = tptr->send_time;
    *pkt = tptr->pkt;
    free (tptr);
    return 1;
}

/*  not used...

FRAME_PTR       mon_pkt_hd = 0, mon_pkt_tail = 0;

add_mon_pkt (pkt)
    PKT_PTR         pkt;

{
    FRAME_PTR       frame;

    frame = (FRAME_PTR) malloc ((unsigned) sizeof (FRAME));
    frame->pkt = pkt;
    frame->ccrid =0;

    if (mon_pkt_hd == NULPTR)
	mon_pkt_hd = frame;
    else
	mon_pkt_tail->next = frame;
    mon_pkt_tail = frame;
    frame->next = NULPTR;
}



get_mon_pkt (pkt)
    PKT_PTR        *pkt;

{
    FRAME_PTR       tptr;

    if (mon_pkt_hd == NULPTR)
	return 0;
    if (mon_pkt_hd == mon_pkt_tail)
    {
	tptr = mon_pkt_hd;
	mon_pkt_hd = mon_pkt_tail = NULPTR;
    } else
    {
	tptr = mon_pkt_hd;
	mon_pkt_hd = tptr->next;
	tptr->next = NULPTR;
    }
    *pkt = tptr->pkt;
    free (tptr);
    return 1;
}
*/

close_show (a)
    int             a;
{
    close (send_sock);
    printf ("closing sockets ... \n");
    exit (1);
}
