extern int             CC_DEBUG; 

#include "../src/nest.h"
#include "../src/graph.h"
#include "../src/defs.h"

#include "config.h"
#include "types.h"
#include "parameters.i"

extern          add_cc_pkt ();

real_router ()
{
    PKT_PTR         pkt;
    int             i, source;
    ident           dest, destn, sender;
    ident           node_number;
    long            key;

    stop_time ();
    node_number = get_node_id ();
    if (source_node_type[get_node_id ()] is - 1)
	/* first time this node has been executed */
    {
	source_node_type[get_node_id ()] = CC_ROUTER;
	printf ("cc_router: %d\n", get_node_id ());
    }
    for (ever)
    {
	/* get a packet */
	sender = recvm (&destn, &key, &pkt);
	if (CC_DEBUG)
	    printf ("cc router got a packet \n");

	if (pkt->type is FTP || pkt->type is TELNET || pkt->type is
	    ACK)
	{
	    if (pkt->dest / ABSOLUTE_MAX_NODES != realnum)
		add_cc_pkt (pkt, node_number, runtime ());
	    else
	    {
		dest = pkt->dest % ABSOLUTE_MAX_NODES;
		sendm (route[node_number][dest], 0, pkt);
	    }

	}
	/* else if (pkt->type is INT) { PKT_PTR         mon_pkt; int
	 * cont = 1;
	 * 
	 * while (cont) { get_mon_pkt (&mon_pkt); if (mon_pkt != 0) sendm
	 * (route[node_number][mon_pkt->dest % ABSOLUTE_MAX_NODES], 0,
	 * mon_pkt); else cont = 0; } free (pkt); } */
	else
	{
	    hold ();
	    free (pkt);
	    release (1);
	}
    }
}
